<?php
/*
 * test_271_codes.php
 *
 * Copyright 2016 Kevin McCormick <kevin@kt61p>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

class edih_271_codes
{
//
//public $code271 = array();
    private $code271 = array();
    private $ds = '';
    private $dr = '';
// the key_match array is a concept of matching code lists to
// segment elements when diferent segments are looking for the same
// code or reference lists
//  -- a very tedious project and immediately put on hold
//public $key_match = array('HCR04'=>array('CRC02');
//
    function __construct($component_separator, $repetition_separator)
    {
        //
        // echo "class edih_271_codes ds=$component_separator dr=$repetition_separator".PHP_EOL;
        //
        $this->ds = $component_separator;
        $this->dr = $repetition_separator;
        //
        $this->code271['BHT02'] = array(
        '13'=>'Request',
        '08'=>'Status',
        '06'=>'Confirmation',
        '11'=>'Response',
        '00'=>'Original',
        '18'=>'Reissue',
        '01'=>'Cancellation',
        '36'=>'Auth (Reply)'
        );

        // transaction type code
        $this->code271['BHT06'] = array(
        '18'=>'Response - no further updates',
        '19'=>'Response - further updates to follow',
        '31'=>'Subrogation Demand',
        'AT'=>'Administrative Action',
        'CH'=>'Chargeable',
        'DG'=>'Response',
        'RP'=>'Reporting',
        'RT'=>'Spend Down',
        'RU'=>'Medical Services Reservation',
        'TH'=>'Receipt Acknowledgment'
        );

        // AAA reject reason code
        $this->code271['AAA03'] = array(
        '04'=>'Authorized quantity exceeded',
        '15'=>'Required application data missing',
        '33'=>'Input Errors',
        '35'=>'Out of Network',
        '41'=>'Authorization/Access restrictions',
        '42'=>'Unable to respond at current time.',
        '43'=>'Invalid/Missing provider information',
        '44'=>'Invalid/Missing provider name',
        '45'=>'Invalid/Missing provider speciality',
        '46'=>'Invalid/Missing provider phone number',
        '47'=>'Invalid/Missing provider state',
        '48'=>'Invalid/Missing referring provider identification number',
        '49'=>'Provider is not primary care physician',
        '50'=>'Provider ineligible for inquiries',
        '51'=>'Provider not on file',
        '52'=>'Service dates not within provider plan enrollment',
        '53'=>'Inquired benefit inconsistent with provider type',
        '56'=>'Inappropriate date',
        '57'=>'Invalid/Missing dates of service',
        '58'=>'Invalid/Missing date of birth',
        '60'=>'Date of birth follows date of service',
        '61'=>'Date of death preceeds dates of service',
        '62'=>'Date of service not within allowable inquiry period',
        '63'=>'Date of service in future',
        '64'=>'Invalid/Missing patient ID',
        '65'=>'Invalid/Missing patient name',
        '66'=>'Invalid/Missing patient gender code',
        '67'=>'Patient not found',
        '69'=>'Inconsistent with patient age.',
        '70'=>'Inconsistent with patient gender.',
        '71'=>'Patient birth date does not match that for the patient in the database',
        '72'=>'Invalid/Missing subscriber/insured ID',
        '73'=>'Invalid/Missing subscriber/insured name',
        '74'=>'Invalid/Missing subscriber/insured gender code',
        '75'=>'Subscriber/Insured not found',
        '76'=>'Duplicate Subscriber/Insured ID number',
        '77'=>'Subscriber found, patient not found',
        '78'=>'Subscriber/Insured not in Group/Plan identified',
        '79'=>'Invalid participant identification',
        '97'=>'invalid or missing provider address',
        'T4'=>'Payer name or identifier missing',
        'T5'=>'Certification Information Missing',
        '80'=>'No response received by clearinghouse',
        '98'=>'Expiremental service or procedure.',
        'AA'=>'Authorization number not found.',
        'AE'=>'Requires primary care physician authorization.',
        'AF'=>'Invalid/Missing diagnosis codes.',
        'AG'=>'Invalid/Missing procedure codes.',
        'AO'=>'Additional patient condition information required.',
        'CI'=>'Certification information does not match patient.',
        'E8'=>'Requires medical review.',
        'IA'=>'Invalid authorization number format.',
        'MA'=>'Missing authorization number.'
        );



        // follow-up action code
        $this->code271['AAA04'] = array(
        'C'=>'Please correct and resubmit',
        'N'=>'Resubmission not allowed',
        'P'=>'Please resubmit original transaction',
        'R'=>'Resubmission allowed',
        'S'=>'Do not resubmit; Inquiry initiated to a third party',
        'W'=>'Please wait 30 days and resubmit',
        'X'=>'Please wait 10 days and resubmit',  // 'Y'=>'Do not resubmit; We will hold your request and respond again shortly'
        'Y'=>'Do not resubmit; We will respond again shortly'
        );

        // provider PRV codes
        $this->code271['PRV'] = array(
        'AD'=>'Admitting',
        'AT'=>'Attending',
        'BI'=>'Billing',
        'CO'=>'Consulting',
        'CV'=>'Covering',
        'H'=>'Hospital',
        'HH'=>'Home Health Care',
        'LA'=>'Laboratory',
        'OT'=>'Other Physician',
        'P1'=>'Pharmacy',
        'PC'=>'Primary Care Physician',
        'PE'=>'Performing',
        'R'=>'Rural Health Clinic',
        'RF'=>'Referring',
        'SB'=>'Sunmitting',
        'SK'=>'Skilled Nursing Facility',
        'SU'=>'Supervising'
        );


        // REF codes
        $this->code271['REF'] = array(
        "18" => "Plan Number",
        "1A" => "Blue Cross Provider Number",
        "1B" => "Blue Shield Provider Number",
        "1C" => "Medicare Provider Number",
        "1D" => "Medicaid Provider Number",
        "1G" => "Provider UPIN Number",
        "1H" => "CHAMPUS Identification Number",
        "1J" => "Facility ID Number",
        "1K" => "Payer Control Number",
        "1L" => "Group or Policy Number",
        "1W" => "Member ID Number",
        "1S" => "Ambulatory Patient Group (APG) Number",
        "2U" => "Payer Identification Number",
        "3H" => "Case Number",
        "49" => "Family Unit Number",
        "6P" => "Group Number",
        "6R" => "Provider Control Number",
        "9A" => "Repriced Claim Reference Number",
        "9C" => "Adjusted Repriced Claim Reference Number",
        "BB" => "Authorization Number",
        "BLT" => "Billing Type",
        "CE" => "Class of Contract code",
        "CT" => "Provider Contract Number",
        "D9" => "Clearinghouse ID Number",
        "D3" => "Natl Assn Bds of Pharm Number",
        "E9" => "Attachment Code",
        "EA" => "Medical Record ID Number",
        "EI" => "Employer's ID Number",
        "EJ" => "Patient Account Number",
        "EO" => "Submitter Identification Number",
        "EV" => "Receiver Identificaton Number",
        "F2" => "Version Identification Qualifier",
        "F6" => "Health Ins Claim (HIC) Number",
        "F8" => "Original Reference Number",
        "FJ" => "Service Item Information",
        "G1" => "Prior Authorization Number",
        "G2" => "Provider Commercial Number",
        "G3" => "Predetermination of Benefits ID Number",
        "G5" => "Provider Site Number",
        "GH" => "ID Card Serial Number",
        "HI" => "Health Industry Number (HIN)",
        "HJ" => "Identity Card Number",
        "HPI" => "CMMS Natl Provider ID",
        "IF" => "Issue Number",
        "IG" => "Ins Policy Number",
        "LU" => "Location Number",
        "N5" => "Provider Plan Network ID Number",
        "N6" => "Plan Network ID Number",
        "N7" => "Facility Network IID Number",
        "NF" => "Natl Assn of Ins Commissn (NAIC) Code",
        "NQ" => "Medicaid Recipient ID Number",
        "NT" => "Administrator's Reference Number",
        "0B" => "State License Number",
        "Q4" => "Prior Identifier Number",
        "RB" => "Rate Code Number",
        "SY" => "Social Security Number",
        "TJ" => "Fed Tax ID Number",
        "VV" => "Voucher Number",
        "XZ" => "Prescription Number",
        "Y4" => "Agency Claim Number",
        "ZH" => "Carrier Assigned Reference Number"
        );


        // DTP date qualifiers
        $this->code271['DTP'] = array(
        'ABC'=>'Estimated Date of Birth',
        'AAH'=>'Event',
        '007'=>'Effective',
        '036'=>'Expiration',
        '050'=>'Received',
        '096'=>'Discharge',
        '102'=>'Issue',
        '150'=>'Service period start',
        '151'=>'Service period end',
        '152'=>'Effective date of change',
        '232'=>'Claim stmt period start',
        '233'=>'Claim stmt period end',
        '291'=>'Plan',
        '303'=>'Maintenance effective',
        '307'=>'Eligibility',
        '318'=>'Added',
        '340'=>'COBRA begin',
        '341'=>'COBRA end',
        '342'=>'Premium paid to date begin',
        '343'=>'Premium paid to date end',
        '346'=>'Plan begin',
        '347'=>'Plan end',
        '348'=>'Benefit date',
        '349'=>'Benefit end',
        '356'=>'Eligibility begin',
        '357'=>'Eligibility end',
        '382'=>'Enrollment',
        '405'=>'Production',
        '435'=>'Admission',
        '431'=>'Onset of Current Symptoms or Illness',
        '439'=>'Accident',
        '442'=>'Date of death',
        '458'=>'Certification',
        '472'=>'Service',
        '484'=>'Last Menstrual Period',
        '539'=>'Policy effective',
        '540'=>'Policy expiration',
        '598'=>'Rejected',
        '636'=>'Date of last update',
        '771'=>'Status',
        );


        // entity identifier code  --code source 237
        // NM101 STC01-3 N101
        $this->code271['NM101'] = array(
        '03'=>'Dependent',
        '13'=>'Contracted Service Provider',
        '17'=>'Consultant\'s Office',
        '1E'=>'Health Maintenance Organization (HMO)',
        '1G'=>'Oncology Center',
        '1H'=>'Kidney Dialysis Unit',
        '1I'=>'Preferred Provider Organization (PPO)',
        '1O'=>'Acute Care Hospital',
        '1P'=>'Provider',
        '1Q'=>'Military facility',
        '1R'=>'University, College, or School',
        '1S'=>'Outpatient Surgicenter',
        '1T'=>'Physician, Clinic or Group Practice',
        '1U'=>'Long Term Care Facility',
        '1V'=>'Extended Care Facility',
        '1W'=>'Psychiatric Health Facility',
        '1X'=>'Laboratory',
        '1Y'=>'Retail Pharmacy',
        '2A'=>'Federal, State, County or City Facility',
        '2B'=>'Third-Party Administrator',
        '2I'=>'Church Operated Facility',
        '2P'=>'Public Health Service Facility',
        '2Q'=>'Veterans Administration Facility',
        '4M'=>'Adult Day Care Program Facility',
        '4R'=>'Geriatric Clinics',
        '5C'=>'Blood Bank',
        '5T'=>'X-Ray Radiation Therapy Unit',
        '5U'=>'CT Scanner Unit',
        '5V'=>'Diagnostic Radioisotope Facility',
        '5W'=>'Magnetic Resonance Imaging (MRI) Facility',
        '5X'=>'Ultrasound Unit',
        '5Y'=>'Rehabilitation Inpatient Unit',
        '5Z'=>'Rehabilitation Outpatient Services',
        '36'=>'Employer',
        '40'=>'Receiver',
        '41'=>'Submitter',
        '45'=>'Drop-off Location',
        '61'=>'Performed At',
        '6A'=>'Reproductive Health Services',
        '6G'=>'Sports Medicine Clinic/Services',
        '6O'=>'Physical Therapy Services',
        '6S'=>'Women\'s Health Center/Services',
        '6Y'=>'Case Manager',
        '70'=>'Prior Incorrect Insured',
        '71'=>'Attending Physician',
        '72'=>'Operating Physician',
        '73'=>'Other Physician',
        '74'=>'Corrected Insured',
        '75'=>'Participant',
        '77'=>'Service Location',
        '82'=>'Rendering Provider',
        '85'=>'Billing Provider',
        '87'=>'Pay-to Provider',
        'AAG'=>'Ground Ambulance Services',
        'AAJ'=>'Admitting Services',
        'AAK'=>'Primary Surgeon',
        'AAL'=>'Medical Nurse',
        'AAM'=>'Cardiac Rehabilitation Services',
        'AAN'=>'Skilled Nursing Services',
        'AAO'=>'Observation Room Services',
        'AAQ'=>'Anesthesiology Services',
        'CA'=>'Carrier',
        'DD'=>'Assistant Surgeon',
        'DK'=>'Ordering Physician',
        'DN'=>'Referring Provider',
        'EXS'=>'Ex-spouse',
        'FA'=>'Facility',
        'FS'=>'Final Scheduled Destination',
        'G3'=>'Clinic',
        'GB'=>'Other Insured',
        'GD'=>'Guardian',
        'GG'=>'Intermediary',
        'GM'=>'Spouse Insured',
        'GP'=>'Gateway Provider',
        'GW'=>'Group',
        'HF'=>'HPSA Facility',
        'HH'=>'Home Health Agency',
        'I3'=>'Independent Physicians Association (IPA)',
        'IL'=>'Insured or Subscriber',
        'IR'=>'Self Insured',
        'LR'=>'Legal Representative',
        'MSC'=>'Mammography Screening Center',
        'NCT'=>'Name Changed To',
        'ND'=>'Next Destination',
        'NZ'=>'Primary Physician',
        'OC'=>'Origin Carrier',
        'OO'=>'Alternate Insurer',
        'ORI'=>'Original Name',
        'P2'=>'Primary Insured or Subscriber',
        'P3'=>'Primary Care Provider',
        'P4'=>'Prior Insurance Carrier',
        'P5'=>'Plan Sponsor',
        'PE'=>'Payee',
        'PR'=>'Payer',
        'PRP'=>'Primary Payer',
        'PW'=>'Pickup Address',
        'QB'=>'Purchase Service Provider',
        'QC'=>'Patient',
        'QV'=>'Group Practice',
        'R3'=>'Next Scheduled Destination',
        'SEP'=>'Secondary Payer',
        'SJ'=>'Service Provider',
        'TT'=>'Transfer To',
        'TTP'=>'Tertiary Payer',
        'VER'=>'Party Performing Verification',
        'VN'=>'Vendor',
        'VY'=>'Organization Completing Configuration Change',
        'X3'=>'Utilization Management Organization',
        'X4'=>'Spouse',
        'Y2'=>'Managed Care Organization'
        );


        // entity ID type code
        // NM108  N101
        $this->code271['NM108'] = array(
        "AD"=>"BCBS Assoc Plan Code",
        "NI"=>"NAIC ID",
        "24"=>"Employer ID Number (EIN)",
        "34"=>"Social Security No",
        "46"=>"Electronic Transmiter ID (ETIN)",
        "BD"=>"Blue Cross Provider No",
        "BS"=>"Blue Shield Provider No",
        "C"=>"Insured's Changed Unique ID",
        "PC"=>"Provider Commercial No",
        "FI"=>"Federal Taxpayer ID",
        "II"=>"Standard Unique Health ID",
        "HN"=>"Health Ins Claim No",
        "MC"=>"Medicaid Provider No",
        "MI"=>"Member ID",
        "MR"=>"Medicaid Recipient ID No",
        "NI"=>"NAIC Identification",
        "PI"=>"Payer ID",
        "PP"=>"Pharmacy Processor No",
        "UP"=>"UPIN",
        "SV"=>"Service Provider Number",
        "XV"=>"CMS Plan ID",
        "XX"=>"CMS National ID"
        );

        // entity relationship code
        $this->code271['NM110'] = array(
        '01'=>'Parent',
        '02'=>'Child',
        '27'=>'Domestic Partner',
        '41'=>'Spouse',
        '48'=>'Employee',
        '65'=>'Other',
        '72'=>'Unknown'
        );

        //  contact number identifier
        $this->code271['PER03'] = array(
        'ED'=>'EDI Access Number',
        'EM'=>'Electronic Mail',
        'EX'=>'Telephone Extension',
        'FX'=>'Facsimile',
        'TE'=>'Telephone',
        'UR'=>'URL'
        );

        //  contact type identifier
        $this->code271['PER01'] = array(
        'CX'=>'Cliams Office',
        'BL'=>'Technical Dept',
        'IC'=>'Information Contact',
        );

        // MPI  qualifiers Military Service
        // the MPI03 Service affiliation qualifiers have 'SB' prepended
        $this->code271['MPI'] = array(
        'A'=>'Partial',
        'C'=>'Current',
        'L'=>'Latest',
        'O'=>'Oldest',
        'P'=>'Prior',
        'S'=>'Second most current',
        'T'=>'Third most current',
        'AE'=>'Active reserve',
        'AO'=>'Active military-overseas',
        'AS'=>'Academy student',
        'AT'=>'Presidential appointee',
        'CC'=>'Contractor',
        'DD'=>'Dishonorably discharges',
        'HD'=>'Honorably discharges',
        'IR'=>'Inactive reserve',
        'LX'=>'Leave of absence: military',
        'PE'=>'Plan to enlist',
        'RE'=>'REcommissioned',
        'RM'=>'Retired military-overseas',
        'RR'=>'Retired without recall',
        'RU'=>'REtired military-USA',
        'SBA'=>'Air Force',
        'SBB'=>'Air Force Reserves',
        'SBC'=>'Army',
        'SBD'=>'Army Reserves',
        'SBE'=>'Coast Guard',
        'SBF'=>'Marine Corps',
        'SBG'=>'Marine Corps Reserves',
        'SBH'=>'National Guard',
        'SBI'=>'Navy',
        'SBJ'=>'Navy Reserves',
        'SBK'=>'Other',
        'SBL'=>'Peace Corp',
        'SBM'=>'Regular Armed Forces',
        'SBN'=>'Reserves',
        'SBO'=>'U.S. Public Health Service',
        'SBQ'=>'Foreign Military',
        'SBR'=>'American Red Cross',
        'SBS'=>'Department of Defvense',
        'SBU'=>'Unites Services Organization',
        'SBW'=>'Military Sealift Command',
        'A1'=>'Admiral',
        'A2'=>'Airman',
        'A3'=>'Airman First Class',
        'B1'=>'Basic Airman',
        'B2'=>'Brigadier General',
        'C1'=>'Captain',
        'C2'=>'Chief Master Sergeant',
        'C3'=>'Chief Petty Officer',
        'C4'=>'Chief Warrant',
        'C5'=>'Colonel',
        'C6'=>'Commander',
        'C7'=>'Commodore',
        'C8'=>'Corporal',
        'C9'=>'Corporal Specialist 4',
        'E1'=>'Ensign',
        'F1'=>'First Lieutenant',
        'F2'=>'First Sergeant',
        'F3'=>'First Sergeant-Master Sergeant',
        'F4'=>'Fleet Admiral',
        'G1'=>'General',
        'G4'=>'Gunnery Sergeant',
        'L1'=>'Lance Corporal',
        'L2'=>'Lieutenant',
        'L3'=>'Lieutenant Colonel',
        'L4'=>'Lieutenant Commander',
        'L5'=>'Lieutenant General',
        'L6'=>'Lieutenant Junior Grade',
        'M1'=>'Major',
        'M2'=>'Major General',
        'M3'=>'Master Chief Petty Officer',
        'M4'=>'Master Gunnery Sergeant Major',
        'M5'=>'Master Sergeant',
        'M6'=>'Master Sergeant Specialist 8',
        'P1'=>'Petty Officer First Class',
        'P2'=>'Petty Officer Second Class',
        'P3'=>'Petty Officer Third Class',
        'P4'=>'Private',
        'P5'=>'Private First Class',
        'R1'=>'Rear Admiral',
        'R2'=>'Recruit',
        'S1'=>'Seaman',
        'S2'=>'Seaman Apprentice',
        'S3'=>'Seaman Recruit',
        'S4'=>'Second Lieutenant',
        'S5'=>'Senior Chief Petty Officer',
        'S6'=>'Senior Master Sergeant',
        'S7'=>'Sergeant',
        'S8'=>'Sergeant First Class Specialist 7',
        'S9'=>'Sergeant Major Specialist 9',
        'SA'=>'Sergeant Specialist 5',
        'SB'=>'Staff Sergeant',
        'SC'=>'Staff Sergeant Specialist 6',
        'T1'=>'Technical Sergeant',
        'V1'=>'Vice Admiral',
        'W1'=>'Warrant Officer'
        );

        // eligibility or benifit information code
        $this->code271['EB01'] = array(
        '1'=>'Active Coverage',
        '2'=>'Active-Full Risk Capitation',
        '3'=>'Active-Services Capitated',           //  '4'=>'Active - Services Capitated to Primary Care Physician',
        '4'=>'Active-Capitated to PCP',
        '5'=>'Active-Pending Investigation',
        '6'=>'Inactive',                            //  '7'=>'Inactive - Pending Eligibility Update',
        '7'=>'Inactive-Pending Elig Update',
        '8'=>'Inactive-Pending Investigation',
        'A'=>'Co-Insurance',
        'B'=>'Co-Payment',
        'C'=>'Deductible',
        'D'=>'Benefit Description',
        'E'=>'Exclusions',
        'F'=>'Limitations',
        'G'=>'Out of Pocket (Stop Loss)',
        'H'=>'Unlimited',
        'I'=>'Non-Covered',
        'J'=>'Cost Containment',
        'K'=>'Reserve',
        'L'=>'Primary Care Provider',
        'M'=>'Pre-existing Condition',
        'N'=>'Services Restricted to Following Provider',
        'O'=>'Not Deemed a Medical Necessity',
        'P'=>'Benefit Disclaimer',
        'Q'=>'Second Surgical Opinion Required',
        'R'=>'Other or Additional Payer',
        'S'=>'Prior Year(s) History',
        'T'=>'Card(s) Reported Lost/Stolen',        //  'U'=>'Contact Following Entity for Eligibility or Benefit Information',
        'U'=>'Contact Entity for Information',
        'V'=>'Cannot Process',
        'W'=>'Other Source of Data',
        'X'=>'Health Care Facility',
        'Y'=>'Spend Down',
        'CB'=>'Coverage Basis',
        'MC'=>'Managed Care Coordinator'
        );

        // coverage level code
        $this->code271['EB02'] = array(
        'CHD'=>'Children Only',
        'DEP'=>'Dependents Only',
        'E1D'=>'Employee and One Dependent',
        'E2D'=>'Employee and Two Dependents',
        'E3D'=>'Employee and Three Dependents',
        'E5D'=>'Employee and One or More Dependents',
        'E6D'=>'Employee and Two or More Dependents',
        'E7D'=>'Employee and Three or More Dependents',
        'E8D'=>'Employee and Four or More Dependents',
        'E9D'=>'Employee and Five or More Dependents',
        'ECH'=>'Employee and Children',
        'EMP'=>'Employee Only',
        'ESP'=>'Employee and Spouse',
        'FAM'=>'Family',
        'IND'=>'Individual',
        'SPC'=>'Spouse and Children',
        'SPO'=>'Spouse Only',
        'TWO'=>'Two Party'
        );

        // Health Care Services Type Codes
        // ASC X12 External Code Source 958  LAST UPDATED 3/1/2016
        $this->code271['EB03'] = array(
        "1" => "Medical Care",
        "2" => "Surgical",
        "3" => "Consultation",
        "4" => "Diagnostic X-Ray",
        "5" => "Diagnostic Lab",
        "6" => "Radiation Therapy",
        "7" => "Anesthesia",
        "8" => "Surgical Assistance",
        "10" => "Blood",
        "11" => "Durable Medical Equipment Used",
        "12" => "Durable Medical Equipment Purchased",
        "14" => "Renal Supplies",
        "17" => "Pre-Admission Testing",
        "18" => "Durable Medical Equipment Rental",
        "19" => "Pneumonia Vaccine",
        "20" => "Second Surgical Opinion",
        "21" => "Third Surgical Opinion",
        "22" => "Social Work",
        "23" => "Diagnostic Dental",
        "24" => "Periodontics",
        "25" => "Restorative",
        "26" => "Endodontics",
        "27" => "Maxillofacial Prosthetics",
        "28" => "Adjunctive Dental Services",
        "30" => "Health Benefit Plan Coverage",
        "32" => "Plan Waiting Period",
        "33" => "Chiropractic",
        "34" => "Chiropractic Modality",
        "35" => "Dental Care",
        "36" => "Dental Crowns",
        "37" => "Dental Accident",
        "38" => "Orthodontics",
        "39" => "Prosthodontics",
        "40" => "Oral Surgery",
        "41" => "Preventive Dental",
        "42" => "Home Health Care",
        "43" => "Home Health Prescriptions",
        "45" => "Hospice",
        "46" => "Respite Care",
        "47" => "Hospitalization",
        "48" => "Hospital - Inpatient",
        "49" => "Hospital - Room and Board",
        "50" => "Hospital - Outpatient",
        "54" => "Long Term Care",
        "55" => "Major Medical",
        "56" => "Medically Related Transportation",
        "60" => "General Benefits",
        "61" => "In-vitro Fertilization",
        "62" => "MRI Scan",
        "63" => "Donor Procedures",
        "64" => "Acupuncture",
        "65" => "Newborn Care",
        "66" => "Pathology",
        "67" => "Smoking Cessation",
        "68" => "Well Baby Care",
        "69" => "Maternity",
        "70" => "Transplants",
        "71" => "Audiology",
        "72" => "Inhalation Therapy",
        "73" => "Diagnostic Medical",
        "74" => "Private Duty Nursing",
        "75" => "Prosthetic Device",
        "76" => "Dialysis",
        "77" => "Otology",
        "78" => "Chemotherapy",
        "79" => "Allergy Testing",
        "80" => "Immunizations",
        "81" => "Routine Physical",
        "82" => "Family Planning",
        "83" => "Infertility",
        "84" => "Abortion",
        "85" => "HIV - AIDS Treatment",
        "86" => "Emergency Services",
        "87" => "Cancer Treatment",
        "88" => "Pharmacy",
        "89" => "Free Standing Prescription Drug",
        "90" => "Mail Order Prescription Drug",
        "91" => "Brand Name Prescription Drug",
        "92" => "Generic Prescription Drug",
        "93" => "Podiatry",
        "98" => "Professional (Physician) Visit - Office",
        "A4" => "Psychiatric",
        "A6" => "Psychotherapy",
        "A7" => "Psychiatric - Inpatient",
        "A8" => "Psychiatric - Outpatient",
        "A9" => "Rehabilitation",
        "AB" => "Rehabilitation - Inpatient",
        "AC" => "Rehabilitation - Outpatient",
        "AD" => "Occupational Therapy",
        "AE" => "Physical Medicine",
        "AF" => "Speech Therapy",
        "AG" => "Skilled Nursing Care",
        "AI" => "Substance Abuse",
        "AJ" => "Alcoholism Treatment",
        "AK" => "Drug Addiction",
        "AL" => "Optometry",
        "AM" => "Frames",
        "AO" => "Lenses",
        "AP" => "Routine Eye Exam",
        "AQ" => "Nonmedically Necessary Physical (e.g., insurance app, pilot license, employment or school)",
        "AR" => "Experimental Drug Therapy",
        "B1" => "Burn Care",
        "B2" => "Brand Name Prescription Drug - Formulary",
        "B3" => "Brand Name Prescription Drug - Non-Formulary",
        "BA" => "Independent Medical Evaluation",
        "BB" => "Psychiatric Treatment Partial Hospitalization",
        "BC" => "Day Care (Psychiatric)",
        "BD" => "Cognitive Therapy",
        "BE" => "Massage Therapy",
        "BF" => "Pulmonary Rehabilitation",
        "BG" => "Cardiac Rehabilitation",
        "BH" => "Pediatric",
        "BI" => "Nursery Room and Board",
        "BK" => "Orthopedic",
        "BL" => "Cardiac",
        "BM" => "Lymphatic",
        "BN" => "Gastrointestinal",
        "BP" => "Endocrine",
        "BQ" => "Neurology",
        "BT" => "Gynecological",
        "BU" => "Obstetrical",
        "BV" => "Obstetrical/Gynecological",
        "BW" => "Mail Order Prescription Drug: Brand Name",
        "BX" => "Mail Order Prescription Drug: Generic",
        "BY" => "Physician Visit - Sick",
        "BZ" => "Physician Visit - Well",
        "C1" => "Coronary Care",
        "CK" => "Screening X-ray",
        "CL" => "Screening laboratory",
        "CM" => "Mammogram, High Risk Patient",
        "CN" => "Mammogram, Low Risk Patient",
        "CO" => "Flu Vaccination",
        "CP" => "Eyewear Accessories",
        "CQ" => "Case Management",
        "DG" => "Dermatology",
        "DM" => "Durable Medical Equipment",
        "DS" => "Diabetic Supplies",
        "E0" => "Allied Behavioral Analysis Therapy",
        "E1" => "Non-Medical Equipment (non DME)",
        "E2" => "Psychiatric Emergency",
        "E3" => "Step Down Unit",
        "E4" => "Skilled Nursing Facility Head Level of Care",
        "E5" => "Skilled Nursing Facility Ventilator Level of Care",
        "E6" => "Level of Care 1",
        "E7" => "Level of Care 2",
        "E8" => "Level of Care 3",
        "E9" => "Level of Care 4",
        "E10" => "Radiographs",
        "E11" => "Diagnostic Imaging",
        "E12" => "Basic Restorative - Dental",
        "E13" => "Major Restorative - Dental",
        "E14" => "Fixed Prosthodontics",
        "E15" => "Removable Prosthodontics",
        "E16" => "Intraoral Images - Complete Series",
        "E17" => "Oral Evaluation",
        "E18" => "Dental Prophylaxis",
        "E19" => "Panoramic Images",
        "E20" => "Sealants",
        "E21" => "Flouride Treatments",
        "E22" => "Dental Implants",
        "E23" => "Temporomandibular Joint Dysfunction",
        "E24" => "Retail Pharmacy Prescription Drug",
        "E25" => "Long Term Care Pharmacy",
        "E26" => "Comprehensive Medication Therapy Management Review",
        "E27" => "Targeted Medication Therapy Management Review",
        "E28" => "Dietary/Nutritional Services",
        "E29" => "Technical Cardiac Rehabilitation Services Component",
        "E30" => "Professional Cardiac Rehabilitation Services Component",
        "E31" => "Professional Intensive Cardiac Rehabilitation Services Component",
        "E32" => "Intensive Cardiac Rehabilitation - Technical Component",
        "E33" => "Intensive Cardiac Rehabilitation",
        "E34" => "Pulmonary Rehabilitation - Technical Component",
        "E35" => "Pulmonary Rehabilitation - Professional Component",
        "E36" => "Convenience Care",
        "E37" => "Telemedicine",
        "E38" => "Pharmacist Services",
        "E39" => "Diabetic Education",
        "EA" => "Preventive Services",
        "EB" => "Specialty Pharmacy",
        "EC" => "Durable Medical Equipment New",
        "ED" => "CAT Scan",
        "EE" => "Ophthalmology",
        "EF" => "Contact Lenses",
        "F1" => "Medical Coverage",
        "F2" => "Social Work Coverage",
        "F3" => "Dental Coverage",
        "F4" => "Hearing Coverage",
        "F5" => "Prescription Drug Coverage",
        "F6" => "Vision Coverage",
        "F7" => "Orthodontia Coverage",
        "F8" => "Mental Health Coverage",
        "GF" => "Generic Prescription Drug - Formulary",
        "GN" => "Generic Prescription Drug - Non-Formulary",
        "GY" => "Allergy",
        "IC" => "Intensive Care",
        "MH" => "Mental Health",
        "NI" => "Neonatal Intensive Care",
        "ON" => "Oncology",
        "PE" => "Positron Emission Tomography (PET) Scan",
        "PT" => "Physical Therapy",
        "PU" => "Pulmonary",
        "RN" => "Renal",
        "RT" => "Residential Psychiatric Treatment",
        "SMH" => "Serious Mental Health",
        "TC" => "Transitional Care",
        "TN" => "Transitional Nursery Care",
        "UC" => "Urgent Care"
        );

        // insurance type codes
        $this->code271['EB04'] = array(
        'D'=>'Disability',
        //'12'=>'Medicare Secondary Working Aged Beneficiary or Spouse with Employer Group Health Plan',
        //'13'=>'Medicare Secondary End-Stage Renal Disease Beneficiary in the 12 month coordination period with an employer\'s group health plan',
        //'14'=>'Medicare Secondary, No-fault Insurance including Auto is Primary',
        //'15'=>'Medicare Secondary Worker\'s Compensation',
        //'16'=>'Medicare Secondary Public Health Service (PHS)or Other Federal Agency',
        //'41'=>'Medicare Secondary Black Lung',
        //'42'=>'Medicare Secondary Veteran\'s Administration',
        //'43'=>'Medicare Secondary Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)',
        //'47'=>'Medicare Secondary, Other Liability Insurance is Primary',
        '12'=>'Medicare Secondary',
        '13'=>'Medicare Secondary (ESRD)',
        '14'=>'Medicare Secondary (No-fault Primary)',
        '15'=>'Medicare Secondary (WC)',
        '16'=>'Medicare Secondary (PHS)',
        '41'=>'Medicare Secondary (Black Lung)',
        '42'=>'Medicare Secondary (VA)',
        '43'=>'Medicare Secondary (LGHP)',
        '47'=>'Medicare Secondary, Liability Ins Primary',
        'AP'=>'Auto Insurance Policy',
        'C1'=>'Commercial',             // 'CO'=>'Consolidated Omnibus Budget Reconciliation Act (COBRA)',
        'CO'=>'(COBRA)',
        'CP'=>'Medicare Conditionally Primary',
        'DB'=>'Disability Benefits',
        'EP'=>'Exclusive Provider Organization',
        'FF'=>'Family or Friends',
        'GP'=>'Group Policy',           //'HM'=>'Health Maintenance Organization (HMO)',
        'HM'=>'(HMO)',                  //'HN'=>'Health Maintenance Organization (HMO) - Medicare Risk',
        'HN'=>'(HMO)-Medicare Risk',    //'HS'=>'Special Low Income Medicare Beneficiary',
        'HS'=>'Special Low Income Medicare',
        'IN'=>'Indemnity',
        'IP'=>'Individual Policy',
        'LC'=>'Long Term Care',
        'LD'=>'Long Term Policy',
        'LI'=>'Life Insurance',
        'LT'=>'Litigation',
        'MA'=>'Medicare Part A',
        'MB'=>'Medicare Part B',
        'MC'=>'Medicaid',
        'MH'=>'Medigap Part A',
        'MI'=>'Medigap Part B',
        'MP'=>'Medicare Primary',
        'OT'=>'Other',                  //'PE'=>'Property Insurance - Personal',
        'PE'=>'Property Ins-Personal',
        'PL'=>'Personal',               //'PP'=>'Personal Payment (Cash - No Insurance)',
        'PP'=>'Cash (No Ins)',          //'PR'=>'Preferred Provider Organization (PPO)',
        'PR'=>'(PPO)',
        'PS'=>'Point of Service (POS)',
        'QM'=>'Qualified Medicare Beneficiary',
        'RP'=>'Property Insurance-Real',
        'SP'=>'Supplemental Policy',    //'TF'=>'Tax Equity Fiscal Responsibility Act (TEFRA)',
        'TF'=>'(TEFRA)',
        'WC'=>'Workers Compensation',
        'WU'=>'Wrap Up Policy'
        );

        // time period qualifier
        $this->code271['EB06'] = array(
        '1'=>'Month',
        '2'=>'Year',
        '6'=>'Hour',
        '7'=>'Day',
        '21'=>'Years',
        '22'=>'Service Year',
        '23'=>'Calendar Year',
        '24'=>'Year to Date',
        '25'=>'Contract',
        '26'=>'Episode',
        '27'=>'Visit',
        '28'=>'Outlier',
        '29'=>'Remaining',
        '30'=>'Exceeded',
        '31'=>'Not Exceeded',
        '33'=>'Lifetime Remaining',
        '34'=>'Month',
        '35'=>'Week',
        '36'=>'Admission',          //'A'=>'Hourly Appurtenance Units (Hours of Enhancement/Addition to Equipment)',
        'A'=>'Hourly Appurtenance Units',
        'D'=>'Daily Time Units',
        'H'=>'Hourly Time Units',
        'O'=>'Other Time Units'
        );

        // quantity type qualifier
        $this->code271['EB09'] = array(
        '8H'=>'Minimum',
        '99'=>'Quantity Used',
        'CA'=>'Covered-Actual',
        'CE'=>'Covered-Estimated',
        'D3'=>'Number of Co-insurance Days',
        'DB'=>'Deductible Blood Units',
        'DY'=>'Days',
        'HS'=>'Hours',
        'LA'=>'Life-time Reserve-Actual',
        'LE'=>'Life-time Reserve-Estimated',
        'M2'=>'Maximum',
        'MN'=>'Month',
        'P6'=>'Number of Services or Procedures',
        'QA'=>'Quantity Approved',
        'S7'=>'Age, High Value',
        'S8'=>'Age, Low Value',
        'VS'=>'Visits',
        'YY'=>'Years'
        );

        // authorization required code
        $this->code271['EB11'] = array(
        'N'=>'Pre-Auth: No',
        'U'=>'Pre-Auth: Unknown',
        'Y'=>'Pre-Auth: Yes'
        );

        // in-network status
        $this->code271['EB12'] = array(
        'N'=>'In Network: No',
        'U'=>'In Network: Unknown',
        'W'=>'In Network: N/A',
        'Y'=>'In Network: Yes'
        );

        // product/service id qualifier
        $this->code271['EB13'] = array(
        'AD'=>'Am Dental Assoc Codes',
        'ER'=>'Jurisdiction Specific',
        'CJ'=>'CPT Codes',
        'HC'=>'HCPCS Codes',
        'HP'=>'HIPPS SNF Rate Code',
        'ID'=>'ICD-9-CM-Procedure',
        'IV'=>'(HIEC) Product/Service Code',
        'N4'=>'Natl Drug Code 5-4-2 Fmt',
        'N6'=>'Natl Health Related Item Code in 4-6 Fmt',
        'NU'=>'Natl Uniform Billing Committee (NUBC) UB92',
        'UI'=>'U.P.C. Consumer Pkg Code (1-5-5)',
        'WK'=>'Advanced Billing Concepts (ABC) Codes',
        'ZZ'=>'Mutually Defined'
        );

        // quantity qualifier - unit or basis copde
        $this->code271['HSD01'] = array(
        'DY'=>'Days',
        'FL'=>'Units',
        'HS'=>'Hours',
        'MN'=>'Month',
        'VS'=>'Visit',
        'DA'=>'Days',
        'MO'=>'Months',
        'WK'=>'Week',
        'YR'=>'Years'
        );

        // delivery frequency code
        $this->code271['HSD07'] = array(
        '1'=>'1st Week of Month',
        '2'=>'2nd Week of Month',
        '3'=>'3rd Week of Month',
        '4'=>'4th Week of Month',
        '5'=>'5th Week of Month',
        '6'=>'1st & 3rd Weeks of Month',
        '7'=>'2nd & 4th Weeks of Month',
        '8'=>'1st Working Day of Period',
        '9'=>'Last Working Day of Period',
        'A'=>'Mon through Fri',
        'B'=>'Mon through Sat',
        'C'=>'Mon through Sun',
        'D'=>'Monday',
        'E'=>'Tuesday',
        'F'=>'Wednesday',
        'G'=>'Thursday',
        'H'=>'Friday',
        'J'=>'Saturday',
        'K'=>'Sunday',
        'L'=>'Mon through Thur',
        'M'=>'Immediately',
        'N'=>'As Directed',
        'O'=>'Daily Mon. through Fri.',
        'P'=>'1/2 Mon & 1/2 Thurs',
        'Q'=>'1/2 Tue & 1/2 Thur',
        'R'=>'1/2 Wed & 1/2 Fri',
        'S'=>'Once Anytime Mon through Fri',
        'T'=>'1/2 Tue & 1/2 Fri',
        'U'=>'1/2 Mon. & 1/2 Wed',
        'V'=>'1/3 Mon, 1/3 Wed, 1/3 Fri',
        'W'=>'When Necessary',
        'X'=>'1/2 By Wed, Bal. By Fri',
        'Y'=>'None/Cancel/Override',
        'Z'=>'Mutually Defined',
        'SA'=>'Sun, Mon, Thur, Fri, Sat',
        'SB'=>'Tue through Sat',
        'SC'=>'Sun, Wed, Thur, Fri, Sat',
        'SD'=>'Mon, Wed, Thur, Fri, Sat',
        'SG'=>'Tue through Fri',
        'SL'=>'Mon, Tue and Thur',
        'SP'=>'Mon, Tue and Fri',
        'SX'=>'Wed and Thur',
        'SY'=>'Mon, Wed and Thur',
        'SZ'=>'Tue, Thur and Fri',
        );

        // Ship/Delivery Pattern Time Code
        $this->code271['HSD08'] = array(
        'A'=>'1st Shift (9-5)',
        'B'=>'2nd Shift',
        'C'=>'3rd Shift',
        'D'=>'A.M.',
        'E'=>'P.M.',
        'F'=>'As Directed',
        'G'=>'Any Shift',
        'Y'=>'None/Cancel/Override',
        'Z'=>'Mutually Defined'
        );

        // Nature of Injury Codes
        $this->code271['IIIGR'] = array(
        '1'=>' No Physical Injury',
        '01'=>' No Physical Injury',
        '2'=>' Amputation',
        '02'=>' Amputation',
        '3'=>' Angina Pectoris',
        '03'=>' Angina Pectoris',
        '4'=>' Burn',
        '04'=>' Burn',
        '7'=>' Concussion',
        '07'=>' Concussion',
        '10'=>' Contusion',
        '13'=>' Crushing',
        '16'=>' Dislocation',
        '19'=>' Electric Shock',
        '22'=>' Enucleation',
        '25'=>' Foreign Body',
        '28'=>' Fracture',
        '30'=>' Freezing',
        '31'=>' Hearing Loss or Impairment',
        '32'=>' Heat Prostration',
        '34'=>' Hernia',
        '36'=>' Infection',
        '37'=>' Inflammation',
        '40'=>' Laceration',
        '41'=>' Myocardial Infarction',
        '42'=>' Poisoning-General',
        '43'=>' Puncture',
        '46'=>' Rupture',
        '47'=>' Severance',
        '49'=>' Sprain or Tear',
        '52'=>' Strain or Tear',
        '53'=>' Syncope',
        '54'=>' Asphyxiation',
        '55'=>' Vascular',
        '58'=>' Vision Loss',
        '59'=>' All Other Specific Injuries, NOC',
        '60'=>' Dust Disease, NOC',
        '61'=>' Asbestosis',
        '62'=>' Black Lung',
        '63'=>' Byssinosis',
        '64'=>' Silicosis',
        '65'=>' Respiratory Disorders',
        '66'=>' Poisoning-Chemical, (Other Than Metals)',
        '67'=>' Poisoning-Metal',
        '68'=>' Dermatitis',
        '69'=>' Mental Disorder',
        '70'=>' Radiation',
        '71'=>' All Other Occupational Disease Injury, NOC',
        '72'=>' Loss of Hearing',
        '73'=>' Contagious Disease',
        '74'=>' Cancer',
        '75'=>' AIDS',
        '76'=>' VDT-Related Diseases',
        '77'=>' Mental Stress',
        '78'=>' Carpal Tunnel Syndrome',
        '79'=>' Hepatitis C',
        '80'=>' All Other Cumulative Injury, NOC',
        '90'=>' Multiple Physical Injuries Only',
        '91'=>' Multiple Injuries Including Both Physical & Psychological'
        );


        // place of service  --code source 237
        $this->code271['POS'] = array(
        '01'=>'Pharmacy',
        '02'=>'Unassigned',
        '03'=>'School',
        '04'=>'Homeless Shelter',
        '05'=>'Indian Health Service Free-standing Facility',
        '06'=>'Indian Health Service Provider-based Facility',
        '07'=>'Tribal 638 Free-standing Facility',
        '08'=>'Tribal 638 Provider-based Facility',
        '09'=>'Prison/Correctional Facility',
        '11'=>'Office',
        '12'=>'Home ',
        '13'=>'Assisted Living Facility',
        '14'=>'Group Home',
        '15'=>'Mobile Unit',
        '16'=>'Temporary Lodging',
        '17'=>'Walk-in Retail Health Clinic',
        '20'=>'Urgent Care Facility',
        '21'=>'Inpatient Hospital',
        '22'=>'Outpatient Hospital',
        '23'=>'Emergency Room-Hospital',
        '24'=>'Ambulatory Surgical Center',
        '25'=>'Birthing Center',
        '26'=>'Military Treatment Facility',
        '31'=>'Skilled Nursing Facility',
        '32'=>'Nursing Facility',
        '33'=>'Custodial Care Facility',
        '34'=>'Hospice',
        '41'=>'Ambulance-Land',
        '42'=>'Ambulance-Air or Water',
        '49'=>'Independent Clinic',
        '50'=>'Federally Qualified Health Center',
        '51'=>'Inpatient Psychiatric Facility',
        '52'=>'Psychiatric Facility-Partial Hospitalization',
        '53'=>'Community Mental Health Center',
        '54'=>'Intermediate Care Facility/Mentally Retarded',
        '55'=>'Residential Substance Abuse Treatment Facility',
        '56'=>'Psychiatric Residential Treatment Center',
        '57'=>'Non-residential Substance Abuse Treatment Facility',
        '60'=>'Mass Immunization Center',
        '61'=>'Comprehensive Inpatient Rehabilitation Facility',
        '62'=>'Comprehensive Outpatient Rehabilitation Facility',
        '71'=>'Public Health Clinic',
        '72'=>'Rural Health Clinic',
        '81'=>'Independent Laboratory',
        '99'=>'Other Place of Service'
        );

        // insurance relationship code
        $this->code271['INS02'] = array(
        '18'=>'self',
        '01'=>'spouse',
        '19'=>'child',
        '20'=>'employee',
        '21'=>'unknown',
        '39'=>'Organ Donor',
        '40'=>'Cadaver Donor',
        '53'=>'Life Partner',
        'G8'=>'Other Relationship'
        );

        // 278 authorization Health Care Services Review
        $this->code271['UM01'] = array(
        'AR'=>'Admission review',
        'HS'=>'Health Services Review',
        'IN'=>'Individual',
        'SC'=>'Specialty Care review'
        );

        $this->code271['UM02'] = array(
        '1'=>'Appeal--Immediate',
        '2'=>'Appeal--Standard',
        '3'=>'Cancel',
        '4'=>'Extension',
        'I'=>'Initial',
        'N'=>'Reconsideration',
        'R'=>'Renewal',
        'S'=>'Revised'
        );

        // related causes code
        $this->code271['UM05'] = array(
        'AA'=>'Auto Accident',
        'AP'=>'Another Party responsible',
        'EM'=>'Employment'
        );

        // level of service code
        $this->code271['UM06'] = array(
        '03'=>'Emergency',
        'E'=>'Elective',
        'U'=>'Urgent'
        );

        // current patient condition code
        $this->code271['UM07'] = array(
        '1'=>'Acute',
        '2'=>'Stable',
        '3'=>'Chronic',
        '4'=>'Systemic',
        '5'=>'Localized',
        '6'=>'Mild Disease',
        '7'=>'Normal, Healthy',
        '8'=>'Severe Systemic Disease',
        '9'=>'Severe Systemic Disease Constant Threat to Life',
        'E'=>'Excellent',
        'F'=>'Fair',
        'G'=>'Good',
        'P'=>'Poor'
        );

        // prognosis code
        $this->code271['UM08'] = array(
        '1'=>'Poor',
        '2'=>'Guarded',
        '3'=>'Fair',
        '4'=>'Good',
        '5'=>'Very Good',
        '6'=>'Excellent',
        '7'=>'Less than 6 Months to Live',
        '8'=>'Terminal'
        );

        // delay reason code
        $this->code271['UM10'] = array(
        '1'=>'Proof of Eligibility Unknown',
        '2'=>'Litigation',
        '3'=>'Authorization Delays',
        '4'=>'Delay in Certifying Provider',
        '7'=>'Third Party Processing Delay',
        '8'=>'Delay in Eligibility Determination',
        '10'=>'Administration Delay in Prior Approval Process',
        '11'=>'Other',
        '15'=>'Natural Disaster',
        '16'=>'Lack of Information',
        '17'=>'No Response to Initial Request'
        );

        // certification action code
        $this->code271['HCR01'] = array(
        'A1'=>'Certified in total',
        'A2'=>'Certified - partial',
        'A3'=>'Not Certified',
        'A4'=>'Pended',
        'A6'=>'Modified',
        'C'=>'Cancelled',
        'CT'=>'Contact Payer',
        'NA'=>'No Action Required'
        );

        // health care decision reason code
        $this->code271['HCR03'] = array(
        '1'=>'Price Authorization Expired',
        '2'=>'Price authorization no longer required',
        '3'=>'Product not on the price authorization',
        '4'=>'Authorized Quantity Exceeded',
        '5'=>'Special Cost Incorrect',
        '6'=>'No Credit Allowed',
        '7'=>'Administrative Cancellation',
        '8'=>'Unit resale higher than authorized',
        '9'=>'Out of Network',
        '0A'=>'Testing not Included',
        '0B'=>'Request Forwarded To and Decision Response Forthcoming From an External Review Organization',
        '0C'=>'Authorization/Access Restrictions',
        '0D'=>'Requires PCP authorization',
        '0E'=>'Provider is Not Primary Care Physician',
        '0F'=>'Not Medically Necessary',
        '0G'=>'Level of Care Not Appropriate',
        '0H'=>'Certification Not Required for this Service',
        '0J'=>'Certification Responsibility of External Review Organization',
        '0K'=>'Primary Care Service',
        '0L'=>'Exceeds Plan Maximums',
        '0M'=>'Non-covered Service',
        '0N'=>'No Prior Approval',
        '0P'=>'Requested Information Not Received',
        '0Q'=>'Duplicate Request',
        '0R'=>'Service Inconsistent with Diagnosis',
        '0S'=>'Pre-existing Condition',
        '0T'=>'Experimental Service or Procedure',
        '0U'=>'Additional Patient Information required',
        '0V'=>'Requires Medical Review',
        '0W'=>'Disposition pending review',
        '0X'=>'Service Inconsistent with Provider Type',
        '0Y'=>'Service inconsistent with Patient\'s Age',
        '0Z'=>'Service inconsistent with Patient\'s Gender',
        '10'=>'Product/service/procedure delivery pattern (e.g., units, days, visits, weeks, hours, months)',
        '11'=>'Pricing',
        '12'=>'Patient is restricted to specific provider',
        '13'=>'Service authorized for another provider',
        '14'=>'Plan/contractual guidelines not followed',
        '15'=>'Plan/contractual geographic restriction',
        '16'=>'Inappropriate facility type',
        '17'=>'Time limits not met',
        '18'=>'Notification received',
        '19'=>'Cosmetic',
        '20'=>'Once in a lifetime restriction applies',
        '21'=>'Transport Request Denied',
        '22'=>'Ambulance Certification Segment information doesn\'t correspond to Transport Address Segment',
        '23'=>'Mileage cannot be computed based on data submitted',
        '24'=>'Computed mileage is inconsistent with transport information or service units submitted',
        '25'=>'Services were not considered due to other errors in the request.',
        '26'=>'Missing Provider Role',
        '27'=>'Patient in Health Insurance Exchange premium payment grace period -- first month.',
        '28'=>'Patient in Health Insurance Exchange premium payment grace period -- second month.',
        '29'=>'Patient in Health Insurance Exchange premium payment grace period -- third month.',
        );

        // yes/no condition code
        $this->code271['HCR04'] = array(
        'N'=>'No',
        'U'=>'Unknown',
        'W'=>'Not Applicable',
        'Y'=>'Yes'
        );


        // code source identifier code
        $this->code271['HI01'] = array(
        'ABF'=>'ICD-10-CM Diagnosis',
        'ABJ'=>'ICD-10-CM Admitting Diagnosis',
        'ABK'=>'ICD-10-CM Principal Diagnosis',
        'APR'=>'ICD-10-CM Patient Reason for Visit',
        'BF'=>'ICD-9-CM Diagnosis',
        'BJ'=>'ICD-9-CM Admitting Diagnosis',
        'BK'=>'ICD-9-CM Principal Diagnosis',
        'DR'=>'Diagnosis Related Group (DRG)',
        'PR'=>'ICD-9-CM Patient Reason for Visit',
        'LOI'=>'LOINC codes'
        );

        // code source identifier
        $this->code271['SV101'] = array(
        'HP'=>'Health Ins Prospective Pmt System',
        'N6'=>'National Health Related Item Code in 4-6 Format',
        'UI'=>'U.P.C. Consumer Package Code (1-5-5)',
        'AD'=>'Am Dental Assoc Codes.',
        'CJ'=>'CPT Codes',
        'DX'=>'(ICD-9-CM) Diagnosis',
        'EN'=>'EAN/UCC--13',
        'EO'=>'EAN/UCC--8',
        'ER'=>'Jurisdiction Specific Codes',
        'HC'=>'(HCPCS) Codes',
        'HI'=>'HIBC (HC Bar Code)', // Supplier Labeling Standard Primary Data Message',
        'HP'=>'(HIPPS) SNF Rate Code', //Health Insurance Prospective Payment System
        'ID'=>'(ICD-9-CM) - Procedure',
        'IV'=>'Home Infusion (HIEC) Code',
        'N4'=>'National Drug Code in 5-4-2 Format',
        'N6'=>'National Health Related Item Code in 4-6 Format',
        'NU'=>'National Uniform Billing Committee (NUBC) UB92 Codes',
        'ON'=>'Customer Order Number',
        'UI'=>'U.P.C. Consumer Package Code (1-5-5)',
        'UK'=>'GTIN 14-digit Data Structure',
        'UP'=>'UCC--12',
        'WK'=>'Advanced Billing Concepts (ABC) Codes',
        'ZZ'=>'Mutually Defined'
        );


        // code source identifier
        $this->code271['SV103'] = array(
        'DA'=>'Days',
        'F2'=>'International Unit',
        'MJ'=>'Minutes',
        'UN'=>'Unit'
        );

        // nursing home level of care
        $this->code271['SV120'] = array(
        '1'=>'Skilled Nursing Facility (SNF)',
        '2'=>'Intermediate Care Facility (ICF)',
        '3'=>'Intermediate Care Facility - Mentally Retarded (ICF-MR)',
        '4'=>'Chronic Disease Hospital (CD)',
        '5'=>'ntermediate Care Facility (ICF) Level II I',
        '6'=>'Special Skilled Nursing Facility (SNF)',
        '7'=>'Nursing Facility (NF)',
        '8'=>'Hospice'
        );


        // admission type code
        $this->code271['CL101'] = array(
        '1'=>'Emergency',
        '2'=>'Urgent',
        '3'=>'Elective',
        '4'=>'Newborn',
        '5'=>'Trauma',
        '9'=>'Information not available'
        );

        // admission source type code
        $this->code271['CL102'] = array(
        '1'=>'Physician Referral',
        '2'=>'Clinic Referral',
        '3'=>'HMO Referral',
        '4'=>'Transfer from a Hospital',
        '5'=>'Transfer from a Skilled Nursing Facility (SNF)',
        '6'=>'Transfer from Another Health Facility',
        '7'=>'Emergency Room',
        '8'=>'Court/Law Enforcement',
        '9'=>'Information Not Available',
        '10'=>'Transfer from Psych Substance Abuse or Rehab Hospital',
        '11'=>'Transfer from a Critical Access Hospital',
        'E'=>'Transfer from Ambulatory Surgical Center',
        'F'=>'Transfer from Hospice and is Under a Hospice Plan of Care or Enrolled in Hospice Program'
        );

        // release of information indicator code
        // -- which segment?
        //$this->code271['CL102'] = array(
        //'Y'=>'Yes',
        //'R'=>'Restricted or Modified Release',
        //'N'=>'No Release'
        //};



        // patient status code
        $this->code271['CL103'] = array(
        '1'=>'Discharged to Home or Self-Care (Routine Discharge)',
        '2'=>'Discharged/Transferred to Another Short-Term General Hospital',
        '3'=>'Discharged/Transferred to an SNF',
        '4'=>'Discharged/Transferred to an Intermediate Care Facility (ICF)',
        '5'=>'Discharged/Transferred to Another Type of Institution (Including Distinct Parts) or Referred for',
        '6'=>'Outpatient Services to Another Institution',
        '7'=>'Discharged/Transferred to Home Under Care of Organized Home Health Service Organization',
        '8'=>'Left Against Medical Advise or Discontinued Care',
        '9'=>'Discharged/Transferred to Home Under Care of Home IV Therapy Provider',
        '20'=>'Admitted as an Inpatient to this Hospital',
        '30'=>'Expired (or Did Not Recover-Christian Science Patient)',
        '40'=>'Expired at Home (for Hospice Care Only)',
        '41'=>'Expired in a Medical Facility such as a Hospital, SNF, ICF or Freestanding Hospice (for Hospice Care Only)',
        '42'=>'Expired, Place Unknown (for Hospice Care Only)',
        '50'=>'Discharged to Hospice-Home',
        '51'=>'Discharged to Hospice-Medical Facility',
        '61'=>'Discharged/transferred within this institution to a hospital based Medicare approved swing bed.',
        '62'=>'Discharged/transferred to an inpatient rehabilitation facility including distinct part units of a hospital',
        '63'=>'Discharged/transferred to a long term care hospital',
        '64'=>'Discharged/transferred to a nursing facility certified under Medicaid but not certified under Medicare.',
        '65'=>'Discharged/transferred to a psychiatric hospital or psychiatric distinct part unit of a hospital',
        '66'=>'Discharged/transferred to a Critical Access Hospital (CAH)',
        '69'=>'Discharged/transferred to a designated disaster alternative care site',
        '81'=>'Discharged to home or self-care with a planned acute care hospital inpatient readmission',
        '82'=>'Discharged/transferred to a short term general hospital for inpatient care with a planned acute care hospital inpatient readmission',
        '83'=>'Discharged/transferred to a skilled nursing facility (SNF) with Medicare certification with a planned acute care hospital inpatient readmission',
        '84'=>'Discharged/transferred to a facility that provides custodial or supportive care with a planned acute care hospital inpatient readmission',
        '85'=>'Discharged/transferred to a designated cancer center or children\'s hospital with a planned acute care hospital inpatient readmission',
        '86'=>'Discharged/transferred to home under care of organized home health service organization with a planned acute care hospital inpatient readmission',
        '87'=>'Discharged/transferred to court/law enforcement with a planned acute care hospital inpatient readmission',
        '88'=>'Discharged/transferred to a federal health care facility with a planned acute care hospital inpatient readmission',
        '89'=>'Discharged/transferred to a hospital-based Medicare approved swing bed with a planned acute care hospital inpatient readmission',
        '90'=>'Discharged/transferred to an inpatient rehabilitation facility (IRF) including rehabilitation distinct part units of a hospital with a planned acute care hospital inpatient readmission',
        '91'=>'Discharged/transferred to a Medicare certified long term care hospital (LTCH) with a planned acute care hospital inpatient readmission',
        '92'=>'Discharged/transferred to a nursing facility certified under Medicaid but not certified under Medicare with a planned acute care hospital inpatient readmission',
        '93'=>'Discharged/transferred to a psychiatric distinct part unit of a hospital with a planned acute care hospital inpatient readmission',
        '94'=>'Discharged/transferred to a critical access hospital (CAH) with a planned acute care hospital inpatient readmission',
        '95'=>'Discharged/transferred to another type of health care institution not defined elsewhere in this code list with a planned acute care hospital inpatient readmission'
        );

        // ambulance transport code
        $this->code271['CR103'] = array(
        'I'=>'Initial Trip',
        'R'=>'Return Trip',
        'T'=>'Transfer Trip',
        'X'=>'Round Trip'
        );


        // spinal subluxation level code
        $this->code271['CR203'] = array(
        'C1'=>'Cervical 1',
        'C2'=>'Cervical 2',
        'C3'=>'Cervical 3',
        'C4'=>'Cervical 4',
        'C5'=>'Cervical 5',
        'C6'=>'Cervical 6',
        'C7'=>'Cervical 7',
        'CO'=>'Coccyx',
        'IL'=>'Ilium',
        'L1'=>'Lumbar 1',
        'L2'=>'Lumbar 2',
        'L3'=>'Lumbar 3',
        'L4'=>'Lumbar 4',
        'L5'=>'Lumbar 5',
        'OC'=>'Occiput',
        'SA'=>'Sacrum',
        'T1'=>'Thoracic 1',
        'T2'=>'Thoracic 2',
        'T3'=>'Thoracic 3',
        'T4'=>'Thoracic 4',
        'T5'=>'Thoracic 5',
        'T6'=>'Thoracic 6',
        'T7'=>'Thoracic 7',
        'T8'=>'Thoracic 8',
        'T9'=>'Thoracic 9',
        'T10'=>'Thoracic 10',
        'T11'=>'Thoracic 11',
        'T12'=>'Thoracic 12'
        );

        // oxygen type code
        $this->code271['CR503'] = array(
        'A'=>'Concentrator',
        'B'=>'Liquid Stationary',
        'C'=>'Gaseous Stationary',
        'D'=>'Liquid Portable',
        'E'=>'Gaseous Portable',
        'O'=>'Other'
        );


        // oxygen delivery type code
        $this->code271['CR517'] = array(
        'A'=>'Nasal Cannula',
        'B'=>'Oxygen Conserving Device',
        'C'=>'Oxygen Conserving Device with Oxygen Pulse System',
        'D'=>'Oxygen Conserving Device with Reservoir System',
        'E'=>'Transtracheal Catheter'
        );


        // certification type code
        $this->code271['CR608'] = array(
        '1'=>'Appeal-Immediate',
        '2'=>'Appeal-Standard',
        '3'=>'Cancel',
        '4'=>'Extension',
        '5'=>'Notification',
        '6'=>'Verification',
        'I'=>'Initial',
        'R'=>'Renewal',
        'S'=>'Revised'
        );



        // paperwork type code
        $this->code271['PWK01'] = array(
        '3'=>' Report Justifying Treatment Beyond Utilization Guidelines',
        '4'=>' Drugs Administered',
        '5'=>' Treatment Diagnosis',
        '6'=>' Initial Assessment',
        '7'=>' Functional Goals',
        '8'=>' Plan of Treatment',
        '9'=>' Progress Report',
        '10'=>'Continued Treatment',
        '11'=>'Chemical Analysis',
        '13'=>'Certified Test Report',
        '15'=>'Justification for Admission',
        '21'=>'Recovery Plan',
        '48'=>'Social Security Benefit Letter',
        '55'=>'Rental Agreement',
        '59'=>'Benefit Letter',
        '77'=>'Support Data for Verification',
        'A3'=>'Allergies/Sensitivities Document',
        'A4'=>'Autopsy Report',
        'AM'=>'Ambulance Certification',
        'AS'=>'Admission Summary',
        'AT'=>'Purchase Order Attachment',
        'B2'=>'Prescription',
        'B3'=>'Physician Order',
        'BR'=>'Benchmark Testing Results',
        'BS'=>'Baseline',
        'BT'=>'Blanket Test Results',
        'CB'=>'Chiropractic Justification',
        'CK'=>'Consent Form(s)',
        'D2'=>'Drug Profile Document',
        'DA'=>'Dental Models',
        'DB'=>'Durable Medical Equipment Prescription',
        'DG'=>'Diagnostic Report',
        'DJ'=>'Discharge Monitoring Report',
        'DS'=>'Discharge Summary',
        'FM'=>'Family Medical History Document',
        'HC'=>'Health Certificate',
        'HR'=>'Health Clinic Records',
        'I5'=>'Immunization Record',
        'IR'=>'State School Immunization Records',
        'LA'=>'Laboratory Results',
        'M1'=>'Medical Record Attachment',
        'NN'=>'Nursing Notes',
        'OB'=>'Operative Note',
        'OC'=>'Oxygen Content Averaging Report',
        'OD'=>'Orders and Treatments Document',
        'OE'=>'Objective Physical Examination (including vital signs) Document',
        'OX'=>'Oxygen Therapy Certification',
        'P4'=>'Pathology Report',
        'P5'=>'Patient Medical History Document',
        'P6'=>'Periodontal Charts',
        'P7'=>'Periodontal Reports',
        'PE'=>'Parenteral or Enteral Certification',
        'PN'=>'Physical Therapy Notes',
        'PO'=>'Prosthetics or Orthotic Certification',
        'PQ'=>'Paramedical Results',
        'PY'=>'Physician Report',
        'PZ'=>'Physical Therapy Certification',
        'QC'=>'Cause and Corrective Action Report',
        'QR'=>'Quality Report',
        'RB'=>'Radiology Films',
        'RR'=>'Radiology Reports',
        'RT'=>'Report of Tests and Analysis Report',
        'RX'=>'Renewable Oxygen Content Averaging Report',
        'SG'=>'Symptoms Document',
        'V5'=>'Death Notification',
        'XP'=>'Photographs'
        );

        // paperwork delivery code
        $this->code271['PWK02'] = array(
        'BM'=>'By Mail',
        'EL'=>'Electronically Only',
        'EM'=>'E-Mail',
        'FX'=>'By Fax',
        'VO'=>'Voice'
        );


        // certification type code
        $this->code271['CRC01'] = array(
        '07'=>'Ambulance Certification',
        '08'=>'Chiropractic Certification',
        '09'=>'Durable Medical Equipment Certification'
        );

        //
        $this->code271['CRC03'] = array(
        '1'=>'Patient was admitted to a hospital',
        '2'=>'Patient was bed confined before the ambulance service',
        '3'=>'Patient was bed confined after the ambulance service',
        '4'=>'Patient was moved by stretcher',
        '5'=>'Patient was unconscious or in shock',
        '6'=>'Patient was transported in an emergency situation',
        '7'=>'Patient had to be physically restrained',
        '8'=>'Patient had visible hemorrhaging',
        '9'=>'Ambulance service was medically necessary',
        '10'=>'Patient is ambulatory',
        '11'=>'Ambulation is Impaired and Walking Aid is Used for Therapy or Mobility',
        '12'=>'Patient is confined to a bed or chair',
        '13'=>'Patient is Confined to a Room or an Area Without Bathroom Facilities',
        '14'=>'Ambulation is Impaired and Walking Aid is Used for Mobility',
        '15'=>'Patient Condition Requires Positioning of the Body or Attachments Which Would Not be Feasible With the Use of an Ordinary Bed',
        '16'=>'Patient needs a trapeze bar to sit up due to respiratory condition or change body positions for other medical reasons',
        '17'=>'Patient\'s Ability to Breathe is Severely Impaired',
        '18'=>'Patient condition requires frequent and/or immediate changes in body positions',
        '19'=>'Patient can operate controls',
        '20'=>'Siderails Are to be Attached to a Hospital Bed Owned by the Beneficiary',
        '21'=>'Patient owns equipment',
        '22'=>'Mattress or Siderails are Being Used with Prescribed Medically Necessary Hospital Bed Owned by the Beneficiary',
        '23'=>'Patient Needs Lift to Get In or Out of Bed or to Assist in Transfer from Bed to Wheelchair',
        '24'=>'Patient has an orthopedic impairment requiring traction equipment which prevents ambulation during period of use',
        '25'=>'Item has been prescribed as part of a planned regimen of treatment in patient home',
        '26'=>'Patient is highly susceptible to decubitus ulcers',
        '27'=>'Patient or a care-giver has been instructed in use of equipment',
        '29'=>'A 6-7 hour nocturnal study documents 30 episodes of apnea each lasting more than 10 seconds',
        '30'=>'Without the equipment, the patient would require surgery',
        '31'=>'Patient has had a total knee replacement',
        '32'=>'Patient has intractable lymphedema of the extremities',
        '33'=>'Patient is in a nursing home',
        '35'=>'This Feeding is the Only Form of Nutritional Intake for This Patient',
        '37'=>'Oxygen delivery equipment is stationary',
        '38'=>'Certification signed by the physician is on file at the supplier\'s office',
        '40'=>'Patient or Caregiver is Capable of Using the Equipment Without Technical or Professional Supervision',
        '41'=>'Patient or Caregiver is Unable to Propel or Lift a Standard Weight Wheelchair',
        '42'=>'Patient Requires Leg Elevation for Edema or Body Alignment',
        '43'=>'Patient Weight or Usage Needs Necessitate a Heavy Duty Wheelchair',
        '44'=>'Patient Requires Reclining Function of a Wheelchair',
        '45'=>'Patient is Unable to Operate a Wheelchair Manually',
        '46'=>'Patient or Caregiver Requires Side Transfer into Wheelchair, Commode or Other',
        '58'=>'Durable Medical Equipment (DME) Purchased New',
        '59'=>'Durable Medical Equipment (DME) Is Under Warranty',
        '60'=>'Transportation Was To the Nearest Facility',
        '9D'=>'Lack of Appropriate Facility within Reasonable Distance to Treat Patient in the Event of Complications',
        '9H'=>'Patient Requires Intensive IV Therapy',
        '9J'=>'Patient Requires Protective Isolation',
        '9K'=>'Patient Requires Frequent Monitoring',
        'IH'=>'Independent at Home',
        'LB'=>'Legally Blind',
        'SL'=>'Speech Limitations'
        );

        // Claim Status Category Codes
        // ASC X12 External Code Source 507  LAST UPDATED 7/1/2015
        $this->code271['HCCSCC'] = array(
        'A0' => 'Acknowledgement/Forwarded-The claim/encounter has been forwarded to another entity.',
        'A1' => 'Acknowledgement/Receipt-The claim/encounter has been received.',
        'A2' => 'Acknowledgement/Acceptance into adjudication system-The claim/encounter has been accepted into the adjudication system.',
        'A3' => 'Acknowledgement/Returned as unprocessable claim-The claim/encounter has been rejected and has not been entered into the adjudication system.',
        'A4' => 'Acknowledgement/Not Found-The claim/encounter can not be found in the adjudication system.',
        'A5' => 'Acknowledgement/Split Claim-The claim/encounter has been split upon acceptance into the adjudication system.',
        'A6' => 'Acknowledgement/Rejected for Missing Information - The claim/encounter is missing the information specified in the Status details and has been rejected.',
        'A7' => 'Acknowledgement/Rejected for Invalid Information - The claim/encounter has invalid information as specified in the Status details and has been rejected.',
        'A8' => 'Acknowledgement/Rejected for relational field in error.',
        // Pending
        'P0' => 'Pending: Adjudication/Details-This is a generic message about a pended claim.',
        'P1' => 'Pending/In Process-The claim or encounter is in the adjudication system.',
        'P2' => 'Pending/Payer Review-The claim/encounter is suspended and is pending review ',
        'P3' => 'Pending/Provider Requested Information - The claim or encounter is waiting for information that has already been requested from the provider.',
        'P4' => 'Pending/Patient Requested Information - The claim or encounter is waiting for information that has already been requested from the patient.',
        'P5' => 'Pending/Payer Administrative/System hold',
        // Finalized
        'F0' => 'Finalized-The claim/encounter has completed the adjudication cycle and no more action will be taken.',
        'F1' => 'Finalized/Payment-The claim/line has been paid.',
        'F2' => 'Finalized/Denial-The claim/line has been denied.',
        'F3' => 'Finalized/Revised - Adjudication information has been changed',
        'F3F' => 'Finalized/Forwarded-The claim/encounter processing has been completed.',
        'F3N' => 'Finalized/Not Forwarded-The claim/encounter processing has been completed.',
        'F4' => 'Finalized/Adjudication Complete - No payment forthcoming-The claim/encounter has been adjudicated and no further payment is forthcoming.',
        // Requests for additional information
        'R0' => 'Requests for additional Information/General Requests-Requests that don\'t fall into other R-type categories.',
        'R1' => 'Requests for additional Information/Entity Requests-Requests for information about specific entities ',
        'R3' => 'Requests for additional Information/Claim/Line-Requests for information that could normally be submitted on a claim.',
        'R4' => 'Requests for additional Information/Documentation-Requests for additional supporting documentation.',
        'R5' => 'Request for additional information/more specific detail-Additional information as a follow up to a previous request is needed.',
        'R6' => 'Requests for additional information – Regulatory requirements',
        'R7' => 'Requests for additional information – Confirm care is consistent with Health Plan policy coverage',
        'R8' => 'Requests for additional information – Confirm care is consistent with health plan coverage exceptions',
        'R9' => 'Requests for additional information – Determination of medical necessity',
        'R10' => 'Requests for additional information – Support a filed grievance or appeal',
        'R11' => 'Requests for additional information – Pre-payment review of claims',
        'R12' => 'Requests for additional information – Clarification or justification of use for specified procedure code',
        'R13' => 'Requests for additional information – Original documents submitted are not readable.',
        'R14' => 'Requests for additional information – Original documents received are not what was requested.',
        'R15' => 'Requests for additional information – Workers Compensation coverage determination.',
        'R16' => 'Requests for additional information – Eligibility determination',
        // General
        // Error
        'E0' => 'Response not possible - error on submitted request data',
        'E1' => 'Response not possible - System Status',
        'E2' => 'Information Holder is not responding; resubmit at a later time.',
        'E3' => 'Correction required - relational fields in error.',
        'E4' => 'Trading partner agreement specific requirement not met: Data correction required.',
        // Searches
        'D0' => 'Data Search Unsuccessful - The payer is unable to return status on the requested claim(s) based on the submitted search criteria.',
        );


        // Health Care Claim Status Codes
        // ASC X12 External Code Source 508  LAST UPDATED 3/1/2016
        $this->code271['HCCSC'] = array(
        "0" => "Cannot provide further status electronically.",
        "1" => "For more detailed information, see remittance advice.",
        "2" => "More detailed information in letter.",
        "3" => "Claim has been adjudicated and is awaiting payment cycle.",
        "6" => "Balance due from the subscriber.",
        "12" => "One or more originally submitted procedure codes have been combined.",
        "15" => "One or more originally submitted procedure code have been modified.",
        "16" => "Claim/encounter has been forwarded to entity.",
        "17" => "Claim/encounter has been forwarded by third party entity to entity.",
        "18" => "Entity received claim/encounter, but returned invalid status.",
        "19" => "Entity acknowledges receipt of claim/encounter.",
        "20" => "Accepted for processing.",
        "21" => "Missing or invalid information.",
        "23" => "Returned to Entity.",
        "24" => "Entity not approved as an electronic submitter.",
        "25" => "Entity not approved.",
        "26" => "Entity not found.",
        "27" => "Policy canceled.",
        "29" => "Subscriber and policy number/contract number mismatched.",
        "30" => "Subscriber and subscriber id mismatched.",
        "31" => "Subscriber and policyholder name mismatched.",
        "32" => "Subscriber and policy number/contract number not found.",
        "33" => "Subscriber and subscriber id not found.",
        "34" => "Subscriber and policyholder name not found.",
        "35" => "Claim/encounter not found.",
        "37" => "Predetermination is on file, awaiting completion of services.",
        "38" => "Awaiting next periodic adjudication cycle.",
        "39" => "Charges for pregnancy deferred until delivery.",
        "40" => "Waiting for final approval.",
        "41" => "Special handling required at payer site.",
        "42" => "Awaiting related charges.",
        "44" => "Charges pending provider audit.",
        "45" => "Awaiting benefit determination.",
        "46" => "Internal review/audit.",
        "47" => "Internal review/audit - partial payment made.",
        "49" => "Pending provider accreditation review.",
        "50" => "Claim waiting for internal provider verification.",
        "51" => "Investigating occupational illness/accident.",
        "52" => "Investigating existence of other insurance coverage.",
        "53" => "Claim being researched for Insured ID/Group Policy Number error.",
        "54" => "Duplicate of a previously processed claim/line.",
        "55" => "Claim assigned to an approver/analyst.",
        "56" => "Awaiting eligibility determination.",
        "57" => "Pending COBRA information requested.",
        "59" => "Information was requested by a non-electronic method.",
        "60" => "Information was requested by an electronic method.",
        "61" => "Eligibility for extended benefits.",
        "64" => "Re-pricing information.",
        "65" => "Claim/line has been paid.",
        "66" => "Payment reflects usual and customary charges.",
        "72" => "Claim contains split payment.",
        "73" => "Payment made to entity, assignment of benefits not on file.",
        "78" => "Duplicate of an existing claim/line, awaiting processing.",
        "81" => "Contract/plan does not cover pre-existing conditions.",
        "83" => "No coverage for newborns.",
        "84" => "Service not authorized.",
        "85" => "Entity not primary.",
        "86" => "Diagnosis and patient gender mismatch.",
        "88" => "Entity not eligible for benefits for submitted dates of service.",
        "89" => "Entity not eligible for dental benefits for submitted dates of service.",
        "90" => "Entity not eligible for medical benefits for submitted dates of service.",
        "91" => "Entity not eligible/not approved for dates of service.",
        "92" => "Entity does not meet dependent or student qualification.",
        "93" => "Entity is not selected primary care provider.",
        "94" => "Entity not referred by selected primary care provider.",
        "95" => "Requested additional information not received.",
        "96" => "No agreement with entity.",
        "97" => "Patient eligibility not found with entity.",
        "98" => "Charges applied to deductible.",
        "99" => "Pre-treatment review.",
        "100" => "Pre-certification penalty taken.",
        "101" => "Claim was processed as adjustment to previous claim.",
        "102" => "Newborn's charges processed on mother's claim.",
        "103" => "Claim combined with other claim(s).",
        "104" => "Processed according to plan provisions (Plan refers to provisions that exist between the Health Plan and the Consumer or Patient)",
        "105" => "Claim/line is capitated.",
        "106" => "This amount is not entity's responsibility.",
        "107" => "Processed according to contract provisions (Contract refers to provisions that exist between the Health Plan and a Provider of Health Care Services)",
        "109" => "Entity not eligible.",
        "110" => "Claim requires pricing information.",
        "111" => "At the policyholder's request these claims cannot be submitted electronically.",
        "114" => "Claim/service should be processed by entity.",
        "116" => "Claim submitted to incorrect payer.",
        "117" => "Claim requires signature-on-file indicator.",
        "121" => "Service line number greater than maximum allowable for payer.",
        "123" => "Additional information requested from entity.",
        "124" => "Entity's name, address, phone and id number.",
        "125" => "Entity's name.",
        "126" => "Entity's address.",
        "127" => "Entity's Communication Number.",
        "128" => "Entity's tax id.",
        "129" => "Entity's Blue Cross provider id.",
        "130" => "Entity's Blue Shield provider id.",
        "131" => "Entity's Medicare provider id.",
        "132" => "Entity's Medicaid provider id.",
        "133" => "Entity's UPIN.",
        "134" => "Entity's CHAMPUS provider id.",
        "135" => "Entity's commercial provider id.",
        "136" => "Entity's health industry id number.",
        "137" => "Entity's plan network id.",
        "138" => "Entity's site id .",
        "139" => "Entity's health maintenance provider id (HMO).",
        "140" => "Entity's preferred provider organization id (PPO).",
        "141" => "Entity's administrative services organization id (ASO).",
        "142" => "Entity's license/certification number.",
        "143" => "Entity's state license number.",
        "144" => "Entity's specialty license number.",
        "145" => "Entity's specialty/taxonomy code.",
        "146" => "Entity's anesthesia license number.",
        "147" => "Entity's qualification degree/designation (e.g. RN,PhD,MD).",
        "148" => "Entity's social security number.",
        "149" => "Entity's employer id.",
        "150" => "Entity's drug enforcement agency (DEA) number.",
        "152" => "Pharmacy processor number.",
        "153" => "Entity's id number.",
        "154" => "Relationship of surgeon & assistant surgeon.",
        "155" => "Entity's relationship to patient.",
        "156" => "Patient relationship to subscriber",
        "157" => "Entity's Gender.",
        "158" => "Entity's date of birth.",
        "159" => "Entity's date of death.",
        "160" => "Entity's marital status.",
        "161" => "Entity's employment status.",
        "162" => "Entity's health insurance claim number (HICN).",
        "163" => "Entity's policy number.",
        "164" => "Entity's contract/member number.",
        "165" => "Entity's employer name, address and phone.",
        "166" => "Entity's employer name.",
        "167" => "Entity's employer address.",
        "168" => "Entity's employer phone number.",
        "170" => "Entity's employee id.",
        "171" => "Other insurance coverage information (health, liability, auto, etc.).",
        "172" => "Other employer name, address and telephone number.",
        "173" => "Entity's name, address, phone, gender, DOB, marital status, employment status and relation to subscriber.",
        "174" => "Entity's student status.",
        "175" => "Entity's school name.",
        "176" => "Entity's school address.",
        "177" => "Transplant recipient's name, date of birth, gender, relationship to insured.",
        "178" => "Submitted charges.",
        "179" => "Outside lab charges.",
        "180" => "Hospital s semi-private room rate.",
        "181" => "Hospital s room rate.",
        "182" => "Allowable/paid from other entities coverage NOTE: This code requires the use of an entity code.",
        "183" => "Amount entity has paid.",
        "184" => "Purchase price for the rented durable medical equipment.",
        "185" => "Rental price for durable medical equipment.",
        "186" => "Purchase and rental price of durable medical equipment.",
        "187" => "Date(s) of service.",
        "188" => "Statement from-through dates.",
        "189" => "Facility admission date",
        "190" => "Facility discharge date",
        "191" => "Date of Last Menstrual Period (LMP)",
        "192" => "Date of first service for current series/symptom/illness.",
        "193" => "First consultation/evaluation date.",
        "194" => "Confinement dates.",
        "195" => "Unable to work dates/Disability Dates.",
        "196" => "Return to work dates.",
        "197" => "Effective coverage date(s).",
        "198" => "Medicare effective date.",
        "199" => "Date of conception and expected date of delivery.",
        "200" => "Date of equipment return.",
        "201" => "Date of dental appliance prior placement.",
        "202" => "Date of dental prior replacement/reason for replacement.",
        "203" => "Date of dental appliance placed.",
        "204" => "Date dental canal(s) opened and date service completed.",
        "205" => "Date(s) dental root canal therapy previously performed.",
        "206" => "Most recent date of curettage, root planing, or periodontal surgery.",
        "207" => "Dental impression and seating date.",
        "208" => "Most recent date pacemaker was implanted.",
        "209" => "Most recent pacemaker battery change date.",
        "210" => "Date of the last x-ray.",
        "211" => "Date(s) of dialysis training provided to patient.",
        "212" => "Date of last routine dialysis.",
        "213" => "Date of first routine dialysis.",
        "214" => "Original date of prescription/orders/referral.",
        "215" => "Date of tooth extraction/evolution.",
        "216" => "Drug information.",
        "217" => "Drug name, strength and dosage form.",
        "218" => "NDC number.",
        "219" => "Prescription number.",
        "222" => "Drug dispensing units and average wholesale price (AWP).",
        "223" => "Route of drug/myelogram administration.",
        "224" => "Anatomical location for joint injection.",
        "225" => "Anatomical location.",
        "226" => "Joint injection site.",
        "227" => "Hospital information.",
        "228" => "Type of bill for UB claim",
        "229" => "Hospital admission source.",
        "230" => "Hospital admission hour.",
        "231" => "Hospital admission type.",
        "232" => "Admitting diagnosis.",
        "233" => "Hospital discharge hour.",
        "234" => "Patient discharge status.",
        "235" => "Units of blood furnished.",
        "236" => "Units of blood replaced.",
        "237" => "Units of deductible blood.",
        "238" => "Separate claim for mother/baby charges.",
        "239" => "Dental information.",
        "240" => "Tooth surface(s) involved.",
        "241" => "List of all missing teeth (upper and lower).",
        "242" => "Tooth numbers, surfaces, and/or quadrants involved.",
        "243" => "Months of dental treatment remaining.",
        "244" => "Tooth number or letter.",
        "245" => "Dental quadrant/arch.",
        "246" => "Total orthodontic service fee, initial appliance fee, monthly fee, length of service.",
        "247" => "Line information.",
        "249" => "Place of service.",
        "250" => "Type of service.",
        "251" => "Total anesthesia minutes.",
        "252" => "Entity's authorization/certification number.",
        "254" => "Principal diagnosis code.",
        "255" => "Diagnosis code.",
        "256" => "DRG code(s).",
        "257" => "ADSM-III-R code for services rendered.",
        "258" => "Days/units for procedure/revenue code.",
        "259" => "Frequency of service.",
        "260" => "Length of medical necessity, including begin date.",
        "261" => "Obesity measurements.",
        "262" => "Type of surgery/service for which anesthesia was administered.",
        "263" => "Length of time for services rendered.",
        "264" => "Number of liters/minute & total hours/day for respiratory support.",
        "265" => "Number of lesions excised.",
        "266" => "Facility point of origin and destination - ambulance.",
        "267" => "Number of miles patient was transported.",
        "268" => "Location of durable medical equipment use.",
        "269" => "Length/size of laceration/tumor.",
        "270" => "Subluxation location.",
        "271" => "Number of spine segments.",
        "272" => "Oxygen contents for oxygen system rental.",
        "273" => "Weight.",
        "274" => "Height.",
        "275" => "Claim.",
        "276" => "UB04/HCFA-1450/1500 claim form",
        "277" => "Paper claim.",
        "279" => "Claim/service must be itemized",
        "281" => "Related confinement claim.",
        "282" => "Copy of prescription.",
        "283" => "Medicare entitlement information is required to determine primary coverage",
        "284" => "Copy of Medicare ID card.",
        "286" => "Other payer's Explanation of Benefits/payment information.",
        "287" => "Medical necessity for service.",
        "288" => "Hospital late charges",
        "290" => "Pre-existing information.",
        "291" => "Reason for termination of pregnancy.",
        "292" => "Purpose of family conference/therapy.",
        "293" => "Reason for physical therapy.",
        "294" => "Supporting documentation.",
        "295" => "Attending physician report.",
        "296" => "Nurse's notes.",
        "297" => "Medical notes/report.",
        "298" => "Operative report.",
        "299" => "Emergency room notes/report.",
        "300" => "Lab/test report/notes/results.",
        "301" => "MRI report.",
        "305" => "Radiology/x-ray reports and/or interpretation",
        "306" => "Detailed description of service.",
        "307" => "Narrative with pocket depth chart.",
        "308" => "Discharge summary.",
        "310" => "Progress notes for the six months prior to statement date.",
        "311" => "Pathology notes/report.",
        "312" => "Dental charting.",
        "313" => "Bridgework information.",
        "314" => "Dental records for this service.",
        "315" => "Past perio treatment history.",
        "316" => "Complete medical history.",
        "318" => "X-rays/radiology films",
        "319" => "Pre/post-operative x-rays/photographs.",
        "320" => "Study models.",
        "322" => "Recent Full Mouth X-rays",
        "323" => "Study models, x-rays, and/or narrative.",
        "324" => "Recent x-ray of treatment area and/or narrative.",
        "325" => "Recent fm x-rays and/or narrative.",
        "326" => "Copy of transplant acquisition invoice.",
        "327" => "Periodontal case type diagnosis and recent pocket depth chart with narrative.",
        "329" => "Exercise notes.",
        "330" => "Occupational notes.",
        "331" => "History and physical.",
        "333" => "Patient release of information authorization.",
        "334" => "Oxygen certification.",
        "335" => "Durable medical equipment certification.",
        "336" => "Chiropractic certification.",
        "337" => "Ambulance certification/documentation.",
        "339" => "Enteral/parenteral certification.",
        "340" => "Pacemaker certification.",
        "341" => "Private duty nursing certification.",
        "342" => "Podiatric certification.",
        "343" => "Documentation that facility is state licensed and Medicare approved as a surgical facility.",
        "344" => "Documentation that provider of physical therapy is Medicare Part B approved.",
        "345" => "Treatment plan for service/diagnosis",
        "346" => "Proposed treatment plan for next 6 months.",
        "352" => "Duration of treatment plan.",
        "353" => "Orthodontics treatment plan.",
        "354" => "Treatment plan for replacement of remaining missing teeth.",
        "360" => "Benefits Assignment Certification Indicator",
        "363" => "Possible Workers' Compensation",
        "364" => "Is accident/illness/condition employment related?",
        "365" => "Is service the result of an accident?",
        "366" => "Is injury due to auto accident?",
        "374" => "Is prescribed lenses a result of cataract surgery?",
        "375" => "Was refraction performed?",
        "380" => "CRNA supervision/medical direction.",
        "382" => "Did provider authorize generic or brand name dispensing?",
        "383" => "Nerve block use (surgery vs. pain management)",
        "384" => "Is prosthesis/crown/inlay placement an initial placement or a replacement?",
        "385" => "Is appliance upper or lower arch & is appliance fixed or removable?",
        "386" => "Orthodontic Treatment/Purpose Indicator",
        "387" => "Date patient last examined by entity.",
        "388" => "Date post-operative care assumed",
        "389" => "Date post-operative care relinquished",
        "390" => "Date of most recent medical event necessitating service(s)",
        "391" => "Date(s) dialysis conducted",
        "394" => "Date(s) of most recent hospitalization related to service",
        "395" => "Date entity signed certification/recertification",
        "396" => "Date home dialysis began",
        "397" => "Date of onset/exacerbation of illness/condition",
        "398" => "Visual field test results",
        "400" => "Claim is out of balance",
        "401" => "Source of payment is not valid",
        "402" => "Amount must be greater than zero.",
        "403" => "Entity referral notes/orders/prescription",
        "406" => "Brief medical history as related to service(s)",
        "407" => "Complications/mitigating circumstances",
        "408" => "Initial certification",
        "409" => "Medication logs/records (including medication therapy)",
        "414" => "Necessity for concurrent care (more than one physician treating the patient)",
        "417" => "Prior testing, including result(s) and date(s) as related to service(s)",
        "419" => "Individual test(s) comprising the panel and the charges for each test",
        "420" => "Name, dosage and medical justification of contrast material used for radiology procedure",
        "428" => "Reason for transport by ambulance",
        "430" => "Nearest appropriate facility",
        "431" => "Patient's condition/functional status at time of service.",
        "432" => "Date benefits exhausted",
        "433" => "Copy of patient revocation of hospice benefits",
        "434" => "Reasons for more than one transfer per entitlement period",
        "435" => "Notice of Admission",
        "441" => "Entity professional qualification for service(s)",
        "442" => "Modalities of service",
        "443" => "Initial evaluation report",
        "449" => "Projected date to discontinue service(s)",
        "450" => "Awaiting spend down determination",
        "451" => "Preoperative and post-operative diagnosis",
        "452" => "Total visits in total number of hours/day and total number of hours/week",
        "453" => "Procedure Code Modifier(s) for Service(s) Rendered",
        "454" => "Procedure code for services rendered.",
        "455" => "Revenue code for services rendered.",
        "456" => "Covered Day(s)",
        "457" => "Non-Covered Day(s)",
        "458" => "Coinsurance Day(s)",
        "459" => "Lifetime Reserve Day(s)",
        "460" => "NUBC Condition Code(s)",
        "464" => "Payer Assigned Claim Control Number",
        "465" => "Principal Procedure Code for Service(s) Rendered",
        "466" => "Entity's Original Signature.",
        "467" => "Entity Signature Date.",
        "468" => "Patient Signature Source",
        "469" => "Purchase Service Charge",
        "470" => "Was service purchased from another entity?",
        "471" => "Were services related to an emergency?",
        "472" => "Ambulance Run Sheet",
        "473" => "Missing or invalid lab indicator",
        "474" => "Procedure code and patient gender mismatch",
        "475" => "Procedure code not valid for patient age",
        "476" => "Missing or invalid units of service",
        "477" => "Diagnosis code pointer is missing or invalid",
        "478" => "Claim submitter's identifier",
        "479" => "Other Carrier payer ID is missing or invalid",
        "480" => "Entity's claim filing indicator.",
        "481" => "Claim/submission format is invalid.",
        "483" => "Maximum coverage amount met or exceeded for benefit period.",
        "484" => "Business Application Currently Not Available",
        "485" => "More information available than can be returned in real time mode. Narrow your current search criteria.",
        "486" => "Principal Procedure Date",
        "487" => "Claim not found, claim should have been submitted to/through 'entity'.",
        "488" => "Diagnosis code(s) for the services rendered.",
        "489" => "Attachment Control Number",
        "490" => "Other Procedure Code for Service(s) Rendered",
        "491" => "Entity not eligible for encounter submission.",
        "492" => "Other Procedure Date",
        "493" => "Version/Release/Industry ID code not currently supported by information holder",
        "494" => "Real-Time requests not supported by the information holder, resubmit as batch request",
        "495" => "Requests for re-adjudication must reference the newly assigned payer claim control number for this previously adjusted claim. Correct the payer claim control number and re-submit.",
        "496" => "Submitter not approved for electronic claim submissions on behalf of this entity.",
        "497" => "Sales tax not paid",
        "498" => "Maximum leave days exhausted",
        "499" => "No rate on file with the payer for this service for this entity",
        "500" => "Entity's Postal/Zip Code.",
        "501" => "Entity's State/Province.",
        "502" => "Entity's City.",
        "503" => "Entity's Street Address.",
        "504" => "Entity's Last Name.",
        "505" => "Entity's First Name.",
        "506" => "Entity is changing processor/clearinghouse. This claim must be submitted to the new processor/clearinghouse.",
        "507" => "HCPCS",
        "508" => "ICD9 NOTE: At least one other status code is required to identify the related procedure code or diagnosis code.",
        "509" => "External Cause of Injury Code.",
        "510" => "Future date.",
        "511" => "Invalid character.",
        "512" => "Length invalid for receiver's application system.",
        "513" => "HIPPS Rate Code for services Rendered",
        "514" => "Entity's Middle Name",
        "515" => "Managed Care review",
        "516" => "Other Entity's Adjudication or Payment/Remittance Date.",
        "517" => "Adjusted Repriced Claim Reference Number",
        "518" => "Adjusted Repriced Line item Reference Number",
        "519" => "Adjustment Amount",
        "520" => "Adjustment Quantity",
        "521" => "Adjustment Reason Code",
        "522" => "Anesthesia Modifying Units",
        "523" => "Anesthesia Unit Count",
        "524" => "Arterial Blood Gas Quantity",
        "525" => "Begin Therapy Date",
        "526" => "Bundled or Unbundled Line Number",
        "527" => "Certification Condition Indicator",
        "528" => "Certification Period Projected Visit Count",
        "529" => "Certification Revision Date",
        "530" => "Claim Adjustment Indicator",
        "531" => "Claim Disproportinate Share Amount",
        "532" => "Claim DRG Amount",
        "533" => "Claim DRG Outlier Amount",
        "534" => "Claim ESRD Payment Amount",
        "535" => "Claim Frequency Code",
        "536" => "Claim Indirect Teaching Amount",
        "537" => "Claim MSP Pass-through Amount",
        "538" => "Claim or Encounter Identifier",
        "539" => "Claim PPS Capital Amount",
        "540" => "Claim PPS Capital Outlier Amount",
        "541" => "Claim Submission Reason Code",
        "542" => "Claim Total Denied Charge Amount",
        "543" => "Clearinghouse or Value Added Network Trace",
        "544" => "Clinical Laboratory Improvement Amendment",
        "545" => "Contract Amount",
        "546" => "Contract Code",
        "547" => "Contract Percentage",
        "548" => "Contract Type Code",
        "549" => "Contract Version Identifier",
        "550" => "Coordination of Benefits Code",
        "551" => "Coordination of Benefits Total Submitted Charge",
        "552" => "Cost Report Day Count",
        "553" => "Covered Amount",
        "554" => "Date Claim Paid",
        "555" => "Delay Reason Code",
        "556" => "Demonstration Project Identifier",
        "557" => "Diagnosis Date",
        "558" => "Discount Amount",
        "559" => "Document Control Identifier",
        "560" => "Entity's Additional/Secondary Identifier.",
        "561" => "Entity's Contact Name.",
        "562" => "Entity's National Provider Identifier (NPI).",
        "563" => "Entity's Tax Amount.",
        "564" => "EPSDT Indicator",
        "565" => "Estimated Claim Due Amount",
        "566" => "Exception Code",
        "567" => "Facility Code Qualifier",
        "568" => "Family Planning Indicator",
        "569" => "Fixed Format Information",
        "571" => "Frequency Count",
        "572" => "Frequency Period",
        "573" => "Functional Limitation Code",
        "574" => "HCPCS Payable Amount Home Health",
        "575" => "Homebound Indicator",
        "576" => "Immunization Batch Number",
        "577" => "Industry Code",
        "578" => "Insurance Type Code",
        "579" => "Investigational Device Exemption Identifier",
        "580" => "Last Certification Date",
        "581" => "Last Worked Date",
        "582" => "Lifetime Psychiatric Days Count",
        "583" => "Line Item Charge Amount",
        "584" => "Line Item Control Number",
        "585" => "Denied Charge or Non-covered Charge",
        "586" => "Line Note Text",
        "587" => "Measurement Reference Identification Code",
        "588" => "Medical Record Number",
        "589" => "Provider Accept Assignment Code",
        "590" => "Medicare Coverage Indicator",
        "591" => "Medicare Paid at 100% Amount",
        "592" => "Medicare Paid at 80% Amount",
        "593" => "Medicare Section 4081 Indicator",
        "594" => "Mental Status Code",
        "595" => "Monthly Treatment Count",
        "596" => "Non-covered Charge Amount",
        "597" => "Non-payable Professional Component Amount",
        "598" => "Non-payable Professional Component Billed Amount",
        "599" => "Note Reference Code",
        "600" => "Oxygen Saturation Qty",
        "601" => "Oxygen Test Condition Code",
        "602" => "Oxygen Test Date",
        "603" => "Old Capital Amount",
        "604" => "Originator Application Transaction Identifier",
        "605" => "Orthodontic Treatment Months Count",
        "606" => "Paid From Part A Medicare Trust Fund Amount",
        "607" => "Paid From Part B Medicare Trust Fund Amount",
        "608" => "Paid Service Unit Count",
        "609" => "Participation Agreement",
        "610" => "Patient Discharge Facility Type Code",
        "611" => "Peer Review Authorization Number",
        "612" => "Per Day Limit Amount",
        "613" => "Physician Contact Date",
        "614" => "Physician Order Date",
        "615" => "Policy Compliance Code",
        "616" => "Policy Name",
        "617" => "Postage Claimed Amount",
        "618" => "PPS-Capital DSH DRG Amount",
        "619" => "PPS-Capital Exception Amount",
        "620" => "PPS-Capital FSP DRG Amount",
        "621" => "PPS-Capital HSP DRG Amount",
        "622" => "PPS-Capital IME Amount",
        "623" => "PPS-Operating Federal Specific DRG Amount",
        "624" => "PPS-Operating Hospital Specific DRG Amount",
        "625" => "Predetermination of Benefits Identifier",
        "626" => "Pregnancy Indicator",
        "627" => "Pre-Tax Claim Amount",
        "628" => "Pricing Methodology",
        "629" => "Property Casualty Claim Number",
        "630" => "Referring CLIA Number",
        "631" => "Reimbursement Rate",
        "632" => "Reject Reason Code",
        "633" => "Related Causes Code (Accident, auto accident, employment)",
        "634" => "Remark Code",
        "635" => "Repriced Ambulatory Patient Group Code",
        "636" => "Repriced Line Item Reference Number",
        "637" => "Repriced Saving Amount",
        "638" => "Repricing Per Diem or Flat Rate Amount",
        "639" => "Responsibility Amount",
        "640" => "Sales Tax Amount",
        "642" => "Service Authorization Exception Code",
        "643" => "Service Line Paid Amount",
        "644" => "Service Line Rate",
        "645" => "Service Tax Amount",
        "646" => "Ship, Delivery or Calendar Pattern Code",
        "647" => "Shipped Date",
        "648" => "Similar Illness or Symptom Date",
        "649" => "Skilled Nursing Facility Indicator",
        "650" => "Special Program Indicator",
        "651" => "State Industrial Accident Provider Number",
        "652" => "Terms Discount Percentage",
        "653" => "Test Performed Date",
        "654" => "Total Denied Charge Amount",
        "655" => "Total Medicare Paid Amount",
        "656" => "Total Visits Projected This Certification Count",
        "657" => "Total Visits Rendered Count",
        "658" => "Treatment Code",
        "659" => "Unit or Basis for Measurement Code",
        "660" => "Universal Product Number",
        "661" => "Visits Prior to Recertification Date Count CR702",
        "662" => "X-ray Availability Indicator",
        "663" => "Entity's Group Name.",
        "664" => "Orthodontic Banding Date",
        "665" => "Surgery Date",
        "666" => "Surgical Procedure Code",
        "667" => "Real-Time requests not supported by the information holder, do not resubmit",
        "668" => "Missing Endodontics treatment history and prognosis",
        "669" => "Dental service narrative needed.",
        "670" => "Funds applied from a consumer spending account such as consumer directed/driven health plan (CDHP), Health savings account (H S A) and or other similar accounts",
        "671" => "Funds may be available from a consumer spending account such as consumer directed/driven health plan (CDHP), Health savings account (H S A) and or other similar accounts",
        "672" => "Other Payer's payment information is out of balance",
        "673" => "Patient Reason for Visit",
        "674" => "Authorization exceeded",
        "675" => "Facility admission through discharge dates",
        "676" => "Entity possibly compensated by facility.",
        "677" => "Entity not affiliated.",
        "678" => "Revenue code and patient gender mismatch",
        "679" => "Submit newborn services on mother's claim",
        "680" => "Entity's Country.",
        "681" => "Claim currency not supported",
        "682" => "Cosmetic procedure",
        "683" => "Awaiting Associated Hospital Claims",
        "684" => "Rejected. Syntax error noted for this claim/service/inquiry. See Functional or Implementation Acknowledgement for details. ",
        "685" => "Claim could not complete adjudication in real time. Claim will continue processing in a batch mode. Do not resubmit.",
        "686" => "The claim/ encounter has completed the adjudication cycle and the entire claim has been voided",
        "687" => "Claim estimation can not be completed in real time. Do not resubmit.",
        "688" => "Present on Admission Indicator for reported diagnosis code(s).",
        "689" => "Entity was unable to respond within the expected time frame.",
        "690" => "Multiple claims or estimate requests cannot be processed in real time.",
        "691" => "Multiple claim status requests cannot be processed in real time.",
        "692" => "Contracted funding agreement-Subscriber is employed by the provider of services",
        "693" => "Amount must be greater than or equal to zero.",
        "694" => "Amount must not be equal to zero.",
        "695" => "Entity's Country Subdivision Code.",
        "696" => "Claim Adjustment Group Code.",
        "697" => "Invalid Decimal Precision.",
        "698" => "Form Type Identification",
        "699" => "Question/Response from Supporting Documentation Form",
        "700" => "ICD10.",
        "701" => "Initial Treatment Date",
        "702" => "Repriced Claim Reference Number",
        "703" => "Advanced Billing Concepts (ABC) code",
        "704" => "Claim Note Text",
        "705" => "Repriced Allowed Amount",
        "706" => "Repriced Approved Amount",
        "707" => "Repriced Approved Ambulatory Patient Group Amount",
        "708" => "Repriced Approved Revenue Code",
        "709" => "Repriced Approved Service Unit Count",
        "710" => "Line Adjudication Information.",
        "711" => "Stretcher purpose",
        "712" => "Obstetric Additional Units",
        "713" => "Patient Condition Description",
        "714" => "Care Plan Oversight Number",
        "715" => "Acute Manifestation Date",
        "716" => "Repriced Approved DRG Code",
        "717" => "This claim has been split for processing.",
        "718" => "Claim/service not submitted within the required timeframe (timely filing).",
        "719" => "NUBC Occurrence Code(s)",
        "720" => "NUBC Occurrence Code Date(s)",
        "721" => "NUBC Occurrence Span Code(s)",
        "722" => "NUBC Occurrence Span Code Date(s)",
        "723" => "Drug days supply",
        "724" => "Drug dosage",
        "725" => "NUBC Value Code(s)",
        "726" => "NUBC Value Code Amount(s)",
        "727" => "Accident date",
        "728" => "Accident state",
        "729" => "Accident description",
        "730" => "Accident cause",
        "731" => "Measurement value/test result",
        "732" => "Information submitted inconsistent with billing guidelines.",
        "733" => "Prefix for entity's contract/member number.",
        "734" => "Verifying premium payment",
        "735" => "This service/claim is included in the allowance for another service or claim.",
        "736" => "A related or qualifying service/claim has not been received/adjudicated.",
        "737" => "Current Dental Terminology (CDT) Code",
        "738" => "Home Infusion EDI Coalition (HEIC) Product/Service Code",
        "739" => "Jurisdiction Specific Procedure or Supply Code",
        "740" => "Drop-Off Location",
        "741" => "Entity must be a person.",
        "742" => "Payer Responsibility Sequence Number Code",
        "743" => "Entity’s credential/enrollment information.",
        "744" => "Services/charges related to the treatment of a hospital-acquired condition or preventable medical error.",
        "745" => "Identifier Qualifier",
        "746" => "Duplicate Submission",
        "747" => "Hospice Employee Indicator",
        "748" => "Corrected Data",
        "749" => "Date of Injury/Illness",
        "750" => "Auto Accident State or Province Code",
        "751" => "Ambulance Pick-up State or Province Code",
        "752" => "Ambulance Drop-off State or Province Code",
        "753" => "Co-pay status code.",
        "754" => "Entity Name Suffix.",
        "755" => "Entity's primary identifier.",
        "756" => "Entity's Received Date.",
        "757" => "Last seen date.",
        "758" => "Repriced approved HCPCS code.",
        "759" => "Round trip purpose description.",
        "760" => "Tooth status code.",
        "761" => "Entity's referral number.",
        "762" => "Locum Tenens Provider Identifier. Code must be used with Entity Code 82 - Rendering Provider",
        "763" => "Ambulance Pickup ZipCode",
        "764" => "Professional charges are non covered.",
        "765" => "Institutional charges are non covered.",
        "766" => "Services were performed during a Health Insurance Exchange (HIX) premium payment grace period.",
        "767" => "Qualifications for emergent/urgent care",
        "768" => "Service date outside the accidental injury coverage period.",
        "769" => "DME Repair or Maintenance",
        "770" => "Duplicate of a claim processed or in process as a crossover/coordination of benefits claim.",
        "771" => "Claim submitted prematurely. Please resubmit after crossover/payer to payer COB allotted waiting period.",
        "772" => "The greatest level of diagnosis code specificity is required.",
        );


        //
        //
    }
// end code271  array
//
    // edih_271_codes
    public function classname()
    {
        return get_class($this);
    }
    //
    public function get_271_code($elem, $code)
    {
        //
        $e = (string)$elem;
        $val = '';
        if (($this->ds && strpos($code, $this->ds) !== false) || ($this->dr && strpos($code, $this->dr) !== false)) {
            if ($this->ds && strpos($code, $this->ds) !== false) {
                $cdar = explode($this->ds, $code);
                foreach ($cdar as $cd) {
                    if ($this->dr && strpos($code, $this->dr) !== false) {
                        $cdar2 = explode($this->dr, $code);
                        foreach ($cdar2 as $cd2) {
                            if (isset($this->code271[$e][$cd2])) {
                                $val .= $this->code271[$e][$cd2] . '; ';
                            } else {
                                $val .= "code $cd2 N/A ";
                            }
                        }
                    } else {
                        $val .= (isset($this->code271[$e][$cd]) ) ? $this->code271[$e][$cd].' ' : "code $cd unknown ";
                    }
                }
            } elseif ($this->dr && strpos($code, $this->dr) !== false) {
                $cdar = explode($this->dr, $code);
                foreach ($cdar as $cd) {
                    $val .= (isset($this->code271[$e][$cd]) ) ? $this->code271[$e][$cd].'; ' : "code $cd unknown ";
                }
            }
        } elseif (array_key_exists($e, $this->code271)) {
            $val = (isset($this->code271[$e][$code]) ) ? $this->code271[$e][$code] : "$elem code $code unknown ";
        } else {
            $val = "$e codes not available ($code) ";
        }

        //
        return $val;
    }
    //
    public function get_keys()
    {
        return array_keys($this->code271);
    }
}
