<?php namespace OpenEMR\FHIR\R4;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 *
 * Class creation date: June 14th, 2019
 *
 * PHPFHIR Copyright:
 *
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

class PHPFHIRParserMap implements \ArrayAccess, \Iterator
{
    /** @var array */
    private $_bigDumbMap = array (
    'date' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'date-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'dateTime' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'dateTime-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'code' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'code-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'string' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'integer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'integer-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'oid' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'oid-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'canonical' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'canonical-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'uri' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'uri-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'uuid' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'uuid-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'url' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'url-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'instant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'instant-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'boolean' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'boolean-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'base64Binary' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'base64Binary-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'unsignedInt' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'unsignedInt-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'markdown' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'markdown-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'time' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'time-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'id' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'id-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'positiveInt' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'positiveInt-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'decimal' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceContainer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
    'extendedElementName' => null,
    'properties' =>
    array (
      'Account' =>
      array (
        'setter' => 'setAccount',
        'element' => 'Account',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAccount',
      ),
      'ActivityDefinition' =>
      array (
        'setter' => 'setActivityDefinition',
        'element' => 'ActivityDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRActivityDefinition',
      ),
      'AdverseEvent' =>
      array (
        'setter' => 'setAdverseEvent',
        'element' => 'AdverseEvent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAdverseEvent',
      ),
      'AllergyIntolerance' =>
      array (
        'setter' => 'setAllergyIntolerance',
        'element' => 'AllergyIntolerance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAllergyIntolerance',
      ),
      'Appointment' =>
      array (
        'setter' => 'setAppointment',
        'element' => 'Appointment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointment',
      ),
      'AppointmentResponse' =>
      array (
        'setter' => 'setAppointmentResponse',
        'element' => 'AppointmentResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointmentResponse',
      ),
      'AuditEvent' =>
      array (
        'setter' => 'setAuditEvent',
        'element' => 'AuditEvent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAuditEvent',
      ),
      'Basic' =>
      array (
        'setter' => 'setBasic',
        'element' => 'Basic',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBasic',
      ),
      'Binary' =>
      array (
        'setter' => 'setBinary',
        'element' => 'Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBinary',
      ),
      'BiologicallyDerivedProduct' =>
      array (
        'setter' => 'setBiologicallyDerivedProduct',
        'element' => 'BiologicallyDerivedProduct',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBiologicallyDerivedProduct',
      ),
      'BodyStructure' =>
      array (
        'setter' => 'setBodyStructure',
        'element' => 'BodyStructure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBodyStructure',
      ),
      'Bundle' =>
      array (
        'setter' => 'setBundle',
        'element' => 'Bundle',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle',
      ),
      'CapabilityStatement' =>
      array (
        'setter' => 'setCapabilityStatement',
        'element' => 'CapabilityStatement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCapabilityStatement',
      ),
      'CarePlan' =>
      array (
        'setter' => 'setCarePlan',
        'element' => 'CarePlan',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCarePlan',
      ),
      'CareTeam' =>
      array (
        'setter' => 'setCareTeam',
        'element' => 'CareTeam',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCareTeam',
      ),
      'CatalogEntry' =>
      array (
        'setter' => 'setCatalogEntry',
        'element' => 'CatalogEntry',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCatalogEntry',
      ),
      'ChargeItem' =>
      array (
        'setter' => 'setChargeItem',
        'element' => 'ChargeItem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItem',
      ),
      'ChargeItemDefinition' =>
      array (
        'setter' => 'setChargeItemDefinition',
        'element' => 'ChargeItemDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItemDefinition',
      ),
      'Claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Claim',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaim',
      ),
      'ClaimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'ClaimResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaimResponse',
      ),
      'ClinicalImpression' =>
      array (
        'setter' => 'setClinicalImpression',
        'element' => 'ClinicalImpression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClinicalImpression',
      ),
      'CodeSystem' =>
      array (
        'setter' => 'setCodeSystem',
        'element' => 'CodeSystem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCodeSystem',
      ),
      'Communication' =>
      array (
        'setter' => 'setCommunication',
        'element' => 'Communication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunication',
      ),
      'CommunicationRequest' =>
      array (
        'setter' => 'setCommunicationRequest',
        'element' => 'CommunicationRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunicationRequest',
      ),
      'CompartmentDefinition' =>
      array (
        'setter' => 'setCompartmentDefinition',
        'element' => 'CompartmentDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCompartmentDefinition',
      ),
      'Composition' =>
      array (
        'setter' => 'setComposition',
        'element' => 'Composition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRComposition',
      ),
      'ConceptMap' =>
      array (
        'setter' => 'setConceptMap',
        'element' => 'ConceptMap',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConceptMap',
      ),
      'Condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Condition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCondition',
      ),
      'Consent' =>
      array (
        'setter' => 'setConsent',
        'element' => 'Consent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConsent',
      ),
      'Contract' =>
      array (
        'setter' => 'setContract',
        'element' => 'Contract',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRContract',
      ),
      'Coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Coverage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverage',
      ),
      'CoverageEligibilityRequest' =>
      array (
        'setter' => 'setCoverageEligibilityRequest',
        'element' => 'CoverageEligibilityRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityRequest',
      ),
      'CoverageEligibilityResponse' =>
      array (
        'setter' => 'setCoverageEligibilityResponse',
        'element' => 'CoverageEligibilityResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityResponse',
      ),
      'DetectedIssue' =>
      array (
        'setter' => 'setDetectedIssue',
        'element' => 'DetectedIssue',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDetectedIssue',
      ),
      'Device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Device',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDevice',
      ),
      'DeviceDefinition' =>
      array (
        'setter' => 'setDeviceDefinition',
        'element' => 'DeviceDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceDefinition',
      ),
      'DeviceMetric' =>
      array (
        'setter' => 'setDeviceMetric',
        'element' => 'DeviceMetric',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceMetric',
      ),
      'DeviceRequest' =>
      array (
        'setter' => 'setDeviceRequest',
        'element' => 'DeviceRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceRequest',
      ),
      'DeviceUseStatement' =>
      array (
        'setter' => 'setDeviceUseStatement',
        'element' => 'DeviceUseStatement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceUseStatement',
      ),
      'DiagnosticReport' =>
      array (
        'setter' => 'setDiagnosticReport',
        'element' => 'DiagnosticReport',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDiagnosticReport',
      ),
      'DocumentManifest' =>
      array (
        'setter' => 'setDocumentManifest',
        'element' => 'DocumentManifest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentManifest',
      ),
      'DocumentReference' =>
      array (
        'setter' => 'setDocumentReference',
        'element' => 'DocumentReference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentReference',
      ),
      'EffectEvidenceSynthesis' =>
      array (
        'setter' => 'setEffectEvidenceSynthesis',
        'element' => 'EffectEvidenceSynthesis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREffectEvidenceSynthesis',
      ),
      'Encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Encounter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREncounter',
      ),
      'Endpoint' =>
      array (
        'setter' => 'setEndpoint',
        'element' => 'Endpoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREndpoint',
      ),
      'EnrollmentRequest' =>
      array (
        'setter' => 'setEnrollmentRequest',
        'element' => 'EnrollmentRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentRequest',
      ),
      'EnrollmentResponse' =>
      array (
        'setter' => 'setEnrollmentResponse',
        'element' => 'EnrollmentResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentResponse',
      ),
      'EpisodeOfCare' =>
      array (
        'setter' => 'setEpisodeOfCare',
        'element' => 'EpisodeOfCare',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREpisodeOfCare',
      ),
      'EventDefinition' =>
      array (
        'setter' => 'setEventDefinition',
        'element' => 'EventDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREventDefinition',
      ),
      'Evidence' =>
      array (
        'setter' => 'setEvidence',
        'element' => 'Evidence',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidence',
      ),
      'EvidenceVariable' =>
      array (
        'setter' => 'setEvidenceVariable',
        'element' => 'EvidenceVariable',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidenceVariable',
      ),
      'ExampleScenario' =>
      array (
        'setter' => 'setExampleScenario',
        'element' => 'ExampleScenario',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExampleScenario',
      ),
      'ExplanationOfBenefit' =>
      array (
        'setter' => 'setExplanationOfBenefit',
        'element' => 'ExplanationOfBenefit',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExplanationOfBenefit',
      ),
      'FamilyMemberHistory' =>
      array (
        'setter' => 'setFamilyMemberHistory',
        'element' => 'FamilyMemberHistory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFamilyMemberHistory',
      ),
      'Flag' =>
      array (
        'setter' => 'setFlag',
        'element' => 'Flag',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFlag',
      ),
      'Goal' =>
      array (
        'setter' => 'setGoal',
        'element' => 'Goal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGoal',
      ),
      'GraphDefinition' =>
      array (
        'setter' => 'setGraphDefinition',
        'element' => 'GraphDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGraphDefinition',
      ),
      'Group' =>
      array (
        'setter' => 'setGroup',
        'element' => 'Group',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGroup',
      ),
      'GuidanceResponse' =>
      array (
        'setter' => 'setGuidanceResponse',
        'element' => 'GuidanceResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGuidanceResponse',
      ),
      'HealthcareService' =>
      array (
        'setter' => 'setHealthcareService',
        'element' => 'HealthcareService',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRHealthcareService',
      ),
      'ImagingStudy' =>
      array (
        'setter' => 'setImagingStudy',
        'element' => 'ImagingStudy',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImagingStudy',
      ),
      'Immunization' =>
      array (
        'setter' => 'setImmunization',
        'element' => 'Immunization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunization',
      ),
      'ImmunizationEvaluation' =>
      array (
        'setter' => 'setImmunizationEvaluation',
        'element' => 'ImmunizationEvaluation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationEvaluation',
      ),
      'ImmunizationRecommendation' =>
      array (
        'setter' => 'setImmunizationRecommendation',
        'element' => 'ImmunizationRecommendation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationRecommendation',
      ),
      'ImplementationGuide' =>
      array (
        'setter' => 'setImplementationGuide',
        'element' => 'ImplementationGuide',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImplementationGuide',
      ),
      'InsurancePlan' =>
      array (
        'setter' => 'setInsurancePlan',
        'element' => 'InsurancePlan',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInsurancePlan',
      ),
      'Invoice' =>
      array (
        'setter' => 'setInvoice',
        'element' => 'Invoice',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInvoice',
      ),
      'Library' =>
      array (
        'setter' => 'setLibrary',
        'element' => 'Library',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLibrary',
      ),
      'Linkage' =>
      array (
        'setter' => 'setLinkage',
        'element' => 'Linkage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLinkage',
      ),
      'List' =>
      array (
        'setter' => 'setList',
        'element' => 'List',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRList',
      ),
      'Location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Location',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLocation',
      ),
      'Measure' =>
      array (
        'setter' => 'setMeasure',
        'element' => 'Measure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMeasure',
      ),
      'MeasureReport' =>
      array (
        'setter' => 'setMeasureReport',
        'element' => 'MeasureReport',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMeasureReport',
      ),
      'Media' =>
      array (
        'setter' => 'setMedia',
        'element' => 'Media',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedia',
      ),
      'Medication' =>
      array (
        'setter' => 'setMedication',
        'element' => 'Medication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedication',
      ),
      'MedicationAdministration' =>
      array (
        'setter' => 'setMedicationAdministration',
        'element' => 'MedicationAdministration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationAdministration',
      ),
      'MedicationDispense' =>
      array (
        'setter' => 'setMedicationDispense',
        'element' => 'MedicationDispense',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationDispense',
      ),
      'MedicationKnowledge' =>
      array (
        'setter' => 'setMedicationKnowledge',
        'element' => 'MedicationKnowledge',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationKnowledge',
      ),
      'MedicationRequest' =>
      array (
        'setter' => 'setMedicationRequest',
        'element' => 'MedicationRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationRequest',
      ),
      'MedicationStatement' =>
      array (
        'setter' => 'setMedicationStatement',
        'element' => 'MedicationStatement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationStatement',
      ),
      'MedicinalProduct' =>
      array (
        'setter' => 'setMedicinalProduct',
        'element' => 'MedicinalProduct',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProduct',
      ),
      'MedicinalProductAuthorization' =>
      array (
        'setter' => 'setMedicinalProductAuthorization',
        'element' => 'MedicinalProductAuthorization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductAuthorization',
      ),
      'MedicinalProductContraindication' =>
      array (
        'setter' => 'setMedicinalProductContraindication',
        'element' => 'MedicinalProductContraindication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductContraindication',
      ),
      'MedicinalProductIndication' =>
      array (
        'setter' => 'setMedicinalProductIndication',
        'element' => 'MedicinalProductIndication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductIndication',
      ),
      'MedicinalProductIngredient' =>
      array (
        'setter' => 'setMedicinalProductIngredient',
        'element' => 'MedicinalProductIngredient',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductIngredient',
      ),
      'MedicinalProductInteraction' =>
      array (
        'setter' => 'setMedicinalProductInteraction',
        'element' => 'MedicinalProductInteraction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductInteraction',
      ),
      'MedicinalProductManufactured' =>
      array (
        'setter' => 'setMedicinalProductManufactured',
        'element' => 'MedicinalProductManufactured',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductManufactured',
      ),
      'MedicinalProductPackaged' =>
      array (
        'setter' => 'setMedicinalProductPackaged',
        'element' => 'MedicinalProductPackaged',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductPackaged',
      ),
      'MedicinalProductPharmaceutical' =>
      array (
        'setter' => 'setMedicinalProductPharmaceutical',
        'element' => 'MedicinalProductPharmaceutical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductPharmaceutical',
      ),
      'MedicinalProductUndesirableEffect' =>
      array (
        'setter' => 'setMedicinalProductUndesirableEffect',
        'element' => 'MedicinalProductUndesirableEffect',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductUndesirableEffect',
      ),
      'MessageDefinition' =>
      array (
        'setter' => 'setMessageDefinition',
        'element' => 'MessageDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMessageDefinition',
      ),
      'MessageHeader' =>
      array (
        'setter' => 'setMessageHeader',
        'element' => 'MessageHeader',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMessageHeader',
      ),
      'MolecularSequence' =>
      array (
        'setter' => 'setMolecularSequence',
        'element' => 'MolecularSequence',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMolecularSequence',
      ),
      'NamingSystem' =>
      array (
        'setter' => 'setNamingSystem',
        'element' => 'NamingSystem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRNamingSystem',
      ),
      'NutritionOrder' =>
      array (
        'setter' => 'setNutritionOrder',
        'element' => 'NutritionOrder',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRNutritionOrder',
      ),
      'Observation' =>
      array (
        'setter' => 'setObservation',
        'element' => 'Observation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRObservation',
      ),
      'ObservationDefinition' =>
      array (
        'setter' => 'setObservationDefinition',
        'element' => 'ObservationDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRObservationDefinition',
      ),
      'OperationDefinition' =>
      array (
        'setter' => 'setOperationDefinition',
        'element' => 'OperationDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROperationDefinition',
      ),
      'OperationOutcome' =>
      array (
        'setter' => 'setOperationOutcome',
        'element' => 'OperationOutcome',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROperationOutcome',
      ),
      'Organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Organization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROrganization',
      ),
      'OrganizationAffiliation' =>
      array (
        'setter' => 'setOrganizationAffiliation',
        'element' => 'OrganizationAffiliation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROrganizationAffiliation',
      ),
      'Patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Patient',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPatient',
      ),
      'PaymentNotice' =>
      array (
        'setter' => 'setPaymentNotice',
        'element' => 'PaymentNotice',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPaymentNotice',
      ),
      'PaymentReconciliation' =>
      array (
        'setter' => 'setPaymentReconciliation',
        'element' => 'PaymentReconciliation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPaymentReconciliation',
      ),
      'Person' =>
      array (
        'setter' => 'setPerson',
        'element' => 'Person',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPerson',
      ),
      'PlanDefinition' =>
      array (
        'setter' => 'setPlanDefinition',
        'element' => 'PlanDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPlanDefinition',
      ),
      'Practitioner' =>
      array (
        'setter' => 'setPractitioner',
        'element' => 'Practitioner',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPractitioner',
      ),
      'PractitionerRole' =>
      array (
        'setter' => 'setPractitionerRole',
        'element' => 'PractitionerRole',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPractitionerRole',
      ),
      'Procedure' =>
      array (
        'setter' => 'setProcedure',
        'element' => 'Procedure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRProcedure',
      ),
      'Provenance' =>
      array (
        'setter' => 'setProvenance',
        'element' => 'Provenance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRProvenance',
      ),
      'Questionnaire' =>
      array (
        'setter' => 'setQuestionnaire',
        'element' => 'Questionnaire',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRQuestionnaire',
      ),
      'QuestionnaireResponse' =>
      array (
        'setter' => 'setQuestionnaireResponse',
        'element' => 'QuestionnaireResponse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRQuestionnaireResponse',
      ),
      'RelatedPerson' =>
      array (
        'setter' => 'setRelatedPerson',
        'element' => 'RelatedPerson',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRelatedPerson',
      ),
      'RequestGroup' =>
      array (
        'setter' => 'setRequestGroup',
        'element' => 'RequestGroup',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRequestGroup',
      ),
      'ResearchDefinition' =>
      array (
        'setter' => 'setResearchDefinition',
        'element' => 'ResearchDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchDefinition',
      ),
      'ResearchElementDefinition' =>
      array (
        'setter' => 'setResearchElementDefinition',
        'element' => 'ResearchElementDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchElementDefinition',
      ),
      'ResearchStudy' =>
      array (
        'setter' => 'setResearchStudy',
        'element' => 'ResearchStudy',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchStudy',
      ),
      'ResearchSubject' =>
      array (
        'setter' => 'setResearchSubject',
        'element' => 'ResearchSubject',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchSubject',
      ),
      'RiskAssessment' =>
      array (
        'setter' => 'setRiskAssessment',
        'element' => 'RiskAssessment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRiskAssessment',
      ),
      'RiskEvidenceSynthesis' =>
      array (
        'setter' => 'setRiskEvidenceSynthesis',
        'element' => 'RiskEvidenceSynthesis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRiskEvidenceSynthesis',
      ),
      'Schedule' =>
      array (
        'setter' => 'setSchedule',
        'element' => 'Schedule',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSchedule',
      ),
      'SearchParameter' =>
      array (
        'setter' => 'setSearchParameter',
        'element' => 'SearchParameter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSearchParameter',
      ),
      'ServiceRequest' =>
      array (
        'setter' => 'setServiceRequest',
        'element' => 'ServiceRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRServiceRequest',
      ),
      'Slot' =>
      array (
        'setter' => 'setSlot',
        'element' => 'Slot',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSlot',
      ),
      'Specimen' =>
      array (
        'setter' => 'setSpecimen',
        'element' => 'Specimen',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSpecimen',
      ),
      'SpecimenDefinition' =>
      array (
        'setter' => 'setSpecimenDefinition',
        'element' => 'SpecimenDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSpecimenDefinition',
      ),
      'StructureDefinition' =>
      array (
        'setter' => 'setStructureDefinition',
        'element' => 'StructureDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRStructureDefinition',
      ),
      'StructureMap' =>
      array (
        'setter' => 'setStructureMap',
        'element' => 'StructureMap',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRStructureMap',
      ),
      'Subscription' =>
      array (
        'setter' => 'setSubscription',
        'element' => 'Subscription',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubscription',
      ),
      'Substance' =>
      array (
        'setter' => 'setSubstance',
        'element' => 'Substance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstance',
      ),
      'SubstanceNucleicAcid' =>
      array (
        'setter' => 'setSubstanceNucleicAcid',
        'element' => 'SubstanceNucleicAcid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceNucleicAcid',
      ),
      'SubstancePolymer' =>
      array (
        'setter' => 'setSubstancePolymer',
        'element' => 'SubstancePolymer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstancePolymer',
      ),
      'SubstanceProtein' =>
      array (
        'setter' => 'setSubstanceProtein',
        'element' => 'SubstanceProtein',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceProtein',
      ),
      'SubstanceReferenceInformation' =>
      array (
        'setter' => 'setSubstanceReferenceInformation',
        'element' => 'SubstanceReferenceInformation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceReferenceInformation',
      ),
      'SubstanceSourceMaterial' =>
      array (
        'setter' => 'setSubstanceSourceMaterial',
        'element' => 'SubstanceSourceMaterial',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceSourceMaterial',
      ),
      'SubstanceSpecification' =>
      array (
        'setter' => 'setSubstanceSpecification',
        'element' => 'SubstanceSpecification',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceSpecification',
      ),
      'SupplyDelivery' =>
      array (
        'setter' => 'setSupplyDelivery',
        'element' => 'SupplyDelivery',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSupplyDelivery',
      ),
      'SupplyRequest' =>
      array (
        'setter' => 'setSupplyRequest',
        'element' => 'SupplyRequest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSupplyRequest',
      ),
      'Task' =>
      array (
        'setter' => 'setTask',
        'element' => 'Task',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTask',
      ),
      'TerminologyCapabilities' =>
      array (
        'setter' => 'setTerminologyCapabilities',
        'element' => 'TerminologyCapabilities',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTerminologyCapabilities',
      ),
      'TestReport' =>
      array (
        'setter' => 'setTestReport',
        'element' => 'TestReport',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTestReport',
      ),
      'TestScript' =>
      array (
        'setter' => 'setTestScript',
        'element' => 'TestScript',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTestScript',
      ),
      'ValueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'ValueSet',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRValueSet',
      ),
      'VerificationResult' =>
      array (
        'setter' => 'setVerificationResult',
        'element' => 'VerificationResult',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRVerificationResult',
      ),
      'VisionPrescription' =>
      array (
        'setter' => 'setVisionPrescription',
        'element' => 'VisionPrescription',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRVisionPrescription',
      ),
      'Parameters' =>
      array (
        'setter' => 'setParameters',
        'element' => 'Parameters',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRParameters',
      ),
    ),
    ),
    'Extension' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueCanonical' =>
      array (
        'setter' => 'setValueCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'valueId' =>
      array (
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'valueInstant' =>
      array (
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'valueMarkdown' =>
      array (
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'valueOid' =>
      array (
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
      ),
      'valuePositiveInt' =>
      array (
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'valueUnsignedInt' =>
      array (
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'valueUrl' =>
      array (
        'setter' => 'setValueUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'valueUuid' =>
      array (
        'setter' => 'setValueUuid',
        'element' => 'uuid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
      ),
      'valueAddress' =>
      array (
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'valueAge' =>
      array (
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'valueAnnotation' =>
      array (
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'valueContactPoint' =>
      array (
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'valueCount' =>
      array (
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'valueDistance' =>
      array (
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'valueHumanName' =>
      array (
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'valueIdentifier' =>
      array (
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
      ),
      'valueSignature' =>
      array (
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
      'valueTiming' =>
      array (
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'valueContactDetail' =>
      array (
        'setter' => 'setValueContactDetail',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'valueContributor' =>
      array (
        'setter' => 'setValueContributor',
        'element' => 'Contributor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
      ),
      'valueDataRequirement' =>
      array (
        'setter' => 'setValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'valueExpression' =>
      array (
        'setter' => 'setValueExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'valueParameterDefinition' =>
      array (
        'setter' => 'setValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
      ),
      'valueRelatedArtifact' =>
      array (
        'setter' => 'setValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'valueTriggerDefinition' =>
      array (
        'setter' => 'setValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'valueUsageContext' =>
      array (
        'setter' => 'setValueUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'valueDosage' =>
      array (
        'setter' => 'setValueDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'BackboneElement' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBackboneElement',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
    ),
    ),
    'Narrative' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'NarrativeStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrativeStatus',
      ),
      'div' =>
      array (
        'setter' => 'setDiv',
        'element' => 'html',
        'type' => 'string',
      ),
    ),
    ),
    'NarrativeStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrativeStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NarrativeStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Element' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement',
    'extendedElementName' => null,
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'Meta' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'versionId' =>
      array (
        'setter' => 'setVersionId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'lastUpdated' =>
      array (
        'setter' => 'setLastUpdated',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'security' =>
      array (
        'setter' => 'addSecurity',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'tag' =>
      array (
        'setter' => 'addTag',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'Address' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'AddressUse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressUse',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AddressType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressType',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'line' =>
      array (
        'setter' => 'addLine',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'city' =>
      array (
        'setter' => 'setCity',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'district' =>
      array (
        'setter' => 'setDistrict',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'state' =>
      array (
        'setter' => 'setState',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'postalCode' =>
      array (
        'setter' => 'setPostalCode',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'country' =>
      array (
        'setter' => 'setCountry',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'AddressUse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AddressUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'AddressType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AddressType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Contributor' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ContributorType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributorType',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
    ),
    ),
    'ContributorType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributorType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContributorType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Attachment' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'contentType' =>
      array (
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'size' =>
      array (
        'setter' => 'setSize',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'hash' =>
      array (
        'setter' => 'setHash',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'creation' =>
      array (
        'setter' => 'setCreation',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Count' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'DataRequirement' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'subjectCodeableConcept' =>
      array (
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subjectReference' =>
      array (
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'mustSupport' =>
      array (
        'setter' => 'addMustSupport',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'codeFilter' =>
      array (
        'setter' => 'addCodeFilter',
        'element' => 'DataRequirement.CodeFilter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter',
      ),
      'dateFilter' =>
      array (
        'setter' => 'addDateFilter',
        'element' => 'DataRequirement.DateFilter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter',
      ),
      'limit' =>
      array (
        'setter' => 'setLimit',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'sort' =>
      array (
        'setter' => 'addSort',
        'element' => 'DataRequirement.Sort',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementSort',
      ),
    ),
    ),
    'DataRequirement.CodeFilter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'searchParam' =>
      array (
        'setter' => 'setSearchParam',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'DataRequirement.DateFilter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'searchParam' =>
      array (
        'setter' => 'setSearchParam',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
    ),
    ),
    'DataRequirement.Sort' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementSort',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'direction' =>
      array (
        'setter' => 'setDirection',
        'element' => 'SortDirection',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSortDirection',
      ),
    ),
    ),
    'SortDirection' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSortDirection',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SortDirection-list',
        'type' => 'string',
      ),
    ),
    ),
    'Dosage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'additionalInstruction' =>
      array (
        'setter' => 'addAdditionalInstruction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patientInstruction' =>
      array (
        'setter' => 'setPatientInstruction',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'timing' =>
      array (
        'setter' => 'setTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'asNeededBoolean' =>
      array (
        'setter' => 'setAsNeededBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'asNeededCodeableConcept' =>
      array (
        'setter' => 'setAsNeededCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'route' =>
      array (
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseAndRate' =>
      array (
        'setter' => 'addDoseAndRate',
        'element' => 'Dosage.DoseAndRate',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage\\FHIRDosageDoseAndRate',
      ),
      'maxDosePerPeriod' =>
      array (
        'setter' => 'setMaxDosePerPeriod',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'maxDosePerAdministration' =>
      array (
        'setter' => 'setMaxDosePerAdministration',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'maxDosePerLifetime' =>
      array (
        'setter' => 'setMaxDosePerLifetime',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Dosage.DoseAndRate' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage\\FHIRDosageDoseAndRate',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseRange' =>
      array (
        'setter' => 'setDoseRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'doseQuantity' =>
      array (
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'rateRatio' =>
      array (
        'setter' => 'setRateRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'rateRange' =>
      array (
        'setter' => 'setRateRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'rateQuantity' =>
      array (
        'setter' => 'setRateQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Money' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'currency' =>
      array (
        'setter' => 'setCurrency',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'HumanName' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'NameUse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNameUse',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'family' =>
      array (
        'setter' => 'setFamily',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'given' =>
      array (
        'setter' => 'addGiven',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'prefix' =>
      array (
        'setter' => 'addPrefix',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'suffix' =>
      array (
        'setter' => 'addSuffix',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'NameUse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNameUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NameUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContactPoint' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'ContactPointSystem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointSystem',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'ContactPointUse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointUse',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'ContactPointSystem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointSystem',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContactPointSystem-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContactPointUse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContactPointUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'MarketingStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMarketingStatus',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'country' =>
      array (
        'setter' => 'setCountry',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'setJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dateRange' =>
      array (
        'setter' => 'setDateRange',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'restoreDate' =>
      array (
        'setter' => 'setRestoreDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Identifier' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'IdentifierUse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifierUse',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'assigner' =>
      array (
        'setter' => 'setAssigner',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'IdentifierUse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifierUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'IdentifierUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'SubstanceAmount' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceAmount',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'amountQuantity' =>
      array (
        'setter' => 'setAmountQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'amountRange' =>
      array (
        'setter' => 'setAmountRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'amountString' =>
      array (
        'setter' => 'setAmountString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'amountType' =>
      array (
        'setter' => 'setAmountType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amountText' =>
      array (
        'setter' => 'setAmountText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'referenceRange' =>
      array (
        'setter' => 'setReferenceRange',
        'element' => 'SubstanceAmount.ReferenceRange',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceAmount\\FHIRSubstanceAmountReferenceRange',
      ),
    ),
    ),
    'SubstanceAmount.ReferenceRange' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceAmount\\FHIRSubstanceAmountReferenceRange',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'lowLimit' =>
      array (
        'setter' => 'setLowLimit',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'highLimit' =>
      array (
        'setter' => 'setHighLimit',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Coding' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'userSelected' =>
      array (
        'setter' => 'setUserSelected',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'SampledData' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'origin' =>
      array (
        'setter' => 'setOrigin',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'lowerLimit' =>
      array (
        'setter' => 'setLowerLimit',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'upperLimit' =>
      array (
        'setter' => 'setUpperLimit',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'dimensions' =>
      array (
        'setter' => 'setDimensions',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'SampledDataDataType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledDataDataType',
      ),
    ),
    ),
    'SampledDataDataType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledDataDataType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SampledDataDataType-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'Population' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPopulation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'ageRange' =>
      array (
        'setter' => 'setAgeRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'ageCodeableConcept' =>
      array (
        'setter' => 'setAgeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'gender' =>
      array (
        'setter' => 'setGender',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'race' =>
      array (
        'setter' => 'setRace',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'physiologicalCondition' =>
      array (
        'setter' => 'setPhysiologicalCondition',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Ratio' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'numerator' =>
      array (
        'setter' => 'setNumerator',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'denominator' =>
      array (
        'setter' => 'setDenominator',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Distance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Age' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Reference' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'TriggerDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'TriggerType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerType',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'timingTiming' =>
      array (
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'timingReference' =>
      array (
        'setter' => 'setTimingReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'timingDate' =>
      array (
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'timingDateTime' =>
      array (
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'data' =>
      array (
        'setter' => 'addData',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
    ),
    ),
    'TriggerType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'TriggerType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Quantity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'QuantityComparator' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'QuantityComparator-list',
        'type' => 'string',
      ),
    ),
    ),
    'Period' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Duration' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Range' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'low' =>
      array (
        'setter' => 'setLow',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'high' =>
      array (
        'setter' => 'setHigh',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'RelatedArtifact' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'RelatedArtifactType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifactType',
      ),
      'label' =>
      array (
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'citation' =>
      array (
        'setter' => 'setCitation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'document' =>
      array (
        'setter' => 'setDocument',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'RelatedArtifactType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifactType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RelatedArtifactType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Annotation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'authorReference' =>
      array (
        'setter' => 'setAuthorReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'authorString' =>
      array (
        'setter' => 'setAuthorString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'ProductShelfLife' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProductShelfLife',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'specialPrecautionsForStorage' =>
      array (
        'setter' => 'addSpecialPrecautionsForStorage',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ContactDetail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
    ),
    ),
    'UsageContext' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Expression' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'ExpressionLanguage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpressionLanguage',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'ExpressionLanguage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpressionLanguage',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ExpressionLanguage-list',
        'type' => 'string',
      ),
    ),
    ),
    'Signature' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'when' =>
      array (
        'setter' => 'setWhen',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'who' =>
      array (
        'setter' => 'setWho',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'targetFormat' =>
      array (
        'setter' => 'setTargetFormat',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'sigFormat' =>
      array (
        'setter' => 'setSigFormat',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'Timing' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'repeat' =>
      array (
        'setter' => 'setRepeat',
        'element' => 'Timing.Repeat',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Timing.Repeat' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'boundsDuration' =>
      array (
        'setter' => 'setBoundsDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'boundsRange' =>
      array (
        'setter' => 'setBoundsRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'boundsPeriod' =>
      array (
        'setter' => 'setBoundsPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'countMax' =>
      array (
        'setter' => 'setCountMax',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'duration' =>
      array (
        'setter' => 'setDuration',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'durationMax' =>
      array (
        'setter' => 'setDurationMax',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'durationUnit' =>
      array (
        'setter' => 'setDurationUnit',
        'element' => 'UnitsOfTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnitsOfTime',
      ),
      'frequency' =>
      array (
        'setter' => 'setFrequency',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'frequencyMax' =>
      array (
        'setter' => 'setFrequencyMax',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'periodMax' =>
      array (
        'setter' => 'setPeriodMax',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'periodUnit' =>
      array (
        'setter' => 'setPeriodUnit',
        'element' => 'UnitsOfTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnitsOfTime',
      ),
      'dayOfWeek' =>
      array (
        'setter' => 'addDayOfWeek',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'timeOfDay' =>
      array (
        'setter' => 'addTimeOfDay',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'when' =>
      array (
        'setter' => 'addWhen',
        'element' => 'EventTiming',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventTiming',
      ),
      'offset' =>
      array (
        'setter' => 'setOffset',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
    ),
    ),
    'UnitsOfTime' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnitsOfTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'UnitsOfTime-list',
        'type' => 'string',
      ),
    ),
    ),
    'EventTiming' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventTiming',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventTiming-list',
        'type' => 'string',
      ),
    ),
    ),
    'ProdCharacteristic' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProdCharacteristic',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'height' =>
      array (
        'setter' => 'setHeight',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'width' =>
      array (
        'setter' => 'setWidth',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'depth' =>
      array (
        'setter' => 'setDepth',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'weight' =>
      array (
        'setter' => 'setWeight',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'nominalVolume' =>
      array (
        'setter' => 'setNominalVolume',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'externalDiameter' =>
      array (
        'setter' => 'setExternalDiameter',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'shape' =>
      array (
        'setter' => 'setShape',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'color' =>
      array (
        'setter' => 'addColor',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'imprint' =>
      array (
        'setter' => 'addImprint',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'scoring' =>
      array (
        'setter' => 'setScoring',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'CodeableConcept' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'coding' =>
      array (
        'setter' => 'addCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ParameterDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ElementDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'representation' =>
      array (
        'setter' => 'addRepresentation',
        'element' => 'PropertyRepresentation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyRepresentation',
      ),
      'sliceName' =>
      array (
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'sliceIsConstraining' =>
      array (
        'setter' => 'setSliceIsConstraining',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'label' =>
      array (
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'slicing' =>
      array (
        'setter' => 'setSlicing',
        'element' => 'ElementDefinition.Slicing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing',
      ),
      'short' =>
      array (
        'setter' => 'setShort',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'requirements' =>
      array (
        'setter' => 'setRequirements',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'base' =>
      array (
        'setter' => 'setBase',
        'element' => 'ElementDefinition.Base',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'ElementDefinition.Type',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType',
      ),
      'defaultValueBase64Binary' =>
      array (
        'setter' => 'setDefaultValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'defaultValueBoolean' =>
      array (
        'setter' => 'setDefaultValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'defaultValueCanonical' =>
      array (
        'setter' => 'setDefaultValueCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'defaultValueCode' =>
      array (
        'setter' => 'setDefaultValueCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'defaultValueDate' =>
      array (
        'setter' => 'setDefaultValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'defaultValueDateTime' =>
      array (
        'setter' => 'setDefaultValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'defaultValueDecimal' =>
      array (
        'setter' => 'setDefaultValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'defaultValueId' =>
      array (
        'setter' => 'setDefaultValueId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'defaultValueInstant' =>
      array (
        'setter' => 'setDefaultValueInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'defaultValueInteger' =>
      array (
        'setter' => 'setDefaultValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'defaultValueMarkdown' =>
      array (
        'setter' => 'setDefaultValueMarkdown',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'defaultValueOid' =>
      array (
        'setter' => 'setDefaultValueOid',
        'element' => 'oid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
      ),
      'defaultValuePositiveInt' =>
      array (
        'setter' => 'setDefaultValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'defaultValueString' =>
      array (
        'setter' => 'setDefaultValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'defaultValueTime' =>
      array (
        'setter' => 'setDefaultValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'defaultValueUnsignedInt' =>
      array (
        'setter' => 'setDefaultValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'defaultValueUri' =>
      array (
        'setter' => 'setDefaultValueUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'defaultValueUrl' =>
      array (
        'setter' => 'setDefaultValueUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'defaultValueUuid' =>
      array (
        'setter' => 'setDefaultValueUuid',
        'element' => 'uuid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
      ),
      'defaultValueAddress' =>
      array (
        'setter' => 'setDefaultValueAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'defaultValueAge' =>
      array (
        'setter' => 'setDefaultValueAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'defaultValueAnnotation' =>
      array (
        'setter' => 'setDefaultValueAnnotation',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'defaultValueAttachment' =>
      array (
        'setter' => 'setDefaultValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'defaultValueCodeableConcept' =>
      array (
        'setter' => 'setDefaultValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'defaultValueCoding' =>
      array (
        'setter' => 'setDefaultValueCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'defaultValueContactPoint' =>
      array (
        'setter' => 'setDefaultValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'defaultValueCount' =>
      array (
        'setter' => 'setDefaultValueCount',
        'element' => 'Count',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'defaultValueDistance' =>
      array (
        'setter' => 'setDefaultValueDistance',
        'element' => 'Distance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'defaultValueDuration' =>
      array (
        'setter' => 'setDefaultValueDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'defaultValueHumanName' =>
      array (
        'setter' => 'setDefaultValueHumanName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'defaultValueIdentifier' =>
      array (
        'setter' => 'setDefaultValueIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'defaultValueMoney' =>
      array (
        'setter' => 'setDefaultValueMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'defaultValuePeriod' =>
      array (
        'setter' => 'setDefaultValuePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'defaultValueQuantity' =>
      array (
        'setter' => 'setDefaultValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'defaultValueRange' =>
      array (
        'setter' => 'setDefaultValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'defaultValueRatio' =>
      array (
        'setter' => 'setDefaultValueRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'defaultValueReference' =>
      array (
        'setter' => 'setDefaultValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'defaultValueSampledData' =>
      array (
        'setter' => 'setDefaultValueSampledData',
        'element' => 'SampledData',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
      ),
      'defaultValueSignature' =>
      array (
        'setter' => 'setDefaultValueSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
      'defaultValueTiming' =>
      array (
        'setter' => 'setDefaultValueTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'defaultValueContactDetail' =>
      array (
        'setter' => 'setDefaultValueContactDetail',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'defaultValueContributor' =>
      array (
        'setter' => 'setDefaultValueContributor',
        'element' => 'Contributor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
      ),
      'defaultValueDataRequirement' =>
      array (
        'setter' => 'setDefaultValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'defaultValueExpression' =>
      array (
        'setter' => 'setDefaultValueExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'defaultValueParameterDefinition' =>
      array (
        'setter' => 'setDefaultValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
      ),
      'defaultValueRelatedArtifact' =>
      array (
        'setter' => 'setDefaultValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'defaultValueTriggerDefinition' =>
      array (
        'setter' => 'setDefaultValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'defaultValueUsageContext' =>
      array (
        'setter' => 'setDefaultValueUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'defaultValueDosage' =>
      array (
        'setter' => 'setDefaultValueDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
      'meaningWhenMissing' =>
      array (
        'setter' => 'setMeaningWhenMissing',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'orderMeaning' =>
      array (
        'setter' => 'setOrderMeaning',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'fixedBase64Binary' =>
      array (
        'setter' => 'setFixedBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'fixedBoolean' =>
      array (
        'setter' => 'setFixedBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'fixedCanonical' =>
      array (
        'setter' => 'setFixedCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'fixedCode' =>
      array (
        'setter' => 'setFixedCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'fixedDate' =>
      array (
        'setter' => 'setFixedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'fixedDateTime' =>
      array (
        'setter' => 'setFixedDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'fixedDecimal' =>
      array (
        'setter' => 'setFixedDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'fixedId' =>
      array (
        'setter' => 'setFixedId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'fixedInstant' =>
      array (
        'setter' => 'setFixedInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'fixedInteger' =>
      array (
        'setter' => 'setFixedInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'fixedMarkdown' =>
      array (
        'setter' => 'setFixedMarkdown',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'fixedOid' =>
      array (
        'setter' => 'setFixedOid',
        'element' => 'oid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
      ),
      'fixedPositiveInt' =>
      array (
        'setter' => 'setFixedPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'fixedString' =>
      array (
        'setter' => 'setFixedString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'fixedTime' =>
      array (
        'setter' => 'setFixedTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'fixedUnsignedInt' =>
      array (
        'setter' => 'setFixedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'fixedUri' =>
      array (
        'setter' => 'setFixedUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'fixedUrl' =>
      array (
        'setter' => 'setFixedUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'fixedUuid' =>
      array (
        'setter' => 'setFixedUuid',
        'element' => 'uuid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
      ),
      'fixedAddress' =>
      array (
        'setter' => 'setFixedAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'fixedAge' =>
      array (
        'setter' => 'setFixedAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'fixedAnnotation' =>
      array (
        'setter' => 'setFixedAnnotation',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'fixedAttachment' =>
      array (
        'setter' => 'setFixedAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'fixedCodeableConcept' =>
      array (
        'setter' => 'setFixedCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fixedCoding' =>
      array (
        'setter' => 'setFixedCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'fixedContactPoint' =>
      array (
        'setter' => 'setFixedContactPoint',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'fixedCount' =>
      array (
        'setter' => 'setFixedCount',
        'element' => 'Count',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'fixedDistance' =>
      array (
        'setter' => 'setFixedDistance',
        'element' => 'Distance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'fixedDuration' =>
      array (
        'setter' => 'setFixedDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'fixedHumanName' =>
      array (
        'setter' => 'setFixedHumanName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'fixedIdentifier' =>
      array (
        'setter' => 'setFixedIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'fixedMoney' =>
      array (
        'setter' => 'setFixedMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'fixedPeriod' =>
      array (
        'setter' => 'setFixedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'fixedQuantity' =>
      array (
        'setter' => 'setFixedQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'fixedRange' =>
      array (
        'setter' => 'setFixedRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'fixedRatio' =>
      array (
        'setter' => 'setFixedRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'fixedReference' =>
      array (
        'setter' => 'setFixedReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'fixedSampledData' =>
      array (
        'setter' => 'setFixedSampledData',
        'element' => 'SampledData',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
      ),
      'fixedSignature' =>
      array (
        'setter' => 'setFixedSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
      'fixedTiming' =>
      array (
        'setter' => 'setFixedTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'fixedContactDetail' =>
      array (
        'setter' => 'setFixedContactDetail',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'fixedContributor' =>
      array (
        'setter' => 'setFixedContributor',
        'element' => 'Contributor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
      ),
      'fixedDataRequirement' =>
      array (
        'setter' => 'setFixedDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'fixedExpression' =>
      array (
        'setter' => 'setFixedExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'fixedParameterDefinition' =>
      array (
        'setter' => 'setFixedParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
      ),
      'fixedRelatedArtifact' =>
      array (
        'setter' => 'setFixedRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'fixedTriggerDefinition' =>
      array (
        'setter' => 'setFixedTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'fixedUsageContext' =>
      array (
        'setter' => 'setFixedUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'fixedDosage' =>
      array (
        'setter' => 'setFixedDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
      'patternBase64Binary' =>
      array (
        'setter' => 'setPatternBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'patternBoolean' =>
      array (
        'setter' => 'setPatternBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'patternCanonical' =>
      array (
        'setter' => 'setPatternCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'patternCode' =>
      array (
        'setter' => 'setPatternCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'patternDate' =>
      array (
        'setter' => 'setPatternDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'patternDateTime' =>
      array (
        'setter' => 'setPatternDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'patternDecimal' =>
      array (
        'setter' => 'setPatternDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'patternId' =>
      array (
        'setter' => 'setPatternId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'patternInstant' =>
      array (
        'setter' => 'setPatternInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'patternInteger' =>
      array (
        'setter' => 'setPatternInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'patternMarkdown' =>
      array (
        'setter' => 'setPatternMarkdown',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'patternOid' =>
      array (
        'setter' => 'setPatternOid',
        'element' => 'oid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
      ),
      'patternPositiveInt' =>
      array (
        'setter' => 'setPatternPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'patternString' =>
      array (
        'setter' => 'setPatternString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'patternTime' =>
      array (
        'setter' => 'setPatternTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'patternUnsignedInt' =>
      array (
        'setter' => 'setPatternUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'patternUri' =>
      array (
        'setter' => 'setPatternUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'patternUrl' =>
      array (
        'setter' => 'setPatternUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'patternUuid' =>
      array (
        'setter' => 'setPatternUuid',
        'element' => 'uuid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
      ),
      'patternAddress' =>
      array (
        'setter' => 'setPatternAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'patternAge' =>
      array (
        'setter' => 'setPatternAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'patternAnnotation' =>
      array (
        'setter' => 'setPatternAnnotation',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'patternAttachment' =>
      array (
        'setter' => 'setPatternAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'patternCodeableConcept' =>
      array (
        'setter' => 'setPatternCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patternCoding' =>
      array (
        'setter' => 'setPatternCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'patternContactPoint' =>
      array (
        'setter' => 'setPatternContactPoint',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'patternCount' =>
      array (
        'setter' => 'setPatternCount',
        'element' => 'Count',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'patternDistance' =>
      array (
        'setter' => 'setPatternDistance',
        'element' => 'Distance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'patternDuration' =>
      array (
        'setter' => 'setPatternDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'patternHumanName' =>
      array (
        'setter' => 'setPatternHumanName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'patternIdentifier' =>
      array (
        'setter' => 'setPatternIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'patternMoney' =>
      array (
        'setter' => 'setPatternMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'patternPeriod' =>
      array (
        'setter' => 'setPatternPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'patternQuantity' =>
      array (
        'setter' => 'setPatternQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'patternRange' =>
      array (
        'setter' => 'setPatternRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'patternRatio' =>
      array (
        'setter' => 'setPatternRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'patternReference' =>
      array (
        'setter' => 'setPatternReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'patternSampledData' =>
      array (
        'setter' => 'setPatternSampledData',
        'element' => 'SampledData',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
      ),
      'patternSignature' =>
      array (
        'setter' => 'setPatternSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
      'patternTiming' =>
      array (
        'setter' => 'setPatternTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'patternContactDetail' =>
      array (
        'setter' => 'setPatternContactDetail',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'patternContributor' =>
      array (
        'setter' => 'setPatternContributor',
        'element' => 'Contributor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
      ),
      'patternDataRequirement' =>
      array (
        'setter' => 'setPatternDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'patternExpression' =>
      array (
        'setter' => 'setPatternExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'patternParameterDefinition' =>
      array (
        'setter' => 'setPatternParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
      ),
      'patternRelatedArtifact' =>
      array (
        'setter' => 'setPatternRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'patternTriggerDefinition' =>
      array (
        'setter' => 'setPatternTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'patternUsageContext' =>
      array (
        'setter' => 'setPatternUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'patternDosage' =>
      array (
        'setter' => 'setPatternDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
      'example' =>
      array (
        'setter' => 'addExample',
        'element' => 'ElementDefinition.Example',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample',
      ),
      'minValueDate' =>
      array (
        'setter' => 'setMinValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'minValueDateTime' =>
      array (
        'setter' => 'setMinValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'minValueInstant' =>
      array (
        'setter' => 'setMinValueInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'minValueTime' =>
      array (
        'setter' => 'setMinValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'minValueDecimal' =>
      array (
        'setter' => 'setMinValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'minValueInteger' =>
      array (
        'setter' => 'setMinValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'minValuePositiveInt' =>
      array (
        'setter' => 'setMinValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'minValueUnsignedInt' =>
      array (
        'setter' => 'setMinValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'minValueQuantity' =>
      array (
        'setter' => 'setMinValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'maxValueDate' =>
      array (
        'setter' => 'setMaxValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'maxValueDateTime' =>
      array (
        'setter' => 'setMaxValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'maxValueInstant' =>
      array (
        'setter' => 'setMaxValueInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'maxValueTime' =>
      array (
        'setter' => 'setMaxValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'maxValueDecimal' =>
      array (
        'setter' => 'setMaxValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'maxValueInteger' =>
      array (
        'setter' => 'setMaxValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'maxValuePositiveInt' =>
      array (
        'setter' => 'setMaxValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'maxValueUnsignedInt' =>
      array (
        'setter' => 'setMaxValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'maxValueQuantity' =>
      array (
        'setter' => 'setMaxValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'maxLength' =>
      array (
        'setter' => 'setMaxLength',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'condition' =>
      array (
        'setter' => 'addCondition',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'constraint' =>
      array (
        'setter' => 'addConstraint',
        'element' => 'ElementDefinition.Constraint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint',
      ),
      'mustSupport' =>
      array (
        'setter' => 'setMustSupport',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'isModifier' =>
      array (
        'setter' => 'setIsModifier',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'isModifierReason' =>
      array (
        'setter' => 'setIsModifierReason',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'isSummary' =>
      array (
        'setter' => 'setIsSummary',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'binding' =>
      array (
        'setter' => 'setBinding',
        'element' => 'ElementDefinition.Binding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding',
      ),
      'mapping' =>
      array (
        'setter' => 'addMapping',
        'element' => 'ElementDefinition.Mapping',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping',
      ),
    ),
    ),
    'ElementDefinition.Constraint' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'key' =>
      array (
        'setter' => 'setKey',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'requirements' =>
      array (
        'setter' => 'setRequirements',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'ConstraintSeverity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConstraintSeverity',
      ),
      'human' =>
      array (
        'setter' => 'setHuman',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'xpath' =>
      array (
        'setter' => 'setXpath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ElementDefinition.Mapping' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identity' =>
      array (
        'setter' => 'setIdentity',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'map' =>
      array (
        'setter' => 'setMap',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ElementDefinition.Base' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ElementDefinition.Type' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'targetProfile' =>
      array (
        'setter' => 'addTargetProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'aggregation' =>
      array (
        'setter' => 'addAggregation',
        'element' => 'AggregationMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAggregationMode',
      ),
      'versioning' =>
      array (
        'setter' => 'setVersioning',
        'element' => 'ReferenceVersionRules',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceVersionRules',
      ),
    ),
    ),
    'ElementDefinition.Example' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'label' =>
      array (
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueCanonical' =>
      array (
        'setter' => 'setValueCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'valueId' =>
      array (
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'valueInstant' =>
      array (
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'valueMarkdown' =>
      array (
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'valueOid' =>
      array (
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid',
      ),
      'valuePositiveInt' =>
      array (
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'valueUnsignedInt' =>
      array (
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'valueUrl' =>
      array (
        'setter' => 'setValueUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'valueUuid' =>
      array (
        'setter' => 'setValueUuid',
        'element' => 'uuid',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid',
      ),
      'valueAddress' =>
      array (
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'valueAge' =>
      array (
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'valueAnnotation' =>
      array (
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'valueContactPoint' =>
      array (
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'valueCount' =>
      array (
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'valueDistance' =>
      array (
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'valueHumanName' =>
      array (
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'valueIdentifier' =>
      array (
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData',
      ),
      'valueSignature' =>
      array (
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
      'valueTiming' =>
      array (
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'valueContactDetail' =>
      array (
        'setter' => 'setValueContactDetail',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'valueContributor' =>
      array (
        'setter' => 'setValueContributor',
        'element' => 'Contributor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor',
      ),
      'valueDataRequirement' =>
      array (
        'setter' => 'setValueDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'valueExpression' =>
      array (
        'setter' => 'setValueExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'valueParameterDefinition' =>
      array (
        'setter' => 'setValueParameterDefinition',
        'element' => 'ParameterDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition',
      ),
      'valueRelatedArtifact' =>
      array (
        'setter' => 'setValueRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'valueTriggerDefinition' =>
      array (
        'setter' => 'setValueTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'valueUsageContext' =>
      array (
        'setter' => 'setValueUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'valueDosage' =>
      array (
        'setter' => 'setValueDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
    ),
    ),
    'ElementDefinition.Slicing' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'discriminator' =>
      array (
        'setter' => 'addDiscriminator',
        'element' => 'ElementDefinition.Discriminator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'ordered' =>
      array (
        'setter' => 'setOrdered',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'rules' =>
      array (
        'setter' => 'setRules',
        'element' => 'SlicingRules',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSlicingRules',
      ),
    ),
    ),
    'ElementDefinition.Binding' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'strength' =>
      array (
        'setter' => 'setStrength',
        'element' => 'BindingStrength',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBindingStrength',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ElementDefinition.Discriminator' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DiscriminatorType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiscriminatorType',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'PropertyRepresentation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyRepresentation',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PropertyRepresentation-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConstraintSeverity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConstraintSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConstraintSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'AggregationMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAggregationMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AggregationMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ReferenceVersionRules' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceVersionRules',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ReferenceVersionRules-list',
        'type' => 'string',
      ),
    ),
    ),
    'SlicingRules' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSlicingRules',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SlicingRules-list',
        'type' => 'string',
      ),
    ),
    ),
    'BindingStrength' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBindingStrength',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BindingStrength-list',
        'type' => 'string',
      ),
    ),
    ),
    'DiscriminatorType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiscriminatorType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DiscriminatorType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DomainResource' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDomainResource',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
    ),
    ),
    'Resource' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource',
    'extendedElementName' => null,
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'PublicationStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PublicationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'SearchParamType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchParamType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SearchParamType-list',
        'type' => 'string',
      ),
    ),
    ),
    'AdministrativeGender' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAdministrativeGender',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AdministrativeGender-list',
        'type' => 'string',
      ),
    ),
    ),
    'FHIRVersion' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRVersion',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FHIRVersion-list',
        'type' => 'string',
      ),
    ),
    ),
    'NoteType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNoteType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NoteType-list',
        'type' => 'string',
      ),
    ),
    ),
    'RemittanceOutcome' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRemittanceOutcome',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RemittanceOutcome-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConceptMapEquivalence' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapEquivalence',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConceptMapEquivalence-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentReferenceStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentReferenceStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentReferenceStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Account' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAccount',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'AccountStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAccountStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'addSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'servicePeriod' =>
      array (
        'setter' => 'setServicePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'coverage' =>
      array (
        'setter' => 'addCoverage',
        'element' => 'Account.Coverage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage',
      ),
      'owner' =>
      array (
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'guarantor' =>
      array (
        'setter' => 'addGuarantor',
        'element' => 'Account.Guarantor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor',
      ),
      'partOf' =>
      array (
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Account.Coverage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'Account.Guarantor' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'onHold' =>
      array (
        'setter' => 'setOnHold',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'AccountStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAccountStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AccountStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ActivityDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRActivityDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subtitle' =>
      array (
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'subjectCodeableConcept' =>
      array (
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subjectReference' =>
      array (
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'editor' =>
      array (
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'reviewer' =>
      array (
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'endorser' =>
      array (
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'library' =>
      array (
        'setter' => 'addLibrary',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'RequestResourceType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'RequestIntent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestIntent',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority',
      ),
      'doNotPerform' =>
      array (
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'timingTiming' =>
      array (
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'timingDateTime' =>
      array (
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'timingAge' =>
      array (
        'setter' => 'setTimingAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'timingRange' =>
      array (
        'setter' => 'setTimingRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'timingDuration' =>
      array (
        'setter' => 'setTimingDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'ActivityDefinition.Participant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant',
      ),
      'productReference' =>
      array (
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productCodeableConcept' =>
      array (
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'dosage' =>
      array (
        'setter' => 'addDosage',
        'element' => 'Dosage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage',
      ),
      'bodySite' =>
      array (
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specimenRequirement' =>
      array (
        'setter' => 'addSpecimenRequirement',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'observationRequirement' =>
      array (
        'setter' => 'addObservationRequirement',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'observationResultRequirement' =>
      array (
        'setter' => 'addObservationResultRequirement',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'transform' =>
      array (
        'setter' => 'setTransform',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'dynamicValue' =>
      array (
        'setter' => 'addDynamicValue',
        'element' => 'ActivityDefinition.DynamicValue',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue',
      ),
    ),
    ),
    'ActivityDefinition.Participant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ActionParticipantType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionParticipantType',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ActivityDefinition.DynamicValue' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
    ),
    ),
    'ActionParticipantType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionParticipantType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ActionParticipantType-list',
        'type' => 'string',
      ),
    ),
    ),
    'RequestIntent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestIntent',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestIntent-list',
        'type' => 'string',
      ),
    ),
    ),
    'RequestResourceType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestResourceType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestResourceType-list',
        'type' => 'string',
      ),
    ),
    ),
    'RequestPriority' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestPriority-list',
        'type' => 'string',
      ),
    ),
    ),
    'AdverseEvent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAdverseEvent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'actuality' =>
      array (
        'setter' => 'setActuality',
        'element' => 'AdverseEventActuality',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAdverseEventActuality',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'event' =>
      array (
        'setter' => 'setEvent',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'detected' =>
      array (
        'setter' => 'setDetected',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'recordedDate' =>
      array (
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'resultingCondition' =>
      array (
        'setter' => 'addResultingCondition',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'seriousness' =>
      array (
        'setter' => 'setSeriousness',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contributor' =>
      array (
        'setter' => 'addContributor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'suspectEntity' =>
      array (
        'setter' => 'addSuspectEntity',
        'element' => 'AdverseEvent.SuspectEntity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity',
      ),
      'subjectMedicalHistory' =>
      array (
        'setter' => 'addSubjectMedicalHistory',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'referenceDocument' =>
      array (
        'setter' => 'addReferenceDocument',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'study' =>
      array (
        'setter' => 'addStudy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'AdverseEvent.SuspectEntity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'instance' =>
      array (
        'setter' => 'setInstance',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'causality' =>
      array (
        'setter' => 'addCausality',
        'element' => 'AdverseEvent.Causality',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventCausality',
      ),
    ),
    ),
    'AdverseEvent.Causality' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventCausality',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'assessment' =>
      array (
        'setter' => 'setAssessment',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productRelatedness' =>
      array (
        'setter' => 'setProductRelatedness',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'AdverseEventActuality' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAdverseEventActuality',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AdverseEventActuality-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntolerance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAllergyIntolerance',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'clinicalStatus' =>
      array (
        'setter' => 'setClinicalStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'verificationStatus' =>
      array (
        'setter' => 'setVerificationStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AllergyIntoleranceType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceType',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'AllergyIntoleranceCategory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCategory',
      ),
      'criticality' =>
      array (
        'setter' => 'setCriticality',
        'element' => 'AllergyIntoleranceCriticality',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCriticality',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'onsetDateTime' =>
      array (
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'recordedDate' =>
      array (
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'asserter' =>
      array (
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'lastOccurrence' =>
      array (
        'setter' => 'setLastOccurrence',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'reaction' =>
      array (
        'setter' => 'addReaction',
        'element' => 'AllergyIntolerance.Reaction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction',
      ),
    ),
    ),
    'AllergyIntolerance.Reaction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'substance' =>
      array (
        'setter' => 'setSubstance',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'manifestation' =>
      array (
        'setter' => 'addManifestation',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'onset' =>
      array (
        'setter' => 'setOnset',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'AllergyIntoleranceSeverity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceSeverity',
      ),
      'exposureRoute' =>
      array (
        'setter' => 'setExposureRoute',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'AllergyIntoleranceCriticality' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCriticality',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCriticality-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceType-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceCategory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceSeverity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'Appointment' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointment',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'AppointmentStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAppointmentStatus',
      ),
      'cancelationReason' =>
      array (
        'setter' => 'setCancelationReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'serviceCategory' =>
      array (
        'setter' => 'addServiceCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'serviceType' =>
      array (
        'setter' => 'addServiceType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialty' =>
      array (
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'appointmentType' =>
      array (
        'setter' => 'setAppointmentType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'minutesDuration' =>
      array (
        'setter' => 'setMinutesDuration',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'slot' =>
      array (
        'setter' => 'addSlot',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'patientInstruction' =>
      array (
        'setter' => 'setPatientInstruction',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'Appointment.Participant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant',
      ),
      'requestedPeriod' =>
      array (
        'setter' => 'addRequestedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Appointment.Participant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'required' =>
      array (
        'setter' => 'setRequired',
        'element' => 'ParticipantRequired',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipantRequired',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ParticipationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipationStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'ParticipantRequired' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipantRequired',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ParticipantRequired-list',
        'type' => 'string',
      ),
    ),
    ),
    'AppointmentStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAppointmentStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AppointmentStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ParticipationStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ParticipationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'AppointmentResponse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointmentResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'appointment' =>
      array (
        'setter' => 'setAppointment',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'participantType' =>
      array (
        'setter' => 'addParticipantType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'participantStatus' =>
      array (
        'setter' => 'setParticipantStatus',
        'element' => 'ParticipationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipationStatus',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'AuditEvent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAuditEvent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'subtype' =>
      array (
        'setter' => 'addSubtype',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'action' =>
      array (
        'setter' => 'setAction',
        'element' => 'AuditEventAction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAction',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'recorded' =>
      array (
        'setter' => 'setRecorded',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'AuditEventOutcome',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventOutcome',
      ),
      'outcomeDesc' =>
      array (
        'setter' => 'setOutcomeDesc',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'purposeOfEvent' =>
      array (
        'setter' => 'addPurposeOfEvent',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'agent' =>
      array (
        'setter' => 'addAgent',
        'element' => 'AuditEvent.Agent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'AuditEvent.Source',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource',
      ),
      'entity' =>
      array (
        'setter' => 'addEntity',
        'element' => 'AuditEvent.Entity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity',
      ),
    ),
    ),
    'AuditEvent.Agent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'role' =>
      array (
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'who' =>
      array (
        'setter' => 'setWho',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'altId' =>
      array (
        'setter' => 'setAltId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'requestor' =>
      array (
        'setter' => 'setRequestor',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'policy' =>
      array (
        'setter' => 'addPolicy',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'media' =>
      array (
        'setter' => 'setMedia',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'AuditEvent.Network',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork',
      ),
      'purposeOfUse' =>
      array (
        'setter' => 'addPurposeOfUse',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'AuditEvent.Network' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AuditEventAgentNetworkType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAgentNetworkType',
      ),
    ),
    ),
    'AuditEvent.Source' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'observer' =>
      array (
        'setter' => 'setObserver',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'AuditEvent.Entity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'what' =>
      array (
        'setter' => 'setWhat',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'lifecycle' =>
      array (
        'setter' => 'setLifecycle',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'query' =>
      array (
        'setter' => 'setQuery',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'AuditEvent.Detail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail',
      ),
    ),
    ),
    'AuditEvent.Detail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'AuditEventOutcome' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventOutcome',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventOutcome-list',
        'type' => 'string',
      ),
    ),
    ),
    'AuditEventAction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventAction-list',
        'type' => 'string',
      ),
    ),
    ),
    'AuditEventAgentNetworkType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAgentNetworkType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventAgentNetworkType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Basic' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBasic',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Binary' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBinary',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'contentType' =>
      array (
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'securityContext' =>
      array (
        'setter' => 'setSecurityContext',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'BiologicallyDerivedProduct' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBiologicallyDerivedProduct',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'productCategory' =>
      array (
        'setter' => 'setProductCategory',
        'element' => 'BiologicallyDerivedProductCategory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductCategory',
      ),
      'productCode' =>
      array (
        'setter' => 'setProductCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'BiologicallyDerivedProductStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStatus',
      ),
      'request' =>
      array (
        'setter' => 'addRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'parent' =>
      array (
        'setter' => 'addParent',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'collection' =>
      array (
        'setter' => 'setCollection',
        'element' => 'BiologicallyDerivedProduct.Collection',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductCollection',
      ),
      'processing' =>
      array (
        'setter' => 'addProcessing',
        'element' => 'BiologicallyDerivedProduct.Processing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductProcessing',
      ),
      'manipulation' =>
      array (
        'setter' => 'setManipulation',
        'element' => 'BiologicallyDerivedProduct.Manipulation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductManipulation',
      ),
      'storage' =>
      array (
        'setter' => 'addStorage',
        'element' => 'BiologicallyDerivedProduct.Storage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductStorage',
      ),
    ),
    ),
    'BiologicallyDerivedProduct.Collection' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductCollection',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'collector' =>
      array (
        'setter' => 'setCollector',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'collectedDateTime' =>
      array (
        'setter' => 'setCollectedDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'collectedPeriod' =>
      array (
        'setter' => 'setCollectedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'BiologicallyDerivedProduct.Processing' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductProcessing',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'procedure' =>
      array (
        'setter' => 'setProcedure',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'additive' =>
      array (
        'setter' => 'setAdditive',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'timeDateTime' =>
      array (
        'setter' => 'setTimeDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'timePeriod' =>
      array (
        'setter' => 'setTimePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'BiologicallyDerivedProduct.Manipulation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductManipulation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'timeDateTime' =>
      array (
        'setter' => 'setTimeDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'timePeriod' =>
      array (
        'setter' => 'setTimePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'BiologicallyDerivedProduct.Storage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductStorage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'temperature' =>
      array (
        'setter' => 'setTemperature',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'scale' =>
      array (
        'setter' => 'setScale',
        'element' => 'BiologicallyDerivedProductStorageScale',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStorageScale',
      ),
      'duration' =>
      array (
        'setter' => 'setDuration',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'BiologicallyDerivedProductCategory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'BiologicallyDerivedProductStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'BiologicallyDerivedProductStorageScale' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStorageScale',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BiologicallyDerivedProductStorageScale-list',
        'type' => 'string',
      ),
    ),
    ),
    'BodyStructure' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBodyStructure',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'morphology' =>
      array (
        'setter' => 'setMorphology',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationQualifier' =>
      array (
        'setter' => 'addLocationQualifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Bundle' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'BundleType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBundleType',
      ),
      'timestamp' =>
      array (
        'setter' => 'setTimestamp',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'total' =>
      array (
        'setter' => 'setTotal',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
      ),
      'entry' =>
      array (
        'setter' => 'addEntry',
        'element' => 'Bundle.Entry',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleEntry',
      ),
      'signature' =>
      array (
        'setter' => 'setSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
    ),
    ),
    'Bundle.Link' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'relation' =>
      array (
        'setter' => 'setRelation',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'Bundle.Entry' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleEntry',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
      ),
      'fullUrl' =>
      array (
        'setter' => 'setFullUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'search' =>
      array (
        'setter' => 'setSearch',
        'element' => 'Bundle.Search',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleSearch',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Bundle.Request',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleRequest',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'Bundle.Response',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleResponse',
      ),
    ),
    ),
    'Bundle.Search' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleSearch',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'SearchEntryMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchEntryMode',
      ),
      'score' =>
      array (
        'setter' => 'setScore',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'Bundle.Request' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleRequest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'HTTPVerb',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHTTPVerb',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'ifNoneMatch' =>
      array (
        'setter' => 'setIfNoneMatch',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'ifModifiedSince' =>
      array (
        'setter' => 'setIfModifiedSince',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'ifMatch' =>
      array (
        'setter' => 'setIfMatch',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'ifNoneExist' =>
      array (
        'setter' => 'setIfNoneExist',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Bundle.Response' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleResponse',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'etag' =>
      array (
        'setter' => 'setEtag',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'lastModified' =>
      array (
        'setter' => 'setLastModified',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
    ),
    ),
    'HTTPVerb' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHTTPVerb',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'HTTPVerb-list',
        'type' => 'string',
      ),
    ),
    ),
    'BundleType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBundleType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BundleType-list',
        'type' => 'string',
      ),
    ),
    ),
    'SearchEntryMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchEntryMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SearchEntryMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'CapabilityStatement' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCapabilityStatement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'CapabilityStatementKind',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCapabilityStatementKind',
      ),
      'instantiates' =>
      array (
        'setter' => 'addInstantiates',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'imports' =>
      array (
        'setter' => 'addImports',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'software' =>
      array (
        'setter' => 'setSoftware',
        'element' => 'CapabilityStatement.Software',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware',
      ),
      'implementation' =>
      array (
        'setter' => 'setImplementation',
        'element' => 'CapabilityStatement.Implementation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation',
      ),
      'fhirVersion' =>
      array (
        'setter' => 'setFhirVersion',
        'element' => 'FHIRVersion',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRVersion',
      ),
      'format' =>
      array (
        'setter' => 'addFormat',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'patchFormat' =>
      array (
        'setter' => 'addPatchFormat',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'implementationGuide' =>
      array (
        'setter' => 'addImplementationGuide',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'rest' =>
      array (
        'setter' => 'addRest',
        'element' => 'CapabilityStatement.Rest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest',
      ),
      'messaging' =>
      array (
        'setter' => 'addMessaging',
        'element' => 'CapabilityStatement.Messaging',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging',
      ),
      'document' =>
      array (
        'setter' => 'addDocument',
        'element' => 'CapabilityStatement.Document',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument',
      ),
    ),
    ),
    'CapabilityStatement.Software' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'releaseDate' =>
      array (
        'setter' => 'setReleaseDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'CapabilityStatement.Implementation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'custodian' =>
      array (
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CapabilityStatement.Rest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'RestfulCapabilityMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRestfulCapabilityMode',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'security' =>
      array (
        'setter' => 'setSecurity',
        'element' => 'CapabilityStatement.Security',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'CapabilityStatement.Resource',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource',
      ),
      'interaction' =>
      array (
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1',
      ),
      'searchParam' =>
      array (
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
      ),
      'operation' =>
      array (
        'setter' => 'addOperation',
        'element' => 'CapabilityStatement.Operation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation',
      ),
      'compartment' =>
      array (
        'setter' => 'addCompartment',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'CapabilityStatement.Security' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'cors' =>
      array (
        'setter' => 'setCors',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'service' =>
      array (
        'setter' => 'addService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'CapabilityStatement.Resource' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'supportedProfile' =>
      array (
        'setter' => 'addSupportedProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'interaction' =>
      array (
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction',
      ),
      'versioning' =>
      array (
        'setter' => 'setVersioning',
        'element' => 'ResourceVersionPolicy',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceVersionPolicy',
      ),
      'readHistory' =>
      array (
        'setter' => 'setReadHistory',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'updateCreate' =>
      array (
        'setter' => 'setUpdateCreate',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalCreate' =>
      array (
        'setter' => 'setConditionalCreate',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalRead' =>
      array (
        'setter' => 'setConditionalRead',
        'element' => 'ConditionalReadStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalReadStatus',
      ),
      'conditionalUpdate' =>
      array (
        'setter' => 'setConditionalUpdate',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalDelete' =>
      array (
        'setter' => 'setConditionalDelete',
        'element' => 'ConditionalDeleteStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalDeleteStatus',
      ),
      'referencePolicy' =>
      array (
        'setter' => 'addReferencePolicy',
        'element' => 'ReferenceHandlingPolicy',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceHandlingPolicy',
      ),
      'searchInclude' =>
      array (
        'setter' => 'addSearchInclude',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'searchRevInclude' =>
      array (
        'setter' => 'addSearchRevInclude',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'searchParam' =>
      array (
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
      ),
      'operation' =>
      array (
        'setter' => 'addOperation',
        'element' => 'CapabilityStatement.Operation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation',
      ),
    ),
    ),
    'CapabilityStatement.Interaction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'TypeRestfulInteraction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTypeRestfulInteraction',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'CapabilityStatement.SearchParam' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'SearchParamType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchParamType',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'CapabilityStatement.Operation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'CapabilityStatement.Interaction1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'SystemRestfulInteraction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSystemRestfulInteraction',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'CapabilityStatement.Messaging' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'CapabilityStatement.Endpoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint',
      ),
      'reliableCache' =>
      array (
        'setter' => 'setReliableCache',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'supportedMessage' =>
      array (
        'setter' => 'addSupportedMessage',
        'element' => 'CapabilityStatement.SupportedMessage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage',
      ),
    ),
    ),
    'CapabilityStatement.Endpoint' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'protocol' =>
      array (
        'setter' => 'setProtocol',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
    ),
    ),
    'CapabilityStatement.SupportedMessage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'EventCapabilityMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventCapabilityMode',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'CapabilityStatement.Document' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'DocumentMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentMode',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'CapabilityStatementKind' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCapabilityStatementKind',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CapabilityStatementKind-list',
        'type' => 'string',
      ),
    ),
    ),
    'EventCapabilityMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventCapabilityMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventCapabilityMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceVersionPolicy' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceVersionPolicy',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ResourceVersionPolicy-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'RestfulCapabilityMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRestfulCapabilityMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RestfulCapabilityMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'TypeRestfulInteraction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTypeRestfulInteraction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'TypeRestfulInteraction-list',
        'type' => 'string',
      ),
    ),
    ),
    'SystemRestfulInteraction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSystemRestfulInteraction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SystemRestfulInteraction-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConditionalReadStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalReadStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionalReadStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ReferenceHandlingPolicy' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceHandlingPolicy',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ReferenceHandlingPolicy-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConditionalDeleteStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalDeleteStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionalDeleteStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlan' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCarePlan',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestStatus',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'CarePlanIntent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanIntent',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contributor' =>
      array (
        'setter' => 'addContributor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'addresses' =>
      array (
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'goal' =>
      array (
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'activity' =>
      array (
        'setter' => 'addActivity',
        'element' => 'CarePlan.Activity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CarePlan.Activity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'outcomeCodeableConcept' =>
      array (
        'setter' => 'addOutcomeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcomeReference' =>
      array (
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'progress' =>
      array (
        'setter' => 'addProgress',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'CarePlan.Detail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail',
      ),
    ),
    ),
    'CarePlan.Detail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'CarePlanActivityKind',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityKind',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'goal' =>
      array (
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CarePlanActivityStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doNotPerform' =>
      array (
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'scheduledTiming' =>
      array (
        'setter' => 'setScheduledTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'scheduledPeriod' =>
      array (
        'setter' => 'setScheduledPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'scheduledString' =>
      array (
        'setter' => 'setScheduledString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productCodeableConcept' =>
      array (
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productReference' =>
      array (
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'dailyAmount' =>
      array (
        'setter' => 'setDailyAmount',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CarePlanActivityKind' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityKind',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanActivityKind-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlanActivityStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanActivityStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlanIntent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanIntent',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanIntent-list',
        'type' => 'string',
      ),
    ),
    ),
    'RequestStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CareTeam' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCareTeam',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CareTeamStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCareTeamStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'CareTeam.Participant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'addManagingOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CareTeam.Participant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'member' =>
      array (
        'setter' => 'setMember',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'CareTeamStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCareTeamStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CareTeamStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CatalogEntry' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCatalogEntry',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'orderable' =>
      array (
        'setter' => 'setOrderable',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'referencedItem' =>
      array (
        'setter' => 'setReferencedItem',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'additionalIdentifier' =>
      array (
        'setter' => 'addAdditionalIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'classification' =>
      array (
        'setter' => 'addClassification',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'validityPeriod' =>
      array (
        'setter' => 'setValidityPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'validTo' =>
      array (
        'setter' => 'setValidTo',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'lastUpdated' =>
      array (
        'setter' => 'setLastUpdated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'additionalCharacteristic' =>
      array (
        'setter' => 'addAdditionalCharacteristic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'additionalClassification' =>
      array (
        'setter' => 'addAdditionalClassification',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'relatedEntry' =>
      array (
        'setter' => 'addRelatedEntry',
        'element' => 'CatalogEntry.RelatedEntry',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCatalogEntry\\FHIRCatalogEntryRelatedEntry',
      ),
    ),
    ),
    'CatalogEntry.RelatedEntry' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCatalogEntry\\FHIRCatalogEntryRelatedEntry',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'relationtype' =>
      array (
        'setter' => 'setRelationtype',
        'element' => 'CatalogEntryRelationType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCatalogEntryRelationType',
      ),
      'item' =>
      array (
        'setter' => 'setItem',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CatalogEntryRelationType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCatalogEntryRelationType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CatalogEntryRelationType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ChargeItem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItem',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'definitionUri' =>
      array (
        'setter' => 'addDefinitionUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'definitionCanonical' =>
      array (
        'setter' => 'addDefinitionCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ChargeItemStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRChargeItemStatus',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'occurrenceTiming' =>
      array (
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'ChargeItem.Performer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemPerformer',
      ),
      'performingOrganization' =>
      array (
        'setter' => 'setPerformingOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'requestingOrganization' =>
      array (
        'setter' => 'setRequestingOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'costCenter' =>
      array (
        'setter' => 'setCostCenter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'bodysite' =>
      array (
        'setter' => 'addBodysite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'factorOverride' =>
      array (
        'setter' => 'setFactorOverride',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'priceOverride' =>
      array (
        'setter' => 'setPriceOverride',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'overrideReason' =>
      array (
        'setter' => 'setOverrideReason',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'enteredDate' =>
      array (
        'setter' => 'setEnteredDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'addService',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productReference' =>
      array (
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productCodeableConcept' =>
      array (
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ChargeItem.Performer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemPerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'function' =>
      array (
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ChargeItemStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRChargeItemStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ChargeItemStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ChargeItemDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItemDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'derivedFromUri' =>
      array (
        'setter' => 'addDerivedFromUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'instance' =>
      array (
        'setter' => 'addInstance',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'applicability' =>
      array (
        'setter' => 'addApplicability',
        'element' => 'ChargeItemDefinition.Applicability',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionApplicability',
      ),
      'propertyGroup' =>
      array (
        'setter' => 'addPropertyGroup',
        'element' => 'ChargeItemDefinition.PropertyGroup',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPropertyGroup',
      ),
    ),
    ),
    'ChargeItemDefinition.Applicability' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionApplicability',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ChargeItemDefinition.PropertyGroup' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPropertyGroup',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'applicability' =>
      array (
        'setter' => 'addApplicability',
        'element' => 'ChargeItemDefinition.Applicability',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionApplicability',
      ),
      'priceComponent' =>
      array (
        'setter' => 'addPriceComponent',
        'element' => 'ChargeItemDefinition.PriceComponent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPriceComponent',
      ),
    ),
    ),
    'ChargeItemDefinition.PriceComponent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPriceComponent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'InvoicePriceComponentType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoicePriceComponentType',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'InvoicePriceComponentType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoicePriceComponentType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'InvoicePriceComponentType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Claim' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaim',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUse',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'billablePeriod' =>
      array (
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fundsReserve' =>
      array (
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'Claim.Related',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimRelated',
      ),
      'prescription' =>
      array (
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'originalPrescription' =>
      array (
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'payee' =>
      array (
        'setter' => 'setPayee',
        'element' => 'Claim.Payee',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimPayee',
      ),
      'referral' =>
      array (
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'Claim.CareTeam',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Claim.SupportingInfo',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSupportingInfo',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'Claim.Diagnosis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis',
      ),
      'procedure' =>
      array (
        'setter' => 'addProcedure',
        'element' => 'Claim.Procedure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'Claim.Insurance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance',
      ),
      'accident' =>
      array (
        'setter' => 'setAccident',
        'element' => 'Claim.Accident',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimAccident',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'Claim.Item',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimItem',
      ),
      'total' =>
      array (
        'setter' => 'setTotal',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'Claim.Related' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'Claim.Payee' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimPayee',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.CareTeam' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualification' =>
      array (
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.SupportingInfo' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSupportingInfo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'timingDate' =>
      array (
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.Diagnosis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisCodeableConcept' =>
      array (
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosisReference' =>
      array (
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'onAdmission' =>
      array (
        'setter' => 'setOnAdmission',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'packageCode' =>
      array (
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.Procedure' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'procedureCodeableConcept' =>
      array (
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'procedureReference' =>
      array (
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Insurance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Accident' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimAccident',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Item' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'careTeamSequence' =>
      array (
        'setter' => 'addCareTeamSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisSequence' =>
      array (
        'setter' => 'addDiagnosisSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'procedureSequence' =>
      array (
        'setter' => 'addProcedureSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'informationSequence' =>
      array (
        'setter' => 'addInformationSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'encounter' =>
      array (
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Claim.Detail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDetail',
      ),
    ),
    ),
    'Claim.Detail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'Claim.SubDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail',
      ),
    ),
    ),
    'Claim.SubDetail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Use' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'Use-list',
        'type' => 'string',
      ),
    ),
    ),
    'FinancialResourceStatusCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FinancialResourceStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ClaimResponse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaimResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUse',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'requestor' =>
      array (
        'setter' => 'setRequestor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'ClaimProcessingCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClaimProcessingCodes',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'setPreAuthRef',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'preAuthPeriod' =>
      array (
        'setter' => 'setPreAuthPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'payeeType' =>
      array (
        'setter' => 'setPayeeType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'ClaimResponse.Item',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem',
      ),
      'addItem' =>
      array (
        'setter' => 'addAddItem',
        'element' => 'ClaimResponse.AddItem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'total' =>
      array (
        'setter' => 'addTotal',
        'element' => 'ClaimResponse.Total',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseTotal',
      ),
      'payment' =>
      array (
        'setter' => 'setPayment',
        'element' => 'ClaimResponse.Payment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment',
      ),
      'fundsReserve' =>
      array (
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'formCode' =>
      array (
        'setter' => 'setFormCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'processNote' =>
      array (
        'setter' => 'addProcessNote',
        'element' => 'ClaimResponse.ProcessNote',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote',
      ),
      'communicationRequest' =>
      array (
        'setter' => 'addCommunicationRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'ClaimResponse.Insurance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance',
      ),
      'error' =>
      array (
        'setter' => 'addError',
        'element' => 'ClaimResponse.Error',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError',
      ),
    ),
    ),
    'ClaimResponse.Item' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'itemSequence' =>
      array (
        'setter' => 'setItemSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail',
      ),
    ),
    ),
    'ClaimResponse.Adjudication' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'ClaimResponse.Detail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'detailSequence' =>
      array (
        'setter' => 'setDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ClaimResponse.SubDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail',
      ),
    ),
    ),
    'ClaimResponse.SubDetail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'subDetailSequence' =>
      array (
        'setter' => 'setSubDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
    ),
    ),
    'ClaimResponse.AddItem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'itemSequence' =>
      array (
        'setter' => 'addItemSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'detailSequence' =>
      array (
        'setter' => 'addDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'subdetailSequence' =>
      array (
        'setter' => 'addSubdetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'addProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1',
      ),
    ),
    ),
    'ClaimResponse.Detail1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ClaimResponse.SubDetail1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail1',
      ),
    ),
    ),
    'ClaimResponse.SubDetail1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
    ),
    ),
    'ClaimResponse.Total' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseTotal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'ClaimResponse.Payment' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'adjustment' =>
      array (
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'adjustmentReason' =>
      array (
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ClaimResponse.ProcessNote' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'NoteType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNoteType',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ClaimResponse.Insurance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ClaimResponse.Error' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'itemSequence' =>
      array (
        'setter' => 'setItemSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'detailSequence' =>
      array (
        'setter' => 'setDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'subDetailSequence' =>
      array (
        'setter' => 'setSubDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ClaimProcessingCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClaimProcessingCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ClaimProcessingCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ClinicalImpression' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClinicalImpression',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ClinicalImpressionStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClinicalImpressionStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'assessor' =>
      array (
        'setter' => 'setAssessor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'previous' =>
      array (
        'setter' => 'setPrevious',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'problem' =>
      array (
        'setter' => 'addProblem',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'investigation' =>
      array (
        'setter' => 'addInvestigation',
        'element' => 'ClinicalImpression.Investigation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation',
      ),
      'protocol' =>
      array (
        'setter' => 'addProtocol',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'summary' =>
      array (
        'setter' => 'setSummary',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'finding' =>
      array (
        'setter' => 'addFinding',
        'element' => 'ClinicalImpression.Finding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding',
      ),
      'prognosisCodeableConcept' =>
      array (
        'setter' => 'addPrognosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'prognosisReference' =>
      array (
        'setter' => 'addPrognosisReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'ClinicalImpression.Investigation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ClinicalImpression.Finding' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'itemCodeableConcept' =>
      array (
        'setter' => 'setItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'itemReference' =>
      array (
        'setter' => 'setItemReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'basis' =>
      array (
        'setter' => 'setBasis',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ClinicalImpressionStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClinicalImpressionStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ClinicalImpressionStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCodeSystem',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'caseSensitive' =>
      array (
        'setter' => 'setCaseSensitive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'hierarchyMeaning' =>
      array (
        'setter' => 'setHierarchyMeaning',
        'element' => 'CodeSystemHierarchyMeaning',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemHierarchyMeaning',
      ),
      'compositional' =>
      array (
        'setter' => 'setCompositional',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'versionNeeded' =>
      array (
        'setter' => 'setVersionNeeded',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'content' =>
      array (
        'setter' => 'setContent',
        'element' => 'CodeSystemContentMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemContentMode',
      ),
      'supplements' =>
      array (
        'setter' => 'setSupplements',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'filter' =>
      array (
        'setter' => 'addFilter',
        'element' => 'CodeSystem.Filter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty',
      ),
      'concept' =>
      array (
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
      ),
    ),
    ),
    'CodeSystem.Filter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'operator' =>
      array (
        'setter' => 'addOperator',
        'element' => 'FilterOperator',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFilterOperator',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CodeSystem.Property' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'PropertyType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyType',
      ),
    ),
    ),
    'CodeSystem.Concept' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'designation' =>
      array (
        'setter' => 'addDesignation',
        'element' => 'CodeSystem.Designation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1',
      ),
      'concept' =>
      array (
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
      ),
    ),
    ),
    'CodeSystem.Designation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CodeSystem.Property1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'FilterOperator' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFilterOperator',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FilterOperator-list',
        'type' => 'string',
      ),
    ),
    ),
    'PropertyType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PropertyType-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystemHierarchyMeaning' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemHierarchyMeaning',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CodeSystemHierarchyMeaning-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystemContentMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemContentMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CodeSystemContentMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'Communication' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunication',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'inResponseTo' =>
      array (
        'setter' => 'addInResponseTo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EventStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority',
      ),
      'medium' =>
      array (
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'topic' =>
      array (
        'setter' => 'setTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'about' =>
      array (
        'setter' => 'addAbout',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'sent' =>
      array (
        'setter' => 'setSent',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'received' =>
      array (
        'setter' => 'setReceived',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'sender' =>
      array (
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'payload' =>
      array (
        'setter' => 'addPayload',
        'element' => 'Communication.Payload',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'Communication.Payload' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'contentString' =>
      array (
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EventStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CommunicationRequest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunicationRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'groupIdentifier' =>
      array (
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority',
      ),
      'doNotPerform' =>
      array (
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'medium' =>
      array (
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'about' =>
      array (
        'setter' => 'addAbout',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'payload' =>
      array (
        'setter' => 'addPayload',
        'element' => 'CommunicationRequest.Payload',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'authoredOn' =>
      array (
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'requester' =>
      array (
        'setter' => 'setRequester',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'sender' =>
      array (
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CommunicationRequest.Payload' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'contentString' =>
      array (
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CompartmentDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCompartmentDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompartmentType',
      ),
      'search' =>
      array (
        'setter' => 'setSearch',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'CompartmentDefinition.Resource',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource',
      ),
    ),
    ),
    'CompartmentDefinition.Resource' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'param' =>
      array (
        'setter' => 'addParam',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CompartmentType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompartmentType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompartmentType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Composition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRComposition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CompositionStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'confidentiality' =>
      array (
        'setter' => 'setConfidentiality',
        'element' => 'vConfidentialityClassification',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVConfidentialityClassification',
      ),
      'attester' =>
      array (
        'setter' => 'addAttester',
        'element' => 'Composition.Attester',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester',
      ),
      'custodian' =>
      array (
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'relatesTo' =>
      array (
        'setter' => 'addRelatesTo',
        'element' => 'Composition.RelatesTo',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'Composition.Event',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent',
      ),
      'section' =>
      array (
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
      ),
    ),
    ),
    'Composition.Attester' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'CompositionAttestationMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionAttestationMode',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.RelatesTo' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentRelationshipType',
      ),
      'targetIdentifier' =>
      array (
        'setter' => 'setTargetIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'targetReference' =>
      array (
        'setter' => 'setTargetReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.Event' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.Section' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'focus' =>
      array (
        'setter' => 'setFocus',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'ListMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRListMode',
      ),
      'orderedBy' =>
      array (
        'setter' => 'setOrderedBy',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'entry' =>
      array (
        'setter' => 'addEntry',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'emptyReason' =>
      array (
        'setter' => 'setEmptyReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'section' =>
      array (
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
      ),
    ),
    ),
    'vConfidentialityClassification' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVConfidentialityClassification',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'vConfidentialityClassification-list',
        'type' => 'string',
      ),
    ),
    ),
    'CompositionStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompositionStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentRelationshipType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentRelationshipType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentRelationshipType-list',
        'type' => 'string',
      ),
    ),
    ),
    'CompositionAttestationMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionAttestationMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompositionAttestationMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ListMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRListMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ListMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConceptMap' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConceptMap',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'sourceUri' =>
      array (
        'setter' => 'setSourceUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'sourceCanonical' =>
      array (
        'setter' => 'setSourceCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'targetUri' =>
      array (
        'setter' => 'setTargetUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'targetCanonical' =>
      array (
        'setter' => 'setTargetCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'ConceptMap.Group',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup',
      ),
    ),
    ),
    'ConceptMap.Group' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'sourceVersion' =>
      array (
        'setter' => 'setSourceVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'targetVersion' =>
      array (
        'setter' => 'setTargetVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'element' =>
      array (
        'setter' => 'addElement',
        'element' => 'ConceptMap.Element',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement',
      ),
      'unmapped' =>
      array (
        'setter' => 'setUnmapped',
        'element' => 'ConceptMap.Unmapped',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped',
      ),
    ),
    ),
    'ConceptMap.Element' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'addTarget',
        'element' => 'ConceptMap.Target',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget',
      ),
    ),
    ),
    'ConceptMap.Target' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'equivalence' =>
      array (
        'setter' => 'setEquivalence',
        'element' => 'ConceptMapEquivalence',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapEquivalence',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'dependsOn' =>
      array (
        'setter' => 'addDependsOn',
        'element' => 'ConceptMap.DependsOn',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
      ),
      'product' =>
      array (
        'setter' => 'addProduct',
        'element' => 'ConceptMap.DependsOn',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
      ),
    ),
    ),
    'ConceptMap.DependsOn' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'property' =>
      array (
        'setter' => 'setProperty',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ConceptMap.Unmapped' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'ConceptMapGroupUnmappedMode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapGroupUnmappedMode',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ConceptMapGroupUnmappedMode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapGroupUnmappedMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConceptMapGroupUnmappedMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'Condition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCondition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'clinicalStatus' =>
      array (
        'setter' => 'setClinicalStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'verificationStatus' =>
      array (
        'setter' => 'setVerificationStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'bodySite' =>
      array (
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'onsetDateTime' =>
      array (
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'abatementDateTime' =>
      array (
        'setter' => 'setAbatementDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'abatementAge' =>
      array (
        'setter' => 'setAbatementAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'abatementPeriod' =>
      array (
        'setter' => 'setAbatementPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'abatementRange' =>
      array (
        'setter' => 'setAbatementRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'abatementString' =>
      array (
        'setter' => 'setAbatementString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'recordedDate' =>
      array (
        'setter' => 'setRecordedDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'asserter' =>
      array (
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'stage' =>
      array (
        'setter' => 'addStage',
        'element' => 'Condition.Stage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionStage',
      ),
      'evidence' =>
      array (
        'setter' => 'addEvidence',
        'element' => 'Condition.Evidence',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'Condition.Stage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionStage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'summary' =>
      array (
        'setter' => 'setSummary',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'assessment' =>
      array (
        'setter' => 'addAssessment',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Condition.Evidence' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Consent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConsent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ConsentState',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentState',
      ),
      'scope' =>
      array (
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'dateTime' =>
      array (
        'setter' => 'setDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'addOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'sourceAttachment' =>
      array (
        'setter' => 'setSourceAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'sourceReference' =>
      array (
        'setter' => 'setSourceReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'policy' =>
      array (
        'setter' => 'addPolicy',
        'element' => 'Consent.Policy',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy',
      ),
      'policyRule' =>
      array (
        'setter' => 'setPolicyRule',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'verification' =>
      array (
        'setter' => 'addVerification',
        'element' => 'Consent.Verification',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentVerification',
      ),
      'provision' =>
      array (
        'setter' => 'setProvision',
        'element' => 'Consent.Provision',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentProvision',
      ),
    ),
    ),
    'Consent.Policy' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'Consent.Verification' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentVerification',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'verified' =>
      array (
        'setter' => 'setVerified',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'verifiedWith' =>
      array (
        'setter' => 'setVerifiedWith',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'verificationDate' =>
      array (
        'setter' => 'setVerificationDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Consent.Provision' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentProvision',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ConsentProvisionType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentProvisionType',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'actor' =>
      array (
        'setter' => 'addActor',
        'element' => 'Consent.Actor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentActor',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'purpose' =>
      array (
        'setter' => 'addPurpose',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'class' =>
      array (
        'setter' => 'addClass',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dataPeriod' =>
      array (
        'setter' => 'setDataPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'data' =>
      array (
        'setter' => 'addData',
        'element' => 'Consent.Data',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentData',
      ),
      'provision' =>
      array (
        'setter' => 'addProvision',
        'element' => 'Consent.Provision',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentProvision',
      ),
    ),
    ),
    'Consent.Actor' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentActor',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Consent.Data' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentData',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'meaning' =>
      array (
        'setter' => 'setMeaning',
        'element' => 'ConsentDataMeaning',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentDataMeaning',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ConsentProvisionType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentProvisionType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentProvisionType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConsentDataMeaning' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentDataMeaning',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentDataMeaning-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConsentState' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentState',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentState-list',
        'type' => 'string',
      ),
    ),
    ),
    'Contract' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRContract',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ContractResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourceStatusCodes',
      ),
      'legalState' =>
      array (
        'setter' => 'setLegalState',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'setInstantiatesCanonical',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'setInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'contentDerivative' =>
      array (
        'setter' => 'setContentDerivative',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'applies' =>
      array (
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'expirationType' =>
      array (
        'setter' => 'setExpirationType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'addSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'authority' =>
      array (
        'setter' => 'addAuthority',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'domain' =>
      array (
        'setter' => 'addDomain',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'site' =>
      array (
        'setter' => 'addSite',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subtitle' =>
      array (
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'scope' =>
      array (
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topicCodeableConcept' =>
      array (
        'setter' => 'setTopicCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topicReference' =>
      array (
        'setter' => 'setTopicReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'addSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contentDefinition' =>
      array (
        'setter' => 'setContentDefinition',
        'element' => 'Contract.ContentDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContentDefinition',
      ),
      'term' =>
      array (
        'setter' => 'addTerm',
        'element' => 'Contract.Term',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractTerm',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'relevantHistory' =>
      array (
        'setter' => 'addRelevantHistory',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'signer' =>
      array (
        'setter' => 'addSigner',
        'element' => 'Contract.Signer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSigner',
      ),
      'friendly' =>
      array (
        'setter' => 'addFriendly',
        'element' => 'Contract.Friendly',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractFriendly',
      ),
      'legal' =>
      array (
        'setter' => 'addLegal',
        'element' => 'Contract.Legal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractLegal',
      ),
      'rule' =>
      array (
        'setter' => 'addRule',
        'element' => 'Contract.Rule',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractRule',
      ),
      'legallyBindingAttachment' =>
      array (
        'setter' => 'setLegallyBindingAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'legallyBindingReference' =>
      array (
        'setter' => 'setLegallyBindingReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.ContentDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContentDefinition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'publicationDate' =>
      array (
        'setter' => 'setPublicationDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publicationStatus' =>
      array (
        'setter' => 'setPublicationStatus',
        'element' => 'ContractResourcePublicationStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourcePublicationStatusCodes',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'Contract.Term' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractTerm',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'applies' =>
      array (
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topicCodeableConcept' =>
      array (
        'setter' => 'setTopicCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topicReference' =>
      array (
        'setter' => 'setTopicReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Contract.SecurityLabel',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSecurityLabel',
      ),
      'offer' =>
      array (
        'setter' => 'setOffer',
        'element' => 'Contract.Offer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractOffer',
      ),
      'asset' =>
      array (
        'setter' => 'addAsset',
        'element' => 'Contract.Asset',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAsset',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'Contract.Action',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAction',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'Contract.Term',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractTerm',
      ),
    ),
    ),
    'Contract.SecurityLabel' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSecurityLabel',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'addNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'classification' =>
      array (
        'setter' => 'setClassification',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'control' =>
      array (
        'setter' => 'addControl',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'Contract.Offer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractOffer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'party' =>
      array (
        'setter' => 'addParty',
        'element' => 'Contract.Party',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractParty',
      ),
      'topic' =>
      array (
        'setter' => 'setTopic',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'decision' =>
      array (
        'setter' => 'setDecision',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'decisionMode' =>
      array (
        'setter' => 'addDecisionMode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'answer' =>
      array (
        'setter' => 'addAnswer',
        'element' => 'Contract.Answer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAnswer',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'linkId' =>
      array (
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'securityLabelNumber' =>
      array (
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
    ),
    ),
    'Contract.Party' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractParty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'reference' =>
      array (
        'setter' => 'addReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Contract.Answer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAnswer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.Asset' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAsset',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'scope' =>
      array (
        'setter' => 'setScope',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'typeReference' =>
      array (
        'setter' => 'addTypeReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'subtype' =>
      array (
        'setter' => 'addSubtype',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'context' =>
      array (
        'setter' => 'addContext',
        'element' => 'Contract.Context',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContext',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'periodType' =>
      array (
        'setter' => 'addPeriodType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'addPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'usePeriod' =>
      array (
        'setter' => 'addUsePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'linkId' =>
      array (
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'answer' =>
      array (
        'setter' => 'addAnswer',
        'element' => 'Contract.Answer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAnswer',
      ),
      'securityLabelNumber' =>
      array (
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valuedItem' =>
      array (
        'setter' => 'addValuedItem',
        'element' => 'Contract.ValuedItem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractValuedItem',
      ),
    ),
    ),
    'Contract.Context' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContext',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Contract.ValuedItem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractValuedItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'entityCodeableConcept' =>
      array (
        'setter' => 'setEntityCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'entityReference' =>
      array (
        'setter' => 'setEntityReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'effectiveTime' =>
      array (
        'setter' => 'setEffectiveTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'points' =>
      array (
        'setter' => 'setPoints',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'payment' =>
      array (
        'setter' => 'setPayment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'paymentDate' =>
      array (
        'setter' => 'setPaymentDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'setRecipient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'linkId' =>
      array (
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'securityLabelNumber' =>
      array (
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
    ),
    ),
    'Contract.Action' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'doNotPerform' =>
      array (
        'setter' => 'setDoNotPerform',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'addSubject',
        'element' => 'Contract.Subject',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSubject',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'linkId' =>
      array (
        'setter' => 'addLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contextLinkId' =>
      array (
        'setter' => 'addContextLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'occurrenceTiming' =>
      array (
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'requester' =>
      array (
        'setter' => 'addRequester',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'requesterLinkId' =>
      array (
        'setter' => 'addRequesterLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'performerType' =>
      array (
        'setter' => 'addPerformerType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'performerRole' =>
      array (
        'setter' => 'setPerformerRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'performerLinkId' =>
      array (
        'setter' => 'addPerformerLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reasonLinkId' =>
      array (
        'setter' => 'addReasonLinkId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'securityLabelNumber' =>
      array (
        'setter' => 'addSecurityLabelNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
    ),
    ),
    'Contract.Subject' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSubject',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'reference' =>
      array (
        'setter' => 'addReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Contract.Signer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSigner',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'signature' =>
      array (
        'setter' => 'addSignature',
        'element' => 'Signature',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature',
      ),
    ),
    ),
    'Contract.Friendly' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractFriendly',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.Legal' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractLegal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.Rule' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractRule',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ContractResourceStatusCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourceStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContractResourceStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContractResourcePublicationStatusCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourcePublicationStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContractResourcePublicationStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'Coverage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverage',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'policyHolder' =>
      array (
        'setter' => 'setPolicyHolder',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'subscriber' =>
      array (
        'setter' => 'setSubscriber',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'subscriberId' =>
      array (
        'setter' => 'setSubscriberId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'beneficiary' =>
      array (
        'setter' => 'setBeneficiary',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'dependent' =>
      array (
        'setter' => 'setDependent',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'payor' =>
      array (
        'setter' => 'addPayor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'class' =>
      array (
        'setter' => 'addClass',
        'element' => 'Coverage.Class',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageClass',
      ),
      'order' =>
      array (
        'setter' => 'setOrder',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'costToBeneficiary' =>
      array (
        'setter' => 'addCostToBeneficiary',
        'element' => 'Coverage.CostToBeneficiary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageCostToBeneficiary',
      ),
      'subrogation' =>
      array (
        'setter' => 'setSubrogation',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'contract' =>
      array (
        'setter' => 'addContract',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Coverage.Class' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageClass',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Coverage.CostToBeneficiary' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageCostToBeneficiary',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'exception' =>
      array (
        'setter' => 'addException',
        'element' => 'Coverage.Exception',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageException',
      ),
    ),
    ),
    'Coverage.Exception' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageException',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'CoverageEligibilityRequest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'addPurpose',
        'element' => 'EligibilityRequestPurpose',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityRequestPurpose',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'CoverageEligibilityRequest.SupportingInfo',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestSupportingInfo',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'CoverageEligibilityRequest.Insurance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestInsurance',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'CoverageEligibilityRequest.Item',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestItem',
      ),
    ),
    ),
    'CoverageEligibilityRequest.SupportingInfo' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestSupportingInfo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'information' =>
      array (
        'setter' => 'setInformation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'appliesToAll' =>
      array (
        'setter' => 'setAppliesToAll',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'CoverageEligibilityRequest.Insurance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CoverageEligibilityRequest.Item' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'supportingInfoSequence' =>
      array (
        'setter' => 'addSupportingInfoSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'CoverageEligibilityRequest.Diagnosis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestDiagnosis',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CoverageEligibilityRequest.Diagnosis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'diagnosisCodeableConcept' =>
      array (
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosisReference' =>
      array (
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EligibilityRequestPurpose' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityRequestPurpose',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EligibilityRequestPurpose-list',
        'type' => 'string',
      ),
    ),
    ),
    'CoverageEligibilityResponse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'purpose' =>
      array (
        'setter' => 'addPurpose',
        'element' => 'EligibilityResponsePurpose',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityResponsePurpose',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'requestor' =>
      array (
        'setter' => 'setRequestor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'RemittanceOutcome',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRemittanceOutcome',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'CoverageEligibilityResponse.Insurance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseInsurance',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'setPreAuthRef',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'error' =>
      array (
        'setter' => 'addError',
        'element' => 'CoverageEligibilityResponse.Error',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseError',
      ),
    ),
    ),
    'CoverageEligibilityResponse.Insurance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'inforce' =>
      array (
        'setter' => 'setInforce',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'benefitPeriod' =>
      array (
        'setter' => 'setBenefitPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'CoverageEligibilityResponse.Item',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseItem',
      ),
    ),
    ),
    'CoverageEligibilityResponse.Item' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'excluded' =>
      array (
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'term' =>
      array (
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'benefit' =>
      array (
        'setter' => 'addBenefit',
        'element' => 'CoverageEligibilityResponse.Benefit',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseBenefit',
      ),
      'authorizationRequired' =>
      array (
        'setter' => 'setAuthorizationRequired',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'authorizationSupporting' =>
      array (
        'setter' => 'addAuthorizationSupporting',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'authorizationUrl' =>
      array (
        'setter' => 'setAuthorizationUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'CoverageEligibilityResponse.Benefit' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseBenefit',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'allowedUnsignedInt' =>
      array (
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'allowedString' =>
      array (
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'allowedMoney' =>
      array (
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'usedUnsignedInt' =>
      array (
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'usedString' =>
      array (
        'setter' => 'setUsedString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'usedMoney' =>
      array (
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'CoverageEligibilityResponse.Error' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseError',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'EligibilityResponsePurpose' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityResponsePurpose',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EligibilityResponsePurpose-list',
        'type' => 'string',
      ),
    ),
    ),
    'DetectedIssue' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDetectedIssue',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ObservationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRObservationStatus',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'DetectedIssueSeverity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDetectedIssueSeverity',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'identifiedDateTime' =>
      array (
        'setter' => 'setIdentifiedDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'identifiedPeriod' =>
      array (
        'setter' => 'setIdentifiedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'implicated' =>
      array (
        'setter' => 'addImplicated',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'evidence' =>
      array (
        'setter' => 'addEvidence',
        'element' => 'DetectedIssue.Evidence',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueEvidence',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'mitigation' =>
      array (
        'setter' => 'addMitigation',
        'element' => 'DetectedIssue.Mitigation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation',
      ),
    ),
    ),
    'DetectedIssue.Evidence' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueEvidence',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DetectedIssue.Mitigation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'action' =>
      array (
        'setter' => 'setAction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ObservationStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRObservationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ObservationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DetectedIssueSeverity' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDetectedIssueSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DetectedIssueSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'Device' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDevice',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'udiCarrier' =>
      array (
        'setter' => 'addUdiCarrier',
        'element' => 'Device.UdiCarrier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceUdiCarrier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FHIRDeviceStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRDeviceStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'addStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'distinctIdentifier' =>
      array (
        'setter' => 'setDistinctIdentifier',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'manufacturer' =>
      array (
        'setter' => 'setManufacturer',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'manufactureDate' =>
      array (
        'setter' => 'setManufactureDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'expirationDate' =>
      array (
        'setter' => 'setExpirationDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'lotNumber' =>
      array (
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'serialNumber' =>
      array (
        'setter' => 'setSerialNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'deviceName' =>
      array (
        'setter' => 'addDeviceName',
        'element' => 'Device.DeviceName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceDeviceName',
      ),
      'modelNumber' =>
      array (
        'setter' => 'setModelNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'partNumber' =>
      array (
        'setter' => 'setPartNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialization' =>
      array (
        'setter' => 'addSpecialization',
        'element' => 'Device.Specialization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceSpecialization',
      ),
      'version' =>
      array (
        'setter' => 'addVersion',
        'element' => 'Device.Version',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceVersion',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'Device.Property',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceProperty',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'owner' =>
      array (
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'safety' =>
      array (
        'setter' => 'addSafety',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'parent' =>
      array (
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Device.UdiCarrier' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceUdiCarrier',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'deviceIdentifier' =>
      array (
        'setter' => 'setDeviceIdentifier',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'issuer' =>
      array (
        'setter' => 'setIssuer',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'setJurisdiction',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'carrierAIDC' =>
      array (
        'setter' => 'setCarrierAIDC',
        'element' => 'base64Binary',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary',
      ),
      'carrierHRF' =>
      array (
        'setter' => 'setCarrierHRF',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'entryType' =>
      array (
        'setter' => 'setEntryType',
        'element' => 'UDIEntryType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUDIEntryType',
      ),
    ),
    ),
    'Device.DeviceName' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceDeviceName',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DeviceNameType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceNameType',
      ),
    ),
    ),
    'Device.Specialization' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceSpecialization',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'systemType' =>
      array (
        'setter' => 'setSystemType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Device.Version' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceVersion',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'component' =>
      array (
        'setter' => 'setComponent',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Device.Property' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceProperty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'addValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueCode' =>
      array (
        'setter' => 'addValueCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'FHIRDeviceStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRDeviceStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FHIRDeviceStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceNameType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceNameType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceNameType-list',
        'type' => 'string',
      ),
    ),
    ),
    'UDIEntryType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUDIEntryType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'UDIEntryType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'udiDeviceIdentifier' =>
      array (
        'setter' => 'addUdiDeviceIdentifier',
        'element' => 'DeviceDefinition.UdiDeviceIdentifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionUdiDeviceIdentifier',
      ),
      'manufacturerString' =>
      array (
        'setter' => 'setManufacturerString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'manufacturerReference' =>
      array (
        'setter' => 'setManufacturerReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'deviceName' =>
      array (
        'setter' => 'addDeviceName',
        'element' => 'DeviceDefinition.DeviceName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionDeviceName',
      ),
      'modelNumber' =>
      array (
        'setter' => 'setModelNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialization' =>
      array (
        'setter' => 'addSpecialization',
        'element' => 'DeviceDefinition.Specialization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionSpecialization',
      ),
      'version' =>
      array (
        'setter' => 'addVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'safety' =>
      array (
        'setter' => 'addSafety',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'shelfLifeStorage' =>
      array (
        'setter' => 'addShelfLifeStorage',
        'element' => 'ProductShelfLife',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProductShelfLife',
      ),
      'physicalCharacteristics' =>
      array (
        'setter' => 'setPhysicalCharacteristics',
        'element' => 'ProdCharacteristic',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProdCharacteristic',
      ),
      'languageCode' =>
      array (
        'setter' => 'addLanguageCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'capability' =>
      array (
        'setter' => 'addCapability',
        'element' => 'DeviceDefinition.Capability',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionCapability',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'DeviceDefinition.Property',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionProperty',
      ),
      'owner' =>
      array (
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'onlineInformation' =>
      array (
        'setter' => 'setOnlineInformation',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'parentDevice' =>
      array (
        'setter' => 'setParentDevice',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'material' =>
      array (
        'setter' => 'addMaterial',
        'element' => 'DeviceDefinition.Material',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionMaterial',
      ),
    ),
    ),
    'DeviceDefinition.UdiDeviceIdentifier' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionUdiDeviceIdentifier',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'deviceIdentifier' =>
      array (
        'setter' => 'setDeviceIdentifier',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'issuer' =>
      array (
        'setter' => 'setIssuer',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'setJurisdiction',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'DeviceDefinition.DeviceName' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionDeviceName',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DeviceNameType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceNameType',
      ),
    ),
    ),
    'DeviceDefinition.Specialization' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionSpecialization',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'systemType' =>
      array (
        'setter' => 'setSystemType',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'DeviceDefinition.Capability' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionCapability',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'addDescription',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'DeviceDefinition.Property' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionProperty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'addValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueCode' =>
      array (
        'setter' => 'addValueCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'DeviceDefinition.Material' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionMaterial',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'substance' =>
      array (
        'setter' => 'setSubstance',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'alternate' =>
      array (
        'setter' => 'setAlternate',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'allergenicIndicator' =>
      array (
        'setter' => 'setAllergenicIndicator',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'DeviceMetric' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceMetric',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'parent' =>
      array (
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'operationalStatus' =>
      array (
        'setter' => 'setOperationalStatus',
        'element' => 'DeviceMetricOperationalStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricOperationalStatus',
      ),
      'color' =>
      array (
        'setter' => 'setColor',
        'element' => 'DeviceMetricColor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricColor',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'DeviceMetricCategory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCategory',
      ),
      'measurementPeriod' =>
      array (
        'setter' => 'setMeasurementPeriod',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'calibration' =>
      array (
        'setter' => 'addCalibration',
        'element' => 'DeviceMetric.Calibration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration',
      ),
    ),
    ),
    'DeviceMetric.Calibration' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DeviceMetricCalibrationType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationType',
      ),
      'state' =>
      array (
        'setter' => 'setState',
        'element' => 'DeviceMetricCalibrationState',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationState',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
    ),
    ),
    'DeviceMetricCalibrationType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricColor' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricColor',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricColor-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricCalibrationState' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationState',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationState-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricOperationalStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricOperationalStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricOperationalStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricCategory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceRequest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'priorRequest' =>
      array (
        'setter' => 'addPriorRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'groupIdentifier' =>
      array (
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestStatus',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'RequestIntent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestIntent',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority',
      ),
      'codeReference' =>
      array (
        'setter' => 'setCodeReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'codeCodeableConcept' =>
      array (
        'setter' => 'setCodeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'parameter' =>
      array (
        'setter' => 'addParameter',
        'element' => 'DeviceRequest.Parameter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestParameter',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'occurrenceTiming' =>
      array (
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'authoredOn' =>
      array (
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'requester' =>
      array (
        'setter' => 'setRequester',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'performerType' =>
      array (
        'setter' => 'setPerformerType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'relevantHistory' =>
      array (
        'setter' => 'addRelevantHistory',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DeviceRequest.Parameter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestParameter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'DeviceUseStatement' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceUseStatement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DeviceUseStatementStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceUseStatementStatus',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'derivedFrom' =>
      array (
        'setter' => 'addDerivedFrom',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'timingTiming' =>
      array (
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'timingDateTime' =>
      array (
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'recordedOn' =>
      array (
        'setter' => 'setRecordedOn',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'DeviceUseStatementStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceUseStatementStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceUseStatementStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DiagnosticReport' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDiagnosticReport',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DiagnosticReportStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiagnosticReportStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'resultsInterpreter' =>
      array (
        'setter' => 'addResultsInterpreter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'specimen' =>
      array (
        'setter' => 'addSpecimen',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'result' =>
      array (
        'setter' => 'addResult',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'imagingStudy' =>
      array (
        'setter' => 'addImagingStudy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'media' =>
      array (
        'setter' => 'addMedia',
        'element' => 'DiagnosticReport.Media',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportMedia',
      ),
      'conclusion' =>
      array (
        'setter' => 'setConclusion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'conclusionCode' =>
      array (
        'setter' => 'addConclusionCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'presentedForm' =>
      array (
        'setter' => 'addPresentedForm',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
    ),
    ),
    'DiagnosticReport.Media' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportMedia',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'link' =>
      array (
        'setter' => 'setLink',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DiagnosticReportStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiagnosticReportStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DiagnosticReportStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentManifest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentManifest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'masterIdentifier' =>
      array (
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentReferenceStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'DocumentManifest.Related',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated',
      ),
    ),
    ),
    'DocumentManifest.Related' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'ref' =>
      array (
        'setter' => 'setRef',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DocumentReference' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentReference',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'masterIdentifier' =>
      array (
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentReferenceStatus',
      ),
      'docStatus' =>
      array (
        'setter' => 'setDocStatus',
        'element' => 'CompositionStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'instant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'authenticator' =>
      array (
        'setter' => 'setAuthenticator',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'custodian' =>
      array (
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'relatesTo' =>
      array (
        'setter' => 'addRelatesTo',
        'element' => 'DocumentReference.RelatesTo',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'DocumentReference.Content',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'DocumentReference.Context',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext',
      ),
    ),
    ),
    'DocumentReference.RelatesTo' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentRelationshipType',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DocumentReference.Content' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'attachment' =>
      array (
        'setter' => 'setAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'format' =>
      array (
        'setter' => 'setFormat',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'DocumentReference.Context' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'encounter' =>
      array (
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'facilityType' =>
      array (
        'setter' => 'setFacilityType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'practiceSetting' =>
      array (
        'setter' => 'setPracticeSetting',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'sourcePatientInfo' =>
      array (
        'setter' => 'setSourcePatientInfo',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EffectEvidenceSynthesis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREffectEvidenceSynthesis',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'editor' =>
      array (
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'reviewer' =>
      array (
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'endorser' =>
      array (
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'synthesisType' =>
      array (
        'setter' => 'setSynthesisType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'studyType' =>
      array (
        'setter' => 'setStudyType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'population' =>
      array (
        'setter' => 'setPopulation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'exposure' =>
      array (
        'setter' => 'setExposure',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'exposureAlternative' =>
      array (
        'setter' => 'setExposureAlternative',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'sampleSize' =>
      array (
        'setter' => 'setSampleSize',
        'element' => 'EffectEvidenceSynthesis.SampleSize',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisSampleSize',
      ),
      'resultsByExposure' =>
      array (
        'setter' => 'addResultsByExposure',
        'element' => 'EffectEvidenceSynthesis.ResultsByExposure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisResultsByExposure',
      ),
      'effectEstimate' =>
      array (
        'setter' => 'addEffectEstimate',
        'element' => 'EffectEvidenceSynthesis.EffectEstimate',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisEffectEstimate',
      ),
      'certainty' =>
      array (
        'setter' => 'addCertainty',
        'element' => 'EffectEvidenceSynthesis.Certainty',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertainty',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.SampleSize' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisSampleSize',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'numberOfStudies' =>
      array (
        'setter' => 'setNumberOfStudies',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'numberOfParticipants' =>
      array (
        'setter' => 'setNumberOfParticipants',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.ResultsByExposure' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisResultsByExposure',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'exposureState' =>
      array (
        'setter' => 'setExposureState',
        'element' => 'ExposureState',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExposureState',
      ),
      'variantState' =>
      array (
        'setter' => 'setVariantState',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'riskEvidenceSynthesis' =>
      array (
        'setter' => 'setRiskEvidenceSynthesis',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.EffectEstimate' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisEffectEstimate',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'variantState' =>
      array (
        'setter' => 'setVariantState',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'unitOfMeasure' =>
      array (
        'setter' => 'setUnitOfMeasure',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'precisionEstimate' =>
      array (
        'setter' => 'addPrecisionEstimate',
        'element' => 'EffectEvidenceSynthesis.PrecisionEstimate',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisPrecisionEstimate',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.PrecisionEstimate' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisPrecisionEstimate',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'level' =>
      array (
        'setter' => 'setLevel',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'from' =>
      array (
        'setter' => 'setFrom',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'to' =>
      array (
        'setter' => 'setTo',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.Certainty' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertainty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'rating' =>
      array (
        'setter' => 'addRating',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'certaintySubcomponent' =>
      array (
        'setter' => 'addCertaintySubcomponent',
        'element' => 'EffectEvidenceSynthesis.CertaintySubcomponent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertaintySubcomponent',
      ),
    ),
    ),
    'EffectEvidenceSynthesis.CertaintySubcomponent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertaintySubcomponent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'rating' =>
      array (
        'setter' => 'addRating',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'ExposureState' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExposureState',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ExposureState-list',
        'type' => 'string',
      ),
    ),
    ),
    'Encounter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREncounter',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterStatus',
      ),
      'statusHistory' =>
      array (
        'setter' => 'addStatusHistory',
        'element' => 'Encounter.StatusHistory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'classHistory' =>
      array (
        'setter' => 'addClassHistory',
        'element' => 'Encounter.ClassHistory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'serviceType' =>
      array (
        'setter' => 'setServiceType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'episodeOfCare' =>
      array (
        'setter' => 'addEpisodeOfCare',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'Encounter.Participant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant',
      ),
      'appointment' =>
      array (
        'setter' => 'addAppointment',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'length' =>
      array (
        'setter' => 'setLength',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'Encounter.Diagnosis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'hospitalization' =>
      array (
        'setter' => 'setHospitalization',
        'element' => 'Encounter.Hospitalization',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization',
      ),
      'location' =>
      array (
        'setter' => 'addLocation',
        'element' => 'Encounter.Location',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterLocation',
      ),
      'serviceProvider' =>
      array (
        'setter' => 'setServiceProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Encounter.StatusHistory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Encounter.ClassHistory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Encounter.Participant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'individual' =>
      array (
        'setter' => 'setIndividual',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Encounter.Diagnosis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'Encounter.Hospitalization' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'preAdmissionIdentifier' =>
      array (
        'setter' => 'setPreAdmissionIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'origin' =>
      array (
        'setter' => 'setOrigin',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'admitSource' =>
      array (
        'setter' => 'setAdmitSource',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reAdmission' =>
      array (
        'setter' => 'setReAdmission',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dietPreference' =>
      array (
        'setter' => 'addDietPreference',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialCourtesy' =>
      array (
        'setter' => 'addSpecialCourtesy',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialArrangement' =>
      array (
        'setter' => 'addSpecialArrangement',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'destination' =>
      array (
        'setter' => 'setDestination',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'dischargeDisposition' =>
      array (
        'setter' => 'setDischargeDisposition',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Encounter.Location' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterLocation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterLocationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterLocationStatus',
      ),
      'physicalType' =>
      array (
        'setter' => 'setPhysicalType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'EncounterLocationStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterLocationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EncounterLocationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'EncounterStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EncounterStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Endpoint' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREndpoint',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EndpointStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREndpointStatus',
      ),
      'connectionType' =>
      array (
        'setter' => 'setConnectionType',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'payloadType' =>
      array (
        'setter' => 'addPayloadType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'payloadMimeType' =>
      array (
        'setter' => 'addPayloadMimeType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'header' =>
      array (
        'setter' => 'addHeader',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'EndpointStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREndpointStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EndpointStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'EnrollmentRequest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'candidate' =>
      array (
        'setter' => 'setCandidate',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EnrollmentResponse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'RemittanceOutcome',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRemittanceOutcome',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'requestProvider' =>
      array (
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EpisodeOfCare' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREpisodeOfCare',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREpisodeOfCareStatus',
      ),
      'statusHistory' =>
      array (
        'setter' => 'addStatusHistory',
        'element' => 'EpisodeOfCare.StatusHistory',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'EpisodeOfCare.Diagnosis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'referralRequest' =>
      array (
        'setter' => 'addReferralRequest',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'careManager' =>
      array (
        'setter' => 'setCareManager',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'team' =>
      array (
        'setter' => 'addTeam',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EpisodeOfCare.StatusHistory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREpisodeOfCareStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'EpisodeOfCare.Diagnosis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'EpisodeOfCareStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREpisodeOfCareStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EpisodeOfCareStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'EventDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREventDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subtitle' =>
      array (
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'subjectCodeableConcept' =>
      array (
        'setter' => 'setSubjectCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subjectReference' =>
      array (
        'setter' => 'setSubjectReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'editor' =>
      array (
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'reviewer' =>
      array (
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'endorser' =>
      array (
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'trigger' =>
      array (
        'setter' => 'addTrigger',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
    ),
    ),
    'Evidence' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidence',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'shortTitle' =>
      array (
        'setter' => 'setShortTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subtitle' =>
      array (
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'editor' =>
      array (
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'reviewer' =>
      array (
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'endorser' =>
      array (
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'exposureBackground' =>
      array (
        'setter' => 'setExposureBackground',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'exposureVariant' =>
      array (
        'setter' => 'addExposureVariant',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'addOutcome',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EvidenceVariable' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidenceVariable',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'shortTitle' =>
      array (
        'setter' => 'setShortTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'subtitle' =>
      array (
        'setter' => 'setSubtitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'editor' =>
      array (
        'setter' => 'addEditor',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'reviewer' =>
      array (
        'setter' => 'addReviewer',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'endorser' =>
      array (
        'setter' => 'addEndorser',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'EvidenceVariableType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREvidenceVariableType',
      ),
      'characteristic' =>
      array (
        'setter' => 'addCharacteristic',
        'element' => 'EvidenceVariable.Characteristic',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREvidenceVariable\\FHIREvidenceVariableCharacteristic',
      ),
    ),
    ),
    'EvidenceVariable.Characteristic' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREvidenceVariable\\FHIREvidenceVariableCharacteristic',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'definitionReference' =>
      array (
        'setter' => 'setDefinitionReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'definitionCanonical' =>
      array (
        'setter' => 'setDefinitionCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'definitionCodeableConcept' =>
      array (
        'setter' => 'setDefinitionCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'definitionExpression' =>
      array (
        'setter' => 'setDefinitionExpression',
        'element' => 'Expression',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression',
      ),
      'definitionDataRequirement' =>
      array (
        'setter' => 'setDefinitionDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
      'definitionTriggerDefinition' =>
      array (
        'setter' => 'setDefinitionTriggerDefinition',
        'element' => 'TriggerDefinition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition',
      ),
      'usageContext' =>
      array (
        'setter' => 'addUsageContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'exclude' =>
      array (
        'setter' => 'setExclude',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'participantEffectiveDateTime' =>
      array (
        'setter' => 'setParticipantEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'participantEffectivePeriod' =>
      array (
        'setter' => 'setParticipantEffectivePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'participantEffectiveDuration' =>
      array (
        'setter' => 'setParticipantEffectiveDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'participantEffectiveTiming' =>
      array (
        'setter' => 'setParticipantEffectiveTiming',
        'element' => 'Timing',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming',
      ),
      'timeFromStart' =>
      array (
        'setter' => 'setTimeFromStart',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'groupMeasure' =>
      array (
        'setter' => 'setGroupMeasure',
        'element' => 'GroupMeasure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupMeasure',
      ),
    ),
    ),
    'EvidenceVariableType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREvidenceVariableType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EvidenceVariableType-list',
        'type' => 'string',
      ),
    ),
    ),
    'GroupMeasure' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupMeasure',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GroupMeasure-list',
        'type' => 'string',
      ),
    ),
    ),
    'ExampleScenario' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExampleScenario',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'actor' =>
      array (
        'setter' => 'addActor',
        'element' => 'ExampleScenario.Actor',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioActor',
      ),
      'instance' =>
      array (
        'setter' => 'addInstance',
        'element' => 'ExampleScenario.Instance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioInstance',
      ),
      'process' =>
      array (
        'setter' => 'addProcess',
        'element' => 'ExampleScenario.Process',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioProcess',
      ),
      'workflow' =>
      array (
        'setter' => 'addWorkflow',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ExampleScenario.Actor' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioActor',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'actorId' =>
      array (
        'setter' => 'setActorId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ExampleScenarioActorType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExampleScenarioActorType',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'ExampleScenario.Instance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioInstance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'resourceId' =>
      array (
        'setter' => 'setResourceId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'resourceType' =>
      array (
        'setter' => 'setResourceType',
        'element' => 'ResourceType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceType',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'version' =>
      array (
        'setter' => 'addVersion',
        'element' => 'ExampleScenario.Version',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioVersion',
      ),
      'containedInstance' =>
      array (
        'setter' => 'addContainedInstance',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioContainedInstance',
      ),
    ),
    ),
    'ExampleScenario.Version' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioVersion',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'versionId' =>
      array (
        'setter' => 'setVersionId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'ExampleScenario.ContainedInstance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioContainedInstance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'resourceId' =>
      array (
        'setter' => 'setResourceId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'versionId' =>
      array (
        'setter' => 'setVersionId',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ExampleScenario.Process' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioProcess',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'preConditions' =>
      array (
        'setter' => 'setPreConditions',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'postConditions' =>
      array (
        'setter' => 'setPostConditions',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'step' =>
      array (
        'setter' => 'addStep',
        'element' => 'ExampleScenario.Step',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioStep',
      ),
    ),
    ),
    'ExampleScenario.Step' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioStep',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'process' =>
      array (
        'setter' => 'addProcess',
        'element' => 'ExampleScenario.Process',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioProcess',
      ),
      'pause' =>
      array (
        'setter' => 'setPause',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'operation' =>
      array (
        'setter' => 'setOperation',
        'element' => 'ExampleScenario.Operation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioOperation',
      ),
      'alternative' =>
      array (
        'setter' => 'addAlternative',
        'element' => 'ExampleScenario.Alternative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioAlternative',
      ),
    ),
    ),
    'ExampleScenario.Operation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioOperation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'initiator' =>
      array (
        'setter' => 'setInitiator',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'receiver' =>
      array (
        'setter' => 'setReceiver',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'initiatorActive' =>
      array (
        'setter' => 'setInitiatorActive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'receiverActive' =>
      array (
        'setter' => 'setReceiverActive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioContainedInstance',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'ExampleScenario.ContainedInstance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioContainedInstance',
      ),
    ),
    ),
    'ExampleScenario.Alternative' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioAlternative',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'step' =>
      array (
        'setter' => 'addStep',
        'element' => 'ExampleScenario.Step',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioStep',
      ),
    ),
    ),
    'ExampleScenarioActorType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExampleScenarioActorType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ExampleScenarioActorType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ResourceType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ExplanationOfBenefit' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExplanationOfBenefit',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ExplanationOfBenefitStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExplanationOfBenefitStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUse',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'billablePeriod' =>
      array (
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fundsReserveRequested' =>
      array (
        'setter' => 'setFundsReserveRequested',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fundsReserve' =>
      array (
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'ExplanationOfBenefit.Related',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated',
      ),
      'prescription' =>
      array (
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'originalPrescription' =>
      array (
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'payee' =>
      array (
        'setter' => 'setPayee',
        'element' => 'ExplanationOfBenefit.Payee',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee',
      ),
      'referral' =>
      array (
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'ClaimProcessingCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClaimProcessingCodes',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'preAuthRefPeriod' =>
      array (
        'setter' => 'addPreAuthRefPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'ExplanationOfBenefit.CareTeam',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'ExplanationOfBenefit.SupportingInfo',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSupportingInfo',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'ExplanationOfBenefit.Diagnosis',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis',
      ),
      'procedure' =>
      array (
        'setter' => 'addProcedure',
        'element' => 'ExplanationOfBenefit.Procedure',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure',
      ),
      'precedence' =>
      array (
        'setter' => 'setPrecedence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'ExplanationOfBenefit.Insurance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance',
      ),
      'accident' =>
      array (
        'setter' => 'setAccident',
        'element' => 'ExplanationOfBenefit.Accident',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'ExplanationOfBenefit.Item',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem',
      ),
      'addItem' =>
      array (
        'setter' => 'addAddItem',
        'element' => 'ExplanationOfBenefit.AddItem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'total' =>
      array (
        'setter' => 'addTotal',
        'element' => 'ExplanationOfBenefit.Total',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitTotal',
      ),
      'payment' =>
      array (
        'setter' => 'setPayment',
        'element' => 'ExplanationOfBenefit.Payment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment',
      ),
      'formCode' =>
      array (
        'setter' => 'setFormCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'processNote' =>
      array (
        'setter' => 'addProcessNote',
        'element' => 'ExplanationOfBenefit.ProcessNote',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote',
      ),
      'benefitPeriod' =>
      array (
        'setter' => 'setBenefitPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'benefitBalance' =>
      array (
        'setter' => 'addBenefitBalance',
        'element' => 'ExplanationOfBenefit.BenefitBalance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance',
      ),
    ),
    ),
    'ExplanationOfBenefit.Related' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ExplanationOfBenefit.Payee' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.CareTeam' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualification' =>
      array (
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.SupportingInfo' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSupportingInfo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'timingDate' =>
      array (
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'ExplanationOfBenefit.Diagnosis' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisCodeableConcept' =>
      array (
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosisReference' =>
      array (
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'onAdmission' =>
      array (
        'setter' => 'setOnAdmission',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'packageCode' =>
      array (
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.Procedure' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'procedureCodeableConcept' =>
      array (
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'procedureReference' =>
      array (
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.Insurance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ExplanationOfBenefit.Accident' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.Item' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'careTeamSequence' =>
      array (
        'setter' => 'addCareTeamSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisSequence' =>
      array (
        'setter' => 'addDiagnosisSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'procedureSequence' =>
      array (
        'setter' => 'addProcedureSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'informationSequence' =>
      array (
        'setter' => 'addInformationSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'encounter' =>
      array (
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail',
      ),
    ),
    ),
    'ExplanationOfBenefit.Adjudication' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'ExplanationOfBenefit.Detail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ExplanationOfBenefit.SubDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail',
      ),
    ),
    ),
    'ExplanationOfBenefit.SubDetail' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
    ),
    ),
    'ExplanationOfBenefit.AddItem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'itemSequence' =>
      array (
        'setter' => 'addItemSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'detailSequence' =>
      array (
        'setter' => 'addDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'subDetailSequence' =>
      array (
        'setter' => 'addSubDetailSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'addProvider',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1',
      ),
    ),
    ),
    'ExplanationOfBenefit.Detail1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ExplanationOfBenefit.SubDetail1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail1',
      ),
    ),
    ),
    'ExplanationOfBenefit.SubDetail1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'productOrService' =>
      array (
        'setter' => 'setProductOrService',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
    ),
    ),
    'ExplanationOfBenefit.Total' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitTotal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'ExplanationOfBenefit.Payment' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'adjustment' =>
      array (
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'adjustmentReason' =>
      array (
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ExplanationOfBenefit.ProcessNote' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'NoteType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNoteType',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.BenefitBalance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'excluded' =>
      array (
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'term' =>
      array (
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'financial' =>
      array (
        'setter' => 'addFinancial',
        'element' => 'ExplanationOfBenefit.Financial',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial',
      ),
    ),
    ),
    'ExplanationOfBenefit.Financial' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'allowedUnsignedInt' =>
      array (
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'allowedString' =>
      array (
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'allowedMoney' =>
      array (
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'usedUnsignedInt' =>
      array (
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'usedMoney' =>
      array (
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'ExplanationOfBenefitStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExplanationOfBenefitStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ExplanationOfBenefitStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'FamilyMemberHistory' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFamilyMemberHistory',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'instantiatesCanonical' =>
      array (
        'setter' => 'addInstantiatesCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'instantiatesUri' =>
      array (
        'setter' => 'addInstantiatesUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FamilyHistoryStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFamilyHistoryStatus',
      ),
      'dataAbsentReason' =>
      array (
        'setter' => 'setDataAbsentReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'sex' =>
      array (
        'setter' => 'setSex',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'bornPeriod' =>
      array (
        'setter' => 'setBornPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'bornDate' =>
      array (
        'setter' => 'setBornDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'bornString' =>
      array (
        'setter' => 'setBornString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'ageAge' =>
      array (
        'setter' => 'setAgeAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'ageRange' =>
      array (
        'setter' => 'setAgeRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'ageString' =>
      array (
        'setter' => 'setAgeString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'estimatedAge' =>
      array (
        'setter' => 'setEstimatedAge',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'deceasedBoolean' =>
      array (
        'setter' => 'setDeceasedBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'deceasedAge' =>
      array (
        'setter' => 'setDeceasedAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'deceasedRange' =>
      array (
        'setter' => 'setDeceasedRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'deceasedDate' =>
      array (
        'setter' => 'setDeceasedDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'deceasedString' =>
      array (
        'setter' => 'setDeceasedString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'condition' =>
      array (
        'setter' => 'addCondition',
        'element' => 'FamilyMemberHistory.Condition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition',
      ),
    ),
    ),
    'FamilyMemberHistory.Condition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contributedToDeath' =>
      array (
        'setter' => 'setContributedToDeath',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'FamilyHistoryStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFamilyHistoryStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FamilyHistoryStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Flag' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFlag',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FlagStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFlagStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'FlagStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFlagStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FlagStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Goal' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGoal',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'lifecycleStatus' =>
      array (
        'setter' => 'setLifecycleStatus',
        'element' => 'GoalLifecycleStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGoalLifecycleStatus',
      ),
      'achievementStatus' =>
      array (
        'setter' => 'setAchievementStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'startDate' =>
      array (
        'setter' => 'setStartDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'startCodeableConcept' =>
      array (
        'setter' => 'setStartCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'target' =>
      array (
        'setter' => 'addTarget',
        'element' => 'Goal.Target',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGoal\\FHIRGoalTarget',
      ),
      'statusDate' =>
      array (
        'setter' => 'setStatusDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'expressedBy' =>
      array (
        'setter' => 'setExpressedBy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'addresses' =>
      array (
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'outcomeCode' =>
      array (
        'setter' => 'addOutcomeCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcomeReference' =>
      array (
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Goal.Target' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGoal\\FHIRGoalTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'measure' =>
      array (
        'setter' => 'setMeasure',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detailQuantity' =>
      array (
        'setter' => 'setDetailQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'detailRange' =>
      array (
        'setter' => 'setDetailRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'detailCodeableConcept' =>
      array (
        'setter' => 'setDetailCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detailString' =>
      array (
        'setter' => 'setDetailString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'detailBoolean' =>
      array (
        'setter' => 'setDetailBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'detailInteger' =>
      array (
        'setter' => 'setDetailInteger',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'detailRatio' =>
      array (
        'setter' => 'setDetailRatio',
        'element' => 'Ratio',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio',
      ),
      'dueDate' =>
      array (
        'setter' => 'setDueDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'dueDuration' =>
      array (
        'setter' => 'setDueDuration',
        'element' => 'Duration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
    ),
    ),
    'GoalLifecycleStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGoalLifecycleStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GoalLifecycleStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'GraphDefinition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGraphDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
      ),
    ),
    ),
    'GraphDefinition.Link' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'sliceName' =>
      array (
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'addTarget',
        'element' => 'GraphDefinition.Target',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget',
      ),
    ),
    ),
    'GraphDefinition.Target' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'params' =>
      array (
        'setter' => 'setParams',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'compartment' =>
      array (
        'setter' => 'addCompartment',
        'element' => 'GraphDefinition.Compartment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
      ),
    ),
    ),
    'GraphDefinition.Compartment' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'GraphCompartmentUse',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentUse',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompartmentType',
      ),
      'rule' =>
      array (
        'setter' => 'setRule',
        'element' => 'GraphCompartmentRule',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentRule',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'GraphCompartmentUse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GraphCompartmentUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'GraphCompartmentRule' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentRule',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GraphCompartmentRule-list',
        'type' => 'string',
      ),
    ),
    ),
    'Group' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGroup',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'GroupType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupType',
      ),
      'actual' =>
      array (
        'setter' => 'setActual',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'managingEntity' =>
      array (
        'setter' => 'setManagingEntity',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'characteristic' =>
      array (
        'setter' => 'addCharacteristic',
        'element' => 'Group.Characteristic',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic',
      ),
      'member' =>
      array (
        'setter' => 'addMember',
        'element' => 'Group.Member',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupMember',
      ),
    ),
    ),
    'Group.Characteristic' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'exclude' =>
      array (
        'setter' => 'setExclude',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Group.Member' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupMember',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'entity' =>
      array (
        'setter' => 'setEntity',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'inactive' =>
      array (
        'setter' => 'setInactive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'GroupType' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GroupType-list',
        'type' => 'string',
      ),
    ),
    ),
    'GuidanceResponse' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGuidanceResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'requestIdentifier' =>
      array (
        'setter' => 'setRequestIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'moduleUri' =>
      array (
        'setter' => 'setModuleUri',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'moduleCanonical' =>
      array (
        'setter' => 'setModuleCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'moduleCodeableConcept' =>
      array (
        'setter' => 'setModuleCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'GuidanceResponseStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidanceResponseStatus',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'evaluationMessage' =>
      array (
        'setter' => 'addEvaluationMessage',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'outputParameters' =>
      array (
        'setter' => 'setOutputParameters',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'result' =>
      array (
        'setter' => 'setResult',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'dataRequirement' =>
      array (
        'setter' => 'addDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement',
      ),
    ),
    ),
    'GuidanceResponseStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidanceResponseStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuidanceResponseStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'HealthcareService' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRHealthcareService',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'providedBy' =>
      array (
        'setter' => 'setProvidedBy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialty' =>
      array (
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'addLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'extraDetails' =>
      array (
        'setter' => 'setExtraDetails',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'photo' =>
      array (
        'setter' => 'setPhoto',
        'element' => 'Attachment',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'coverageArea' =>
      array (
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'serviceProvisionCode' =>
      array (
        'setter' => 'addServiceProvisionCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'eligibility' =>
      array (
        'setter' => 'addEligibility',
        'element' => 'HealthcareService.Eligibility',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceEligibility',
      ),
      'program' =>
      array (
        'setter' => 'addProgram',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'characteristic' =>
      array (
        'setter' => 'addCharacteristic',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'communication' =>
      array (
        'setter' => 'addCommunication',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'referralMethod' =>
      array (
        'setter' => 'addReferralMethod',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'appointmentRequired' =>
      array (
        'setter' => 'setAppointmentRequired',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'availableTime' =>
      array (
        'setter' => 'addAvailableTime',
        'element' => 'HealthcareService.AvailableTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime',
      ),
      'notAvailable' =>
      array (
        'setter' => 'addNotAvailable',
        'element' => 'HealthcareService.NotAvailable',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable',
      ),
      'availabilityExceptions' =>
      array (
        'setter' => 'setAvailabilityExceptions',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'HealthcareService.Eligibility' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceEligibility',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'HealthcareService.AvailableTime' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'daysOfWeek' =>
      array (
        'setter' => 'addDaysOfWeek',
        'element' => 'DaysOfWeek',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDaysOfWeek',
      ),
      'allDay' =>
      array (
        'setter' => 'setAllDay',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'availableStartTime' =>
      array (
        'setter' => 'setAvailableStartTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
      'availableEndTime' =>
      array (
        'setter' => 'setAvailableEndTime',
        'element' => 'time',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime',
      ),
    ),
    ),
    'HealthcareService.NotAvailable' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'during' =>
      array (
        'setter' => 'setDuring',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'DaysOfWeek' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDaysOfWeek',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DaysOfWeek-list',
        'type' => 'string',
      ),
    ),
    ),
    'ImagingStudy' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImagingStudy',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ImagingStudyStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImagingStudyStatus',
      ),
      'modality' =>
      array (
        'setter' => 'addModality',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'started' =>
      array (
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'referrer' =>
      array (
        'setter' => 'setReferrer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'interpreter' =>
      array (
        'setter' => 'addInterpreter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'numberOfSeries' =>
      array (
        'setter' => 'setNumberOfSeries',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'numberOfInstances' =>
      array (
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'procedureReference' =>
      array (
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'procedureCode' =>
      array (
        'setter' => 'addProcedureCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'series' =>
      array (
        'setter' => 'addSeries',
        'element' => 'ImagingStudy.Series',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries',
      ),
    ),
    ),
    'ImagingStudy.Series' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'modality' =>
      array (
        'setter' => 'setModality',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'numberOfInstances' =>
      array (
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'laterality' =>
      array (
        'setter' => 'setLaterality',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'specimen' =>
      array (
        'setter' => 'addSpecimen',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'started' =>
      array (
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'ImagingStudy.Performer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyPerformer',
      ),
      'instance' =>
      array (
        'setter' => 'addInstance',
        'element' => 'ImagingStudy.Instance',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance',
      ),
    ),
    ),
    'ImagingStudy.Performer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyPerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'function' =>
      array (
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ImagingStudy.Instance' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'sopClass' =>
      array (
        'setter' => 'setSopClass',
        'element' => 'Coding',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImagingStudyStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImagingStudyStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ImagingStudyStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Immunization' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunization',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ImmunizationStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationStatusCodes',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'vaccineCode' =>
      array (
        'setter' => 'setVaccineCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'occurrenceString' =>
      array (
        'setter' => 'setOccurrenceString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'recorded' =>
      array (
        'setter' => 'setRecorded',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'primarySource' =>
      array (
        'setter' => 'setPrimarySource',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'reportOrigin' =>
      array (
        'setter' => 'setReportOrigin',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'manufacturer' =>
      array (
        'setter' => 'setManufacturer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'lotNumber' =>
      array (
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'expirationDate' =>
      array (
        'setter' => 'setExpirationDate',
        'element' => 'date',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'route' =>
      array (
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseQuantity' =>
      array (
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Immunization.Performer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPerformer',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'isSubpotent' =>
      array (
        'setter' => 'setIsSubpotent',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'subpotentReason' =>
      array (
        'setter' => 'addSubpotentReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'education' =>
      array (
        'setter' => 'addEducation',
        'element' => 'Immunization.Education',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationEducation',
      ),
      'programEligibility' =>
      array (
        'setter' => 'addProgramEligibility',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fundingSource' =>
      array (
        'setter' => 'setFundingSource',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reaction' =>
      array (
        'setter' => 'addReaction',
        'element' => 'Immunization.Reaction',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction',
      ),
      'protocolApplied' =>
      array (
        'setter' => 'addProtocolApplied',
        'element' => 'Immunization.ProtocolApplied',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationProtocolApplied',
      ),
    ),
    ),
    'Immunization.Performer' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'function' =>
      array (
        'setter' => 'setFunction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Immunization.Education' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationEducation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'documentType' =>
      array (
        'setter' => 'setDocumentType',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'publicationDate' =>
      array (
        'setter' => 'setPublicationDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'presentationDate' =>
      array (
        'setter' => 'setPresentationDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Immunization.Reaction' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'reported' =>
      array (
        'setter' => 'setReported',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'Immunization.ProtocolApplied' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationProtocolApplied',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'series' =>
      array (
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'targetDisease' =>
      array (
        'setter' => 'addTargetDisease',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseNumberPositiveInt' =>
      array (
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'doseNumberString' =>
      array (
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'seriesDosesPositiveInt' =>
      array (
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'seriesDosesString' =>
      array (
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImmunizationStatusCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ImmunizationStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ImmunizationEvaluation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationEvaluation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ImmunizationEvaluationStatusCodes',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationEvaluationStatusCodes',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'targetDisease' =>
      array (
        'setter' => 'setTargetDisease',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'immunizationEvent' =>
      array (
        'setter' => 'setImmunizationEvent',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'doseStatus' =>
      array (
        'setter' => 'setDoseStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseStatusReason' =>
      array (
        'setter' => 'addDoseStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'series' =>
      array (
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'doseNumberPositiveInt' =>
      array (
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'doseNumberString' =>
      array (
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'seriesDosesPositiveInt' =>
      array (
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'seriesDosesString' =>
      array (
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImmunizationEvaluationStatusCodes' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationEvaluationStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ImmunizationEvaluationStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ImmunizationRecommendation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationRecommendation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'recommendation' =>
      array (
        'setter' => 'addRecommendation',
        'element' => 'ImmunizationRecommendation.Recommendation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation',
      ),
    ),
    ),
    'ImmunizationRecommendation.Recommendation' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'vaccineCode' =>
      array (
        'setter' => 'addVaccineCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'targetDisease' =>
      array (
        'setter' => 'setTargetDisease',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contraindicatedVaccineCode' =>
      array (
        'setter' => 'addContraindicatedVaccineCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'forecastStatus' =>
      array (
        'setter' => 'setForecastStatus',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'forecastReason' =>
      array (
        'setter' => 'addForecastReason',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dateCriterion' =>
      array (
        'setter' => 'addDateCriterion',
        'element' => 'ImmunizationRecommendation.DateCriterion',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'series' =>
      array (
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'doseNumberPositiveInt' =>
      array (
        'setter' => 'setDoseNumberPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'doseNumberString' =>
      array (
        'setter' => 'setDoseNumberString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'seriesDosesPositiveInt' =>
      array (
        'setter' => 'setSeriesDosesPositiveInt',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'seriesDosesString' =>
      array (
        'setter' => 'setSeriesDosesString',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'supportingImmunization' =>
      array (
        'setter' => 'addSupportingImmunization',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'supportingPatientInformation' =>
      array (
        'setter' => 'addSupportingPatientInformation',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ImmunizationRecommendation.DateCriterion' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'ImplementationGuide' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImplementationGuide',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'packageId' =>
      array (
        'setter' => 'setPackageId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'license' =>
      array (
        'setter' => 'setLicense',
        'element' => 'SPDXLicense',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSPDXLicense',
      ),
      'fhirVersion' =>
      array (
        'setter' => 'addFhirVersion',
        'element' => 'FHIRVersion',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRVersion',
      ),
      'dependsOn' =>
      array (
        'setter' => 'addDependsOn',
        'element' => 'ImplementationGuide.DependsOn',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependsOn',
      ),
      'global' =>
      array (
        'setter' => 'addGlobal',
        'element' => 'ImplementationGuide.Global',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'ImplementationGuide.Definition',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDefinition',
      ),
      'manifest' =>
      array (
        'setter' => 'setManifest',
        'element' => 'ImplementationGuide.Manifest',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideManifest',
      ),
    ),
    ),
    'ImplementationGuide.DependsOn' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependsOn',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'packageId' =>
      array (
        'setter' => 'setPackageId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide.Global' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
    ),
    ),
    'ImplementationGuide.Definition' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDefinition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'grouping' =>
      array (
        'setter' => 'addGrouping',
        'element' => 'ImplementationGuide.Grouping',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGrouping',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'ImplementationGuide.Resource',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource',
      ),
      'page' =>
      array (
        'setter' => 'setPage',
        'element' => 'ImplementationGuide.Page',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
      ),
      'parameter' =>
      array (
        'setter' => 'addParameter',
        'element' => 'ImplementationGuide.Parameter',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideParameter',
      ),
      'template' =>
      array (
        'setter' => 'addTemplate',
        'element' => 'ImplementationGuide.Template',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideTemplate',
      ),
    ),
    ),
    'ImplementationGuide.Grouping' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGrouping',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide.Resource' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'fhirVersion' =>
      array (
        'setter' => 'addFhirVersion',
        'element' => 'FHIRVersion',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRVersion',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'exampleBoolean' =>
      array (
        'setter' => 'setExampleBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'exampleCanonical' =>
      array (
        'setter' => 'setExampleCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'groupingId' =>
      array (
        'setter' => 'setGroupingId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
    ),
    ),
    'ImplementationGuide.Page' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'nameUrl' =>
      array (
        'setter' => 'setNameUrl',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'nameReference' =>
      array (
        'setter' => 'setNameReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'generation' =>
      array (
        'setter' => 'setGeneration',
        'element' => 'GuidePageGeneration',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidePageGeneration',
      ),
      'page' =>
      array (
        'setter' => 'addPage',
        'element' => 'ImplementationGuide.Page',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
      ),
    ),
    ),
    'ImplementationGuide.Parameter' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideParameter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'GuideParameterCode',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuideParameterCode',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide.Template' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideTemplate',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'scope' =>
      array (
        'setter' => 'setScope',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide.Manifest' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideManifest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'rendering' =>
      array (
        'setter' => 'setRendering',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'ImplementationGuide.Resource1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource1',
      ),
      'page' =>
      array (
        'setter' => 'addPage',
        'element' => 'ImplementationGuide.Page1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage1',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'other' =>
      array (
        'setter' => 'addOther',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide.Resource1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'exampleBoolean' =>
      array (
        'setter' => 'setExampleBoolean',
        'element' => 'boolean',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean',
      ),
      'exampleCanonical' =>
      array (
        'setter' => 'setExampleCanonical',
        'element' => 'canonical',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical',
      ),
      'relativePath' =>
      array (
        'setter' => 'setRelativePath',
        'element' => 'url',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl',
      ),
    ),
    ),
    'ImplementationGuide.Page1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'anchor' =>
      array (
        'setter' => 'addAnchor',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'GuideParameterCode' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuideParameterCode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuideParameterCode-list',
        'type' => 'string',
      ),
    ),
    ),
    'SPDXLicense' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSPDXLicense',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SPDXLicense-list',
        'type' => 'string',
      ),
    ),
    ),
    'GuidePageGeneration' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidePageGeneration',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuidePageGeneration-list',
        'type' => 'string',
      ),
    ),
    ),
    'InsurancePlan' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInsurancePlan',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod',
      ),
      'ownedBy' =>
      array (
        'setter' => 'setOwnedBy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'administeredBy' =>
      array (
        'setter' => 'setAdministeredBy',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'coverageArea' =>
      array (
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'InsurancePlan.Contact',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanContact',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'network' =>
      array (
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'coverage' =>
      array (
        'setter' => 'addCoverage',
        'element' => 'InsurancePlan.Coverage',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCoverage',
      ),
      'plan' =>
      array (
        'setter' => 'addPlan',
        'element' => 'InsurancePlan.Plan',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanPlan',
      ),
    ),
    ),
    'InsurancePlan.Contact' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanContact',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'HumanName',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress',
      ),
    ),
    ),
    'InsurancePlan.Coverage' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCoverage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'network' =>
      array (
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'benefit' =>
      array (
        'setter' => 'addBenefit',
        'element' => 'InsurancePlan.Benefit',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit',
      ),
    ),
    ),
    'InsurancePlan.Benefit' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'requirement' =>
      array (
        'setter' => 'setRequirement',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'limit' =>
      array (
        'setter' => 'addLimit',
        'element' => 'InsurancePlan.Limit',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanLimit',
      ),
    ),
    ),
    'InsurancePlan.Limit' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanLimit',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'InsurancePlan.Plan' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanPlan',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'coverageArea' =>
      array (
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'network' =>
      array (
        'setter' => 'addNetwork',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'generalCost' =>
      array (
        'setter' => 'addGeneralCost',
        'element' => 'InsurancePlan.GeneralCost',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanGeneralCost',
      ),
      'specificCost' =>
      array (
        'setter' => 'addSpecificCost',
        'element' => 'InsurancePlan.SpecificCost',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanSpecificCost',
      ),
    ),
    ),
    'InsurancePlan.GeneralCost' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanGeneralCost',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'groupSize' =>
      array (
        'setter' => 'setGroupSize',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'cost' =>
      array (
        'setter' => 'setCost',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'InsurancePlan.SpecificCost' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanSpecificCost',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'benefit' =>
      array (
        'setter' => 'addBenefit',
        'element' => 'InsurancePlan.Benefit1',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit1',
      ),
    ),
    ),
    'InsurancePlan.Benefit1' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'cost' =>
      array (
        'setter' => 'addCost',
        'element' => 'InsurancePlan.Cost',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCost',
      ),
    ),
    ),
    'InsurancePlan.Cost' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCost',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'applicability' =>
      array (
        'setter' => 'setApplicability',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualifiers' =>
      array (
        'setter' => 'addQualifiers',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'Quantity',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Invoice' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInvoice',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'InvoiceStatus',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoiceStatus',
      ),
      'cancelledReason' =>
      array (
        'setter' => 'setCancelledReason',
        'element' => 'string',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'setRecipient',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'Invoice.Participant',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceParticipant',
      ),
      'issuer' =>
      array (
        'setter' => 'setIssuer',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'account' =>
      array (
        'setter' => 'setAccount',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'lineItem' =>
      array (
        'setter' => 'addLineItem',
        'element' => 'Invoice.LineItem',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceLineItem',
      ),
      'totalPriceComponent' =>
      array (
        'setter' => 'addTotalPriceComponent',
        'element' => 'Invoice.PriceComponent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoicePriceComponent',
      ),
      'totalNet' =>
      array (
        'setter' => 'setTotalNet',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'totalGross' =>
      array (
        'setter' => 'setTotalGross',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
      'paymentTerms' =>
      array (
        'setter' => 'setPaymentTerms',
        'element' => 'markdown',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'Invoice.Participant' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Invoice.LineItem' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceLineItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt',
      ),
      'chargeItemReference' =>
      array (
        'setter' => 'setChargeItemReference',
        'element' => 'Reference',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference',
      ),
      'chargeItemCodeableConcept' =>
      array (
        'setter' => 'setChargeItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priceComponent' =>
      array (
        'setter' => 'addPriceComponent',
        'element' => 'Invoice.PriceComponent',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoicePriceComponent',
      ),
    ),
    ),
    'Invoice.PriceComponent' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoicePriceComponent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'InvoicePriceComponentType',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoicePriceComponentType',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney',
      ),
    ),
    ),
    'InvoiceStatus' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoiceStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'InvoiceStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Library' =>
    array (
    'fullClassName' => '\\OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLibrary',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative',
      